/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.utils;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.metamodel.Attribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class EntityNamesStringUtil {
    private static final TextPool mTextPool = TextPool.getInstance();
    public static final String BUSINES_ENTITY = "Entity Service";
    public static final String APPLICATION_SERVICE = "Application Service";
    public static final String EXTERNAL_SERVICE = "External Service";

    public static String isClassNameValid(String targetObjectName, String input, Collection checkifExists) {
        return EntityNamesStringUtil.isClassNameValid(targetObjectName, input, checkifExists, null, null, null, null, false);
    }

    public static String isClassNameValid(String targetObjectName, String input, Collection checkifExists, Collection applicationOrBusinessEntities, Collection coreApplications, Collection coreBusinessEntities, String applicationName, boolean isApplicationService) {
        String error = null;
        if (input.length() == 0) {
            error = mTextPool.getText("STRVALID.EMPTY.NAME", new Object[]{targetObjectName});
            return error;
        }
        if (input.length() > 38) {
            error = mTextPool.getText("STRVALID.LONG.NAME", new Object[]{targetObjectName, new Integer(38)});
            return error;
        }
        if (applicationOrBusinessEntities != null && EntityNamesStringUtil.containsString(applicationOrBusinessEntities, input, false)) {
            if (isApplicationService) {
                error = mTextPool.getText("STRVALID.EXISTING.NAME1");
                return error;
            }
            error = mTextPool.getText("STRVALID.EXISTING.NAME2");
            return error;
        }
        if (coreApplications != null && coreApplications.contains(input)) {
            error = mTextPool.getText("STRVALID.EXISTING.NAME3");
            return error;
        }
        if (coreBusinessEntities != null && coreBusinessEntities.contains(input)) {
            error = mTextPool.getText("STRVALID.EXISTING.NAME4");
            return error;
        }
        if (checkifExists != null && EntityNamesStringUtil.containsString(checkifExists, input, false)) {
            error = mTextPool.getText("STRVALID.EXISTING.NAME", new Object[]{targetObjectName});
            return error;
        }
        char firstCharName = input.charAt(0);
        if (firstCharName < 'A' || firstCharName > 'Z') {
            error = mTextPool.getText("STRVALID.INVALID.NAME", new Object[]{targetObjectName});
            return error;
        }
        int index = 0;
        while (index < input.length()) {
            char c = input.charAt(index);
            if (!Character.isJavaIdentifierPart(c)) {
                error = mTextPool.getText("STRVALID.INVALID2.NAME", new Object[]{targetObjectName});
                return error;
            }
            if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isDigit(c))) {
                error = mTextPool.getText("STRVALID.INVALID.NAME", new Object[]{targetObjectName});
                return error;
            }
            ++index;
        }
        if (applicationName != null) {
            String[] names = BOMSystem.getBomSystemNames();
            String appNameSearch = "~" + applicationName + "~metadata~";
            String appName = null;
            int i = 0;
            while (i < names.length) {
                if (names[i].indexOf(appNameSearch) > 0) {
                    appName = names[i];
                }
                ++i;
            }
            if (appName != null) {
                BOMSystem bomsystem = BOMSystem.getBOMSystem(appName);
                HashMap entityServices = bomsystem.getBusinessEntityInterfaces();
                HashMap appServices = bomsystem.getApplicationInterfaces();
                if (BUSINES_ENTITY.equals(targetObjectName)) {
                    String wrongName = input + "Service";
                    if (appServices.containsKey(wrongName)) {
                        error = mTextPool.getText("STRVALID.INVALID4.NAME", new Object[]{targetObjectName});
                        return error;
                    }
                } else if (APPLICATION_SERVICE.equals(targetObjectName) && input.endsWith("Service") && entityServices.containsKey(input.substring(0, input.length() - "Service".length()))) {
                    error = mTextPool.getText("STRVALID.INVALID4.NAME", new Object[]{targetObjectName});
                    return error;
                }
            }
        }
        return error;
    }

    public static String isMethodnameValid(String targetObjectName, String input) {
        String error = null;
        if (input.length() == 0) {
            error = mTextPool.getText("STRVALID.EMPTY.NAME", new Object[]{targetObjectName});
            return error;
        }
        int index = 0;
        while (index < input.length()) {
            if (!Character.isJavaIdentifierPart(input.charAt(index))) {
                error = mTextPool.getText("STRVALID.INVALID2.NAME", new Object[]{targetObjectName});
                return error;
            }
            ++index;
        }
        return error;
    }

    public static String isFieldNameValid(String targetObjectName, String input, Collection checkifExists) {
        String error = null;
        if (input.length() == 0) {
            error = mTextPool.getText("STRVALID.EMPTY.NAME", new Object[]{targetObjectName});
            return error;
        }
        char firstCharName = input.charAt(0);
        if (!Character.isJavaIdentifierStart(firstCharName)) {
            error = mTextPool.getText("STRVALID.INVALID3.NAME", new Object[]{targetObjectName});
            return error;
        }
        int index = 0;
        while (index < input.length()) {
            if (!Character.isJavaIdentifierPart(input.charAt(index))) {
                error = mTextPool.getText("STRVALID.INVALID2.NAME", new Object[]{targetObjectName});
                return error;
            }
            ++index;
        }
        if (checkifExists != null && checkifExists.contains(input)) {
            error = mTextPool.getText("STRVALID.EXISTING.NAME", new Object[]{targetObjectName});
            return error;
        }
        return error;
    }

    public static String resolveCoreFaultPackages(String originName) {
        if (originName == null) {
            return null;
        }
        String result = originName;
        int pos2 = originName.indexOf("/");
        int pos3 = originName.lastIndexOf("/");
        if (pos3 != -1 && pos2 != -1) {
            result = originName.substring(pos3 + 1, originName.length()) + "(" + originName.substring(pos2 + 1, pos3) + ")";
        }
        return result;
    }

    public static String resolveCoreFaultPackagesSP4(String originName) {
        if (originName == null) {
            return null;
        }
        String result = originName;
        int pos3 = originName.lastIndexOf("/");
        if (pos3 != -1) {
            result = originName.substring(pos3 + 1, originName.length());
        }
        return result;
    }

    public static String restoreCoreFaultPackages(String visualName) {
        if (visualName == null) {
            return null;
        }
        String result = visualName;
        int pos1 = visualName.indexOf("(");
        int pos2 = visualName.lastIndexOf("(");
        int pos3 = visualName.indexOf(")");
        if (pos3 != -1 && pos3 != -1 && pos2 != -1) {
            result = "sap.com/" + visualName.substring(pos2 + 1, pos3) + "/" + visualName.substring(pos1 + 1, pos2);
        }
        return result;
    }

    public static String restoreCoreFaultPackages2(String visualName) {
        if (visualName == null) {
            return null;
        }
        String result = visualName;
        int pos2 = visualName.indexOf("(");
        int pos3 = visualName.indexOf(")");
        if (pos3 != -1 && pos2 != -1) {
            result = "sap.com/" + visualName.substring(pos2 + 1, pos3) + "/" + visualName.substring(0, pos2);
        }
        return result;
    }

    public static String restoreCoreFaultPackagesSP4(String visualName, String appName) {
        if (visualName == null) {
            return null;
        }
        return "sap.com/" + appName + "/" + visualName;
    }

    public static String getAttributeSimpleTypeName(List attribs) {
        Collection atrnames = EntityNamesStringUtil.getAttributeNames(attribs);
        return EntityNamesStringUtil.getAttributeSimpleTypeName(atrnames);
    }

    public static String getAttributeDSName(String aTypeName, List attribs) {
        Collection atrnames = EntityNamesStringUtil.getAttributeNames(attribs);
        return EntityNamesStringUtil.getAttributeDSName(aTypeName, atrnames);
    }

    public static String getAttributeDSName(String aTypeName, Collection atrnames) {
        String typeName = aTypeName.substring(0, 1).toLowerCase() + aTypeName.substring(1, aTypeName.length());
        int index = 0;
        while (atrnames.contains(typeName + index)) {
            ++index;
        }
        return typeName + index;
    }

    public static String getAttributeSimpleTypeName(Collection atrnames) {
        String typeName = "arg";
        int index = 0;
        while (atrnames.contains(typeName + index)) {
            ++index;
        }
        return typeName + index;
    }

    private static Collection getAttributeNames(List attributtes) {
        ArrayList<String> atrNames = new ArrayList<String>();
        int i = 0;
        while (i < attributtes.size()) {
            atrNames.add(((Attribute)attributtes.get(i)).getObjectName());
            ++i;
        }
        return atrNames;
    }

    public static String compoundEntityName(String objectName, String entytyType, String appName) {
        return objectName;
    }

    public static String resolveOriginEntityName(String serviceName) {
        return serviceName;
    }

    public static boolean containsString(Collection col, String str, boolean caseSensitive) {
        Iterator i = col.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            if (!(caseSensitive ? str.equals(s) : str.equalsIgnoreCase(s))) continue;
            return true;
        }
        return false;
    }
}

