/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.utils;

import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DatasourceUtils {
    public static final byte INPUT_MSG = 1;
    public static final byte OUTPUT_MSG = 2;

    public static byte getMessageType(Operation op, Message msg) {
        if (op.getInput() != null && op.getInput().getObjectId().equals(msg.getObjectId())) {
            return 1;
        }
        if (op.getOutput() != null && op.getOutput().getObjectId().equals(msg.getObjectId())) {
            return 2;
        }
        return -1;
    }

    public static Attribute findAttributeByName(List attributes, String name) {
        Iterator i = attributes.iterator();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            if (!attr.getObjectName().equals(name)) continue;
            return attr;
        }
        return null;
    }

    public static List parseList(String str) {
        LinkedList<String> retVal = new LinkedList<String>();
        int i0 = 0;
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case ',': {
                    if (i > i0) {
                        retVal.add(str.substring(i0, i));
                    } else {
                        retVal.add(null);
                    }
                    i0 = i + 1;
                    break;
                }
            }
            ++i;
        }
        if (str.length() > i0) {
            retVal.add(str.substring(i0));
        } else {
            retVal.add(null);
        }
        return retVal;
    }

    public static List parseListAndUnquoteAndUnescape(String str) {
        LinkedList<String> retVal = new LinkedList<String>();
        int i0 = 0;
        boolean inQuotedString = false;
        int i = 0;
        while (i < str.length()) {
            if (!inQuotedString) {
                switch (str.charAt(i)) {
                    case ',': {
                        retVal.add(DatasourceUtils.unquoteAndUnescape(str.substring(i0, i)));
                        i0 = i + 1;
                        break;
                    }
                    case '\"': {
                        inQuotedString = true;
                        break;
                    }
                }
            } else {
                switch (str.charAt(i)) {
                    case '\\': {
                        ++i;
                        break;
                    }
                    case '\"': {
                        inQuotedString = false;
                        break;
                    }
                }
            }
            ++i;
        }
        retVal.add(DatasourceUtils.unquoteAndUnescape(str.substring(i0)));
        return retVal;
    }

    /*
     * WARNING - void declaration
     */
    public static List parseResolvedName(String resolvedName) {
        int slashPos;
        LinkedList<String> retVal = new LinkedList<String>();
        int prevSlashPos = 0;
        while ((slashPos = resolvedName.indexOf(47, prevSlashPos)) != -1) {
            void var3_3;
            retVal.add(resolvedName.substring(prevSlashPos, (int)var3_3));
            prevSlashPos = var3_3 + true;
        }
        retVal.add(resolvedName.substring(prevSlashPos));
        return retVal;
    }

    public static String quoteAndEscape(String str) {
        StringBuffer retVal = new StringBuffer();
        retVal.append('\"');
        int i = 0;
        while (i < str.length()) {
            switch (str.charAt(i)) {
                case '\"': {
                    retVal.append("\\\"");
                    break;
                }
                case '\\': {
                    retVal.append("\\\\");
                    break;
                }
                default: {
                    retVal.append(str.charAt(i));
                }
            }
            ++i;
        }
        retVal.append('\"');
        return retVal.toString();
    }

    public static String unquoteAndUnescape(String str) {
        if (str.length() == 0) {
            return null;
        }
        StringBuffer retVal = new StringBuffer();
        boolean inEscape = false;
        int i = 1;
        while (i < str.length() - 1) {
            if (inEscape) {
                retVal.append(str.charAt(i));
                inEscape = false;
            } else if (str.charAt(i) != '\\') {
                retVal.append(str.charAt(i));
            } else {
                inEscape = true;
            }
            ++i;
        }
        return retVal.toString();
    }
}

