/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.utils;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.generation.CAFProjectLocations;
import com.sap.caf.tools.velocity.utils.StringUtils;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DTRReplicatorList {
    private static final String ORIGINAL_FILE = "DTRReplicatorList.orig";
    private static final String BACKUP_FILE = "DTRReplicatorList.bckp";
    private static final String SUCCESS = "SUCCESS";
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$utils$ModifiedServicesList == null ? (class$com$sap$caf$designer$utils$ModifiedServicesList = DTRReplicatorList.class$("com.sap.caf.designer.utils.ModifiedServicesList")) : class$com$sap$caf$designer$utils$ModifiedServicesList);
    private HashSet hashSet;
    private String pathToGeneratedFilesList = "";
    private String pathToRoot = "";
    static /* synthetic */ Class class$com$sap$caf$designer$utils$ModifiedServicesList;

    public DTRReplicatorList(CAFProjectLocations cafProjectLocations) {
        this.pathToGeneratedFilesList = cafProjectLocations.getEarProjectPath();
        String path = cafProjectLocations.getEarProjectPath();
        if (path != null && path.lastIndexOf("/") != -1) {
            this.pathToRoot = path.substring(0, path.lastIndexOf("/"));
        }
        this.loadReplicatorList();
    }

    public Set getFileList() {
        return this.hashSet;
    }

    public synchronized void addToList(String file) {
        this.hashSet.add(this.filePathReplacer(file));
        this.saveReplicatorList();
    }

    public synchronized void addToList(List fileList) {
        if (fileList != null && !fileList.isEmpty()) {
            Iterator it = fileList.iterator();
            while (it.hasNext()) {
                this.hashSet.add(this.filePathReplacer((String)it.next()));
                this.saveReplicatorList();
            }
        }
    }

    public boolean contains(String file) {
        return this.hashSet.contains(this.filePathReplacer(file));
    }

    public synchronized void removeFormList(String file) {
        this.hashSet.remove(this.filePathReplacer(file));
        this.saveReplicatorList();
    }

    public void clearList() {
        this.hashSet.clear();
        this.saveReplicatorList();
    }

    /*
     * WARNING - void declaration
     */
    private void loadReplicatorList() {
        this.hashSet = new HashSet();
        try {
            File orig = new File(this.pathToGeneratedFilesList + "/" + ORIGINAL_FILE);
            if (!orig.exists() || !this.validFile(orig)) {
                orig = new File(this.pathToGeneratedFilesList + "/" + BACKUP_FILE);
            }
            if (orig.exists() && this.validFile(orig)) {
                String str;
                BufferedReader in = new BufferedReader(new FileReader(orig));
                while ((str = in.readLine()) != null) {
                    void var3_5;
                    if (SUCCESS.equalsIgnoreCase((String)var3_5)) continue;
                    this.hashSet.add(var3_5);
                }
                in.close();
            } else {
                this.saveReplicatorList();
            }
        }
        catch (FileNotFoundException e) {
            logger.infoT("FileNotFoundException " + e.getMessage());
        }
        catch (IOException e) {
            logger.infoT("IOException " + e.getMessage());
        }
    }

    private void saveReplicatorList() {
        if (this.hashSet == null) {
            return;
        }
        try {
            File orig = new File(this.pathToGeneratedFilesList + "/" + ORIGINAL_FILE);
            if (orig.exists() && this.validFile(orig)) {
                File backup = new File(this.pathToGeneratedFilesList + "/" + BACKUP_FILE);
                backup.delete();
                File backupForRename = new File(this.pathToGeneratedFilesList + "/" + BACKUP_FILE);
                orig.renameTo(backupForRename);
            }
            PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(this.pathToGeneratedFilesList + "/" + ORIGINAL_FILE)));
            Iterator it = this.hashSet.iterator();
            while (it.hasNext()) {
                String str = (String)it.next();
                out.println(str);
            }
            out.println(SUCCESS);
            out.close();
        }
        catch (FileNotFoundException e) {
            logger.infoT("FileNotFoundException " + e.getMessage());
        }
        catch (IOException e) {
            logger.infoT("IOException " + e.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean validFile(File f) {
        try {
            String str;
            BufferedReader in = new BufferedReader(new FileReader(f));
            String tmp = "";
            while ((str = in.readLine()) != null) {
                void var3_5;
                tmp = var3_5;
            }
            in.close();
            if (SUCCESS.equalsIgnoreCase(tmp)) {
                return true;
            }
        }
        catch (FileNotFoundException e) {
            logger.infoT("FileNotFoundException " + e.getMessage());
        }
        catch (IOException e) {
            logger.infoT("IOException " + e.getMessage());
        }
        return false;
    }

    private String filePathReplacer(String filePath) {
        filePath = filePath.replace('\\', '/');
        filePath = StringUtils.replaceAll(filePath, this.pathToRoot, "");
        return filePath;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

