/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.utils;

import com.sap.caf.designer.utils.CustomCodeSnippet;
import java.util.ArrayList;

public class CustomCodeTokenizer {
    private ArrayList codeSnippets = new ArrayList();

    public CustomCodeTokenizer(String strWholeCode, String snippletStartMark, String snippletEndMark) {
        int nBasePos = 0;
        int nLen = strWholeCode.length();
        while (nBasePos < nLen) {
            int indxStartMark = strWholeCode.indexOf(snippletStartMark, nBasePos);
            if (indxStartMark == -1) {
                return;
            }
            int nMarkLen = CustomCodeTokenizer.calcMarkLen(strWholeCode, indxStartMark, nLen);
            String startMarkName = CustomCodeTokenizer.readMarkName(strWholeCode, indxStartMark, nMarkLen, snippletStartMark.length());
            int nCodePosStart = indxStartMark + nMarkLen;
            int indxEndMark = strWholeCode.indexOf(snippletEndMark, nCodePosStart);
            if (indxEndMark == -1) {
                return;
            }
            String body = CustomCodeTokenizer.trimCRLF(strWholeCode.substring(nCodePosStart, indxEndMark));
            int nEndMarkLen = CustomCodeTokenizer.calcMarkLen(strWholeCode, indxEndMark, nLen);
            String endMarkName = CustomCodeTokenizer.readMarkName(strWholeCode, indxEndMark, nEndMarkLen, snippletEndMark.length());
            if (startMarkName.equals(endMarkName)) {
                this.codeSnippets.add(new CustomCodeSnippet(startMarkName, body));
            }
            nBasePos = indxStartMark + nMarkLen + 1;
        }
    }

    public CustomCodeSnippet getSnippet(int i) {
        return (CustomCodeSnippet)this.codeSnippets.get(i);
    }

    public int getSnippetCount() {
        return this.codeSnippets.size();
    }

    private static boolean isNotEOLSymbol(char ch) {
        return ch != '\n' && ch != '\r' && ch != '\f' && ch != '\u0000';
    }

    private static int calcMarkLen(String strWholeCode, int indxStartMark, int nLen) {
        int nRes = 0;
        int i = indxStartMark;
        while (i < nLen) {
            char ch = strWholeCode.charAt(i);
            if (!CustomCodeTokenizer.isNotEOLSymbol(ch)) break;
            ++nRes;
            ++i;
        }
        return nRes;
    }

    private static String readMarkName(String strWholeCode, int indxStartMark, int nMarkLen, int nMarkSize) {
        int indx = indxStartMark + nMarkSize;
        return strWholeCode.substring(indx, indx + nMarkLen - nMarkSize).trim();
    }

    private static String trimCRLF(String str) {
        int nLen = str.length();
        if (nLen > 0) {
            int i = 0;
            while (i < nLen) {
                if (CustomCodeTokenizer.isNotEOLSymbol(str.charAt(i))) break;
                ++i;
            }
            int j = nLen - 1;
            while (j >= 0) {
                if (CustomCodeTokenizer.isNotEOLSymbol(str.charAt(j))) break;
                --j;
            }
            if (j < i) {
                return "";
            }
            return str.substring(i, j + 1);
        }
        return str;
    }
}

