/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure.util;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.exception.CAFIOException;
import com.sap.caf.designer.exception.CAFIllegalArgumentException;
import com.sap.caf.designer.exception.CAFParserConfigurationException;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.Configuration;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.Entry;
import com.sap.caf.metamodel.ExternalInterface;
import com.sap.caf.metamodel.Field;
import com.sap.caf.metamodel.MappingRule;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.MessageMapping;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.OperationMapping;
import com.sap.caf.metamodel.Permission;
import com.sap.caf.metamodel.Properties;
import com.sap.caf.metamodel.Property;
import com.sap.caf.metamodel.Table;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.tc.logging.Location;
import java.io.CharArrayWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MetadataChecker {
    public static final String[] MMRObjects = new String[]{"Application", "BusinessEntityInterface", "Operation", "Permission", "OperationMapping", "MessageMapping", "MappingRule", "Message", "FaultMessage", "Attribute", "Property", "Constraint", "DataStructure", "Table", "Field", "ApplicationInterface", "ExternalInterface", "Configuration", "Properties", "Entry"};
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$structure$util$MetadataChecker == null ? (class$com$sap$caf$designer$structure$util$MetadataChecker = MetadataChecker.class$("com.sap.caf.designer.structure.util.MetadataChecker")) : class$com$sap$caf$designer$structure$util$MetadataChecker);
    private static final String TAG_APPLICATIONS = "applications";
    private static final String TAG_APPLICATION = "application";
    private static final String TAG_EXTERNAL_INTERFACE = "ExternalInterface";
    private static final String TAG_CONFIGURATION = "Configuration";
    private static final String TAG_PROPERTIES = "Properties";
    private static final String TAG_ENTRY = "entry";
    private static final String TAG_OPERATION = "Operation";
    private static final String TAG_PERMISSION = "Permission";
    private static final String TAG_MESSAGE = "Message";
    private static final String TAG_ATTRIBUTE = "Attribute";
    private static final String TAG_DATA_STRUCTURE = "DataStructure";
    private static final String TAG_DATA_OBJECT = "DataObject";
    private static final String TAG_PROPERTY = "Property";
    private static final String TAG_EXISTING_LEAF = "_EXISTING_LEAF";
    private static final String TAG_BUSINESS_ENTITY_INTERFACE = "BusinessEntityInterface";
    private static final String TAG_OPERATION_MAPPING = "OperationMapping";
    private static final String TAG_MESSAGE_MAPPING = "MessageMapping";
    private static final String TAG_MAPPING_RULE = "MappingRule";
    private static final String TAG_FAULT_MESSAGE = "FaultMessage";
    private static final String TAG_APPLICATION_INTERFACE = "ApplicationInterface";
    private static final String TAG_FIELD = "Field";
    private static final String TAG_TABLE = "Table";
    private static final String TAG_UNKNOWN = "Unknown";
    public static final Map ignoredMethods = new Hashtable();
    public Map allObjects = new Hashtable();
    private Hashtable existingLeafs = new Hashtable();
    private int existingLeafsCounter = 0;
    static /* synthetic */ Class class$com$sap$caf$designer$structure$util$MetadataChecker;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$java$util$Collection;
    static /* synthetic */ Class class$com$sap$caf$metamodel$BaseObject;
    static /* synthetic */ Class class$javax$jmi$reflect$RefObject;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$lang$Boolean;

    public void getAllMMRObjects(IConnection con) {
        this.allObjects.clear();
        int i = 0;
        while (i < MMRObjects.length) {
            this.getMMRObjects(MMRObjects[i], con);
            ++i;
        }
    }

    public Collection getMMRObjects(String type, IConnection con) {
        List items = null;
        try {
            List typeList = Utilities.getUtilities().decodeQualifiedName("com.sap.caf.metamodel." + type);
            items = con.queryM1(typeList, null, true);
            Iterator it = items.iterator();
            int i = 0;
            while (it.hasNext()) {
                ++i;
                Object elem = it.next();
                try {
                    Method m = elem.getClass().getMethod("refMofId", null);
                    String mofId = (String)m.invoke(elem, null);
                    String tmp = "" + i + ". " + type + " - " + mofId;
                    if (!(elem instanceof BaseObject)) continue;
                    tmp = tmp + "  name = " + ((BaseObject)elem).getObjectName();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            logger.errorT("Could not get a list of MMR objects from repository.Error is:" + e.getMessage());
            e.printStackTrace();
        }
        return items;
    }

    public StringBuffer dumpApplication(Application app) throws CAFParserConfigurationException, DOMException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, CAFIOException {
        try {
            StringBuffer result = new StringBuffer();
            CharArrayWriter charArrayWriter = null;
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Date start = new Date();
            Element root = document.createElement(TAG_APPLICATIONS);
            root.appendChild(this.populateObject(document, app, null, null));
            document.appendChild(root);
            document.getDocumentElement().normalize();
            Date end = new Date();
            try {
                charArrayWriter = MetadataChecker.saveXML(document);
            }
            catch (TransformerException tex) {
                logger.errorT("An error occured while dumping application.Error is:" + tex.getMessage());
                tex.printStackTrace();
                return new StringBuffer("An error has occured: " + tex.getMessage());
            }
            result.append(charArrayWriter.toCharArray());
            return result;
        }
        catch (ParserConfigurationException pce) {
            throw new CAFParserConfigurationException(pce);
        }
    }

    public static CharArrayWriter saveXML(Document doc) throws TransformerException {
        CharArrayWriter writer = new CharArrayWriter();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("indent", "yes");
        t.transform(new DOMSource(doc), new StreamResult(writer));
        return writer;
    }

    private static void setAttribute(Element element, String key, String value) {
        if (value != null) {
            element.setAttribute(key, value);
        }
    }

    private static void setAttribute(Element element, String key, Integer value) {
        if (value != null) {
            MetadataChecker.setAttribute(element, key, value.toString());
        }
    }

    private static void setAttribute(Element element, String key, Boolean value) {
        if (value != null) {
            MetadataChecker.setAttribute(element, key, value.toString());
        }
    }

    private String getLeafObjectName(Object o) {
        if (this.existingLeafs.containsValue(o)) {
            Enumeration en = this.existingLeafs.keys();
            while (en.hasMoreElements()) {
                String currentKey = (String)en.nextElement();
                if (!this.existingLeafs.get(currentKey).equals(o)) continue;
                return currentKey;
            }
        }
        String leafName = "ExistingLeaf_" + this.existingLeafsCounter++;
        this.existingLeafs.put(leafName, o);
        return leafName;
    }

    private Element populateExistingLeaf(Document document, Object o, String singleRelation, String multipleRelation) {
        Element result = document.createElement(TAG_EXISTING_LEAF);
        String objectName = this.getLeafObjectName(o);
        if (singleRelation != null) {
            MetadataChecker.setAttribute(result, "_single_relation", singleRelation);
        } else if (multipleRelation != null) {
            MetadataChecker.setAttribute(result, "_multiple_relation", multipleRelation);
        }
        MetadataChecker.setAttribute(result, "_object_name", objectName);
        return result;
    }

    private Element populateObject(Document document, Object object, String singleRelation, String multipleRelation) throws CAFIllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Element result = null;
        if (this.existingLeafs.contains(object)) {
            return this.populateExistingLeaf(document, object, singleRelation, multipleRelation);
        }
        result = object instanceof Application ? document.createElement(TAG_APPLICATION) : (object instanceof ApplicationInterface ? document.createElement(TAG_APPLICATION_INTERFACE) : (object instanceof Property ? document.createElement(TAG_PROPERTY) : (object instanceof Attribute ? document.createElement(TAG_ATTRIBUTE) : (object instanceof BusinessEntityInterface ? document.createElement(TAG_BUSINESS_ENTITY_INTERFACE) : (object instanceof Configuration ? document.createElement(TAG_CONFIGURATION) : (object instanceof DataObject ? document.createElement(TAG_DATA_OBJECT) : (object instanceof DataStructure ? document.createElement(TAG_DATA_STRUCTURE) : (object instanceof Entry ? document.createElement(TAG_ENTRY) : (object instanceof ExternalInterface ? document.createElement(TAG_EXTERNAL_INTERFACE) : (object instanceof Message ? (((Message)object).getObjectName() != null && ((Message)object).getObjectName().endsWith("Exception") ? document.createElement(TAG_FAULT_MESSAGE) : document.createElement(TAG_MESSAGE)) : (object instanceof MappingRule ? document.createElement(TAG_MAPPING_RULE) : (object instanceof MessageMapping ? document.createElement(TAG_MESSAGE_MAPPING) : (object instanceof Operation ? document.createElement(TAG_OPERATION) : (object instanceof OperationMapping ? document.createElement(TAG_OPERATION_MAPPING) : (object instanceof Permission ? document.createElement(TAG_PERMISSION) : (object instanceof Properties ? document.createElement(TAG_PROPERTIES) : (object instanceof Table ? document.createElement(TAG_TABLE) : (object instanceof Field ? document.createElement(TAG_FIELD) : document.createElement(TAG_UNKNOWN)))))))))))))))))));
        MetadataChecker.setAttribute(result, "_object_name", this.getLeafObjectName(object));
        Method[] methods = object.getClass().getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            Method currentMethod = methods[i];
            String methodName = currentMethod.getName();
            if (methodName.substring(3).startsWith("___")) {
                methodName = "get" + methodName.substring(6);
            }
            if (!ignoredMethods.containsKey(methodName) && methodName.startsWith("get")) {
                Iterator<Object> iObjects;
                Object methodResult;
                if ((class$java$util$Map == null ? MetadataChecker.class$("java.util.Map") : class$java$util$Map).isAssignableFrom(currentMethod.getReturnType())) {
                    methodResult = (Map)currentMethod.invoke(object, null);
                    if (methodResult != null) {
                        iObjects = methodResult.keySet().iterator();
                        while (iObjects.hasNext()) {
                            Object currentObject = methodResult.get(iObjects.next());
                            result.appendChild(this.populateObject(document, currentObject, null, methodName));
                        }
                    }
                } else if ((class$java$util$Collection == null ? MetadataChecker.class$("java.util.Collection") : class$java$util$Collection).isAssignableFrom(currentMethod.getReturnType())) {
                    methodResult = (Collection)currentMethod.invoke(object, null);
                    if (methodResult != null) {
                        iObjects = methodResult.iterator();
                        while (iObjects.hasNext()) {
                            result.appendChild(this.populateObject(document, iObjects.next(), null, methodName));
                        }
                    }
                } else if ((class$com$sap$caf$metamodel$BaseObject == null ? MetadataChecker.class$("com.sap.caf.metamodel.BaseObject") : class$com$sap$caf$metamodel$BaseObject).isAssignableFrom(currentMethod.getReturnType()) || (class$javax$jmi$reflect$RefObject == null ? MetadataChecker.class$("javax.jmi.reflect.RefObject") : class$javax$jmi$reflect$RefObject).isAssignableFrom(currentMethod.getReturnType())) {
                    methodName = "set" + methodName.substring(3);
                    methodResult = currentMethod.invoke(object, null);
                    if (methodResult != null) {
                        result.appendChild(this.populateObject(document, methodResult, methodName, null));
                    }
                } else if ((class$java$lang$String == null ? MetadataChecker.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(currentMethod.getReturnType())) {
                    methodResult = currentMethod.invoke(object, null);
                    if (methodResult != null) {
                        methodName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                        MetadataChecker.setAttribute(result, methodName, (String)methodResult);
                    }
                } else if (((class$java$lang$Number == null ? MetadataChecker.class$("java.lang.Number") : class$java$lang$Number).isAssignableFrom(currentMethod.getReturnType()) || (class$java$lang$Boolean == null ? MetadataChecker.class$("java.lang.Boolean") : class$java$lang$Boolean).isAssignableFrom(currentMethod.getReturnType())) && (methodResult = currentMethod.invoke(object, null)) != null) {
                    methodName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                    MetadataChecker.setAttribute(result, methodName, methodResult.toString());
                }
            }
            ++i;
        }
        if (singleRelation != null) {
            MetadataChecker.setAttribute(result, "_single_relation", singleRelation);
        }
        if (multipleRelation != null) {
            MetadataChecker.setAttribute(result, "_multiple_relation", multipleRelation);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ignoredMethods.put("hashCode", "hashCode");
        ignoredMethods.put("equals", "equals");
        ignoredMethods.put("refMofId", "refMofId");
        ignoredMethods.put("refMetaObject", "refMetaObject");
        ignoredMethods.put("refImmediatePackage", "refImmediatePackage");
        ignoredMethods.put("refOutermostPackage", "refOutermostPackage");
        ignoredMethods.put("refVerifyConstraints", "refVerifyConstraints");
        ignoredMethods.put("refSetValue", "refSetValue");
        ignoredMethods.put("refGetValue", "refGetValue");
        ignoredMethods.put("refInvokeOperation", "refInvokeOperation");
        ignoredMethods.put("refIsInstanceOf", "refIsInstanceOf");
        ignoredMethods.put("refClass", "refClass");
        ignoredMethods.put("refImmediateComposite", "refImmediateComposite");
        ignoredMethods.put("refOutermostComposite", "refOutermostComposite");
        ignoredMethods.put("refDelete", "refDelete");
        ignoredMethods.put("getName", "getName");
        ignoredMethods.put("setName", "setName");
        ignoredMethods.put("getVisibility", "getVisibility");
        ignoredMethods.put("setVisibility", "setVisibility");
        ignoredMethods.put("getClientDependency", "getClientDependency");
        ignoredMethods.put("getConstraint", "getConstraint");
        ignoredMethods.put("getImporter", "getImporter");
        ignoredMethods.put("getNamespace", "getNamespace");
        ignoredMethods.put("setNamespace", "setNamespace");
        ignoredMethods.put("getOwnedElement", "getOwnedElement");
        ignoredMethods.put("isAbstract", "isAbstract");
        ignoredMethods.put("setAbstract", "setAbstract");
        ignoredMethods.put("getFeature", "getFeature");
        ignoredMethods.put("getMofId", "getMofId");
        ignoredMethods.put("getGeneratorVersion", "getGeneratorVersion");
        ignoredMethods.put("getQualifiedName", "getQualifiedName");
        ignoredMethods.put("getQualifiedNameImmediatePackage", "getQualifiedNameImmediatePackage");
        ignoredMethods.put("getBusinessEntityInterface", "getBusinessEntityInterface");
        ignoredMethods.put("getMOFInterface", "getMOFInterface");
    }
}

