/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.exception.CAFRuntimeException;

public class TableNameGenerator {
    private static final char LTR_A = 'A';
    private static final char LTR_Z = 'Z';
    private static final char LTR_0 = '0';
    private static final char LTR_9 = '9';
    private static final int nletterCount = 36;
    public static final String TBL_PART_SEPARATOR = "_";
    public static final int MAX_TABLE_LEN = 18;
    private String nameprefix;
    private String subProjectPrefix;
    private String masterObjName;
    private String detailObjName;
    private String detailObjNameOriginal;
    private int nMasterCounter = 0;
    private int nDetailCounter = 0;
    private int nDetailBase = 36;
    private int nMasterBase = 36;
    private boolean bShorter = false;

    public TableNameGenerator(String nameprefix, String subProjectPrefix, String masterObjName, String detailObjName) throws InvalidNameArgument {
        if (nameprefix.length() == 0) {
            throw new CAFRuntimeException("Program Error: Empty 'nameprexic' passed, to 'TableNameGenerator' class.");
        }
        if (subProjectPrefix.length() == 0) {
            throw new CAFRuntimeException("Program Error: Empty 'subProjectPrefix' passed, to 'TableNameGenerator' class.");
        }
        nameprefix = this.filterName(nameprefix.toUpperCase());
        subProjectPrefix = this.filterName(subProjectPrefix.toUpperCase());
        masterObjName = this.filterName(masterObjName.toUpperCase());
        detailObjName = this.filterName(detailObjName.toUpperCase());
        if (masterObjName.length() == 0) {
            throw new InvalidNameArgument();
        }
        this.nameprefix = nameprefix;
        this.subProjectPrefix = subProjectPrefix;
        int nLen = 18 - (nameprefix.length() + subProjectPrefix.length() + 2);
        int nDetailLen = nLen / 2;
        int nMasterLen = nLen - nDetailLen;
        if (masterObjName.length() > nMasterLen) {
            if (detailObjName.length() >= nDetailLen) {
                this.masterObjName = masterObjName.substring(0, nMasterLen);
                this.detailObjName = detailObjName.substring(0, nDetailLen);
            } else {
                nDetailLen = detailObjName.length();
                nMasterLen = nLen - nDetailLen;
                this.detailObjName = detailObjName;
                this.masterObjName = nMasterLen < masterObjName.length() ? masterObjName.substring(0, nMasterLen) : masterObjName;
            }
        } else if (detailObjName.length() <= nDetailLen) {
            this.masterObjName = masterObjName;
            this.detailObjName = detailObjName;
        } else {
            nMasterLen = masterObjName.length();
            nDetailLen = nLen - nMasterLen;
            this.masterObjName = masterObjName;
            this.detailObjName = nDetailLen < detailObjName.length() ? detailObjName.substring(0, nDetailLen) : detailObjName;
        }
        this.masterObjName = this.masterObjName.toUpperCase();
        this.detailObjNameOriginal = this.detailObjName = this.detailObjName.toUpperCase();
        int nNameLen = this.getLen();
        this.bShorter = nNameLen < 18;
        int i = 0;
        while (i < 18 - nNameLen) {
            this.nDetailBase *= 36;
            ++i;
        }
    }

    public static String fromTablePrefix(String nameprefix, String subProjectPrefix) {
        return nameprefix.toUpperCase() + TBL_PART_SEPARATOR + subProjectPrefix.toUpperCase() + TBL_PART_SEPARATOR;
    }

    public String getNextValue() {
        String name = this.nameprefix + TBL_PART_SEPARATOR + this.subProjectPrefix + TBL_PART_SEPARATOR + this.masterObjName + this.detailObjName;
        this.moveToNextValue();
        return name;
    }

    private int getLen() {
        return this.nameprefix.length() + 1 + this.subProjectPrefix.length() + 1 + this.masterObjName.length() + this.detailObjName.length();
    }

    private boolean isValidSign(char ch) {
        return 'A' <= ch && ch <= 'Z' || '0' <= ch && ch <= '9' || ch == '_';
    }

    private String filterName(String str) {
        StringBuffer strBuff = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (this.isValidSign(ch)) {
                strBuff.append(ch);
            }
            ++i;
        }
        return strBuff.toString();
    }

    private static String genZeroes(int x) {
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < x) {
            str.append('0');
            ++i;
        }
        return str.toString();
    }

    private void moveToNextValue() {
        if (this.detailObjName.length() == 0) {
            if (this.bShorter) {
                this.bShorter = false;
                this.masterObjName = this.masterObjName + TableNameGenerator.genZeroes(18 - this.getLen());
            }
            this.masterObjName = this.nextLexicalValue(this.masterObjName);
            return;
        }
        if (this.bShorter) {
            this.bShorter = false;
            this.detailObjName = this.detailObjName + TableNameGenerator.genZeroes(18 - this.getLen());
        }
        this.detailObjName = this.nextLexicalValue(this.detailObjName);
        ++this.nDetailCounter;
        if (this.nDetailCounter == this.nDetailBase) {
            this.nDetailCounter = 0;
            this.detailObjName = this.detailObjNameOriginal;
            this.masterObjName = this.nextLexicalValue(this.masterObjName);
            ++this.nMasterCounter;
            if (this.nMasterCounter == this.nMasterBase) {
                this.nDetailBase *= 36;
                this.nMasterBase *= 36;
                this.nMasterCounter = 0;
            }
        }
    }

    private String nextLexicalValue(String str) {
        char[] arr = str.toCharArray();
        int i = arr.length - 1;
        while (i >= 0) {
            char ch = arr[i];
            if (this.isValidSign(ch = (char)(ch + '\u0001'))) {
                arr[i] = ch;
                break;
            }
            if (arr[i] == 'Z') {
                arr[i] = 48;
                break;
            }
            arr[i] = 65;
            --i;
        }
        return new String(arr);
    }

    public static class InvalidNameArgument
    extends CAFBaseException {
        public InvalidNameArgument() {
            super("Invalid Table Name Argument.");
        }
    }
}

