/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.structure.BOMActivity;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.validation.AMarkerResolution;
import com.sap.caf.designer.validation.IValidatable;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.MOFInterface;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.RefObject;
import org.eclipse.core.resources.IMarker;
import org.eclipse.ui.IMarkerResolution;

public abstract class CAFWrapperBase
implements IValidatable {
    private boolean isNew;
    protected BOMSystem bomSystem;
    private RefObject refObject;
    protected Map context;
    private List objectsForRemoval;
    private List collectionsForRemoval;

    public CAFWrapperBase(BOMSystem bomSystem, RefObject refObject, Map context) {
        this.bomSystem = bomSystem;
        this.refObject = refObject;
        this.context = context;
        this.objectsForRemoval = null;
        this.collectionsForRemoval = null;
        this.setNew(true);
    }

    public CAFWrapperBase(BOMSystem bomSystem, RefObject refObject) {
        this(bomSystem, refObject, null);
    }

    public BOMSystem getBomSystem() {
        return this.bomSystem;
    }

    public RefObject getMofClass() {
        return this.refObject;
    }

    public void setNew(boolean aNew) {
        this.isNew = aNew;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public String getTechnicalIdentifier(MOFInterface mofInterface, BOMSystem abomsystem) {
        return abomsystem.getApplication().getProviderName() + "/" + abomsystem.getApplicationName() + "/" + mofInterface.getObjectName();
    }

    public final void remove() {
        this.objectsForRemoval = new LinkedList();
        this.collectionsForRemoval = new LinkedList();
        this.removeInternal(this);
        Iterator i = this.collectionsForRemoval.iterator();
        while (i.hasNext()) {
            Collection currentCol = (Collection)i.next();
            currentCol.clear();
        }
        i = this.objectsForRemoval.iterator();
        while (i.hasNext()) {
            RefObject currentRefObject = (RefObject)i.next();
            currentRefObject.refDelete();
        }
        this.objectsForRemoval = null;
        this.collectionsForRemoval = null;
    }

    public void removeNulls() {
    }

    public String toString() {
        return "wrapped: " + this.refObject;
    }

    public boolean validateList(Object targetObject, Collection collection, String itemName) {
        boolean result = true;
        int invalidItems = 0;
        final String items = itemName + (itemName.endsWith("s") ? "(es)" : "(s)");
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            Object temp = it.next();
            if (temp == null) {
                ++invalidItems;
                continue;
            }
            CAFWrapperBase wrapper = BOMActivity.getWrapper(this.bomSystem, temp);
            if (wrapper == null || this.bomSystem.getValidatedObjects().containsKey(wrapper)) continue;
            this.bomSystem.getValidatedObjects().put(wrapper, null);
            if (wrapper.validate()) continue;
            result = false;
        }
        if (invalidItems > 0) {
            result = false;
            IMarkerResolution[] resolutions = new IMarkerResolution[]{new AMarkerResolution("Remove invalid " + items, collection, this.bomSystem){

                public void run(IMarker marker) {
                    Iterator it = ((Collection)this.target).iterator();
                    while (it.hasNext()) {
                        if (it.next() != null) continue;
                        it.remove();
                    }
                    BOMActivity.showMessage("Resolution", "Invalid " + items + " removed");
                }
            }};
            this.bomSystem.getStatus().addErrorMessage(((BaseObject)targetObject).getObjectName() + " has invalid " + items, resolutions);
        }
        return result;
    }

    protected static void removeNulls(Iterator i) {
        while (i.hasNext()) {
            if (i.next() != null) continue;
            i.remove();
        }
    }

    protected void removeInternal(CAFWrapperBase topMostRemovedObj) {
        topMostRemovedObj.objectsForRemoval.add(this.refObject);
    }

    protected static void removeInternal(CAFWrapperBase topMostRemovedObj, Collection col) {
        topMostRemovedObj.collectionsForRemoval.add(col);
    }

    public boolean validate() {
        boolean result = true;
        return result;
    }
}

