/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFAttribute;
import com.sap.caf.designer.structure.CAFField;
import com.sap.caf.designer.structure.CAFProperty;
import com.sap.caf.designer.structure.CAFWrapperBase;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.Field;
import com.sap.caf.metamodel.Property;
import com.sap.caf.metamodel.Table;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import javax.jmi.reflect.RefObject;

public class CAFTable
extends CAFWrapperBase {
    private Table table;

    public CAFTable(BOMSystem bomSystem, Table table, Map context) {
        super(bomSystem, (RefObject)table, context);
        this.table = table;
    }

    public CAFTable(BOMSystem bomSystem, Table table) {
        this(bomSystem, table, null);
    }

    public Table getTable() {
        return this.table;
    }

    public void removeNulls() {
        CAFWrapperBase.removeNulls(this.table.getFields().iterator());
        Iterator i = new LinkedList(this.table.getFields()).iterator();
        while (i.hasNext()) {
            new CAFField(this.bomSystem, (Field)i.next(), this.context).removeNulls();
        }
        super.removeNulls();
    }

    public String toString() {
        return "wrapped: " + this.table;
    }

    public boolean validate() {
        boolean result = super.validate();
        if (!this.validateList(this.table, this.table.getFields(), "field")) {
            result = false;
        }
        if (!(this.table.getMasterDataObject() == null && this.table.getSourceDataObject() == null && this.table.getTargetDataObject() == null || this.table.getMasterDataObject() != null && this.table.getSourceDataObject() == null && this.table.getTargetDataObject() == null || this.table.getMasterDataObject() == null && this.table.getSourceDataObject() != null && this.table.getTargetDataObject() != null)) {
            this.bomSystem.getStatus().addErrorMessage("The TABLE '" + this.table.getTableName() + "' has no invalid state. The allowed usages for a TABLE are MASTER DATA OBJECT, SOURCE DATA OBJECT and TARGET DATA OBJECT to be one of the combinations: (null)-(null)-(null), (not null)-(null)-(null), and (null)-(not null)-(not null).", this.table);
            result = false;
        }
        return result;
    }

    protected void removeInternal(CAFWrapperBase topMostRemovedObj) {
        CAFWrapperBase.removeInternal(topMostRemovedObj, this.table.getFields());
        Iterator i = this.table.getFields().iterator();
        while (i.hasNext()) {
            new CAFField(this.bomSystem, (Field)i.next(), this.context).removeInternal(topMostRemovedObj);
        }
        DataObject targetDataObject = this.table.getTargetDataObject();
        DataObject sourceDataObject = this.table.getSourceDataObject();
        if (targetDataObject == null || sourceDataObject != null) {
            // empty if block
        }
        super.removeInternal(topMostRemovedObj);
    }

    private void removeReferences(DataStructure source, DataStructure target, CAFWrapperBase topMostRemovedObj) {
        Iterator i = new LinkedList(source.getAttributes()).iterator();
        while (i.hasNext()) {
            Attribute attr = (Attribute)i.next();
            DataStructure referencedStructure = attr.getReferencedObject();
            if (referencedStructure == null) continue;
            if (referencedStructure.getObjectId().equals(target.getObjectId())) {
                if (attr instanceof Property) {
                    new CAFProperty(this.bomSystem, (Property)attr, this.context).removeInternal(topMostRemovedObj);
                    continue;
                }
                new CAFAttribute(this.bomSystem, attr, this.context).removeInternal(topMostRemovedObj);
                continue;
            }
            this.removeReferences(referencedStructure, target, topMostRemovedObj);
        }
    }
}

