/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFAttribute;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFField;
import com.sap.caf.designer.structure.CAFTable;
import com.sap.caf.designer.structure.CAFWrapperBase;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.Field;
import com.sap.caf.metamodel.Property;
import com.sap.caf.metamodel.Table;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CAFProperty
extends CAFAttribute {
    private Property prop;

    public CAFProperty(BOMSystem bomSystem, Property prop, Map context) {
        super(bomSystem, (Attribute)prop, context);
        this.prop = prop;
    }

    public CAFProperty(BOMSystem bomSystem, Property prop) {
        this(bomSystem, prop, null);
    }

    public Property getProperty() {
        return this.prop;
    }

    public void removeNulls() {
        CAFWrapperBase.removeNulls(this.prop.getField().iterator());
        super.removeNulls();
    }

    public String toString() {
        return "wrapped: " + this.prop;
    }

    public boolean validate() {
        boolean result = super.validate();
        if (!this.validateList(this.prop, this.prop.getField(), "field")) {
            result = false;
        }
        if (this.prop.isLanguageDependent() == null) {
            this.bomSystem.getStatus().addErrorMessage("The PROPERTY '" + this.prop.getObjectName() + "' has no LANGUAGE DEPENDENT defined");
            result = false;
        }
        if (this.prop.getField().size() > 1) {
            this.bomSystem.getStatus().addErrorMessage("The PROPERTY '" + this.prop.getObjectName() + "' has more than one FIELD defined");
            result = false;
        }
        return result;
    }

    protected void removeInternal(CAFWrapperBase topMostRemovedObj) {
        if (CAFBusinessEntityInterface.isComplexAttribute((Attribute)this.prop)) {
            Table complexTable = ((Field)this.prop.getField().iterator().next()).getTable();
            new CAFTable(this.bomSystem, complexTable, this.context).removeInternal(topMostRemovedObj);
        } else if (CAFBusinessEntityInterface.isEntityAttribute((Attribute)this.prop)) {
            Collection propertyField = this.prop.getField();
            if (propertyField != null && !propertyField.isEmpty()) {
                Table joinTable = ((Field)propertyField.iterator().next()).getTable();
                new CAFTable(this.bomSystem, joinTable, this.context).removeInternal(topMostRemovedObj);
            }
        } else if (this.prop.getMaxOccurs() < 0) {
            Table collectionTable = ((Field)this.prop.getField().iterator().next()).getTable();
            new CAFTable(this.bomSystem, collectionTable, this.context).removeInternal(topMostRemovedObj);
        } else {
            BusinessEntityInterface be = this.getBusinessEntityInterface();
            if (be != null) {
                CAFBusinessEntityInterface owningBe = new CAFBusinessEntityInterface(this.bomSystem, be, this.context);
                if (this.prop.isLanguageDependent().booleanValue()) {
                    List allAttrs = owningBe.readCurrentAttributes();
                    Iterator it = allAttrs.iterator();
                    int langFields = 0;
                    while (it.hasNext()) {
                        Property prop = (Property)it.next();
                        if (!prop.isLanguageDependent().booleanValue()) continue;
                        ++langFields;
                    }
                    if (langFields < 2) {
                        Table languageTable = ((Field)this.prop.getField().iterator().next()).getTable();
                        new CAFTable(this.bomSystem, languageTable, this.context).removeInternal(topMostRemovedObj);
                    }
                }
            }
        }
        CAFWrapperBase.removeInternal(topMostRemovedObj, this.prop.getField());
        Field field = (Field)this.prop.getField().iterator().next();
        if (field != null) {
            new CAFField(this.bomSystem, field, this.context).removeInternal(topMostRemovedObj);
        }
        super.removeInternal(topMostRemovedObj);
    }
}

