/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.structure.BOMActivity;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBaseObject;
import com.sap.caf.designer.structure.CAFMessage;
import com.sap.caf.designer.structure.CAFOperationMapping;
import com.sap.caf.designer.structure.CAFPermission;
import com.sap.caf.designer.structure.CAFWrapperBase;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.MetamodelPackage;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.OperationMapping;
import com.sap.caf.metamodel.OperationMappingSourceOperation;
import com.sap.caf.metamodel.OperationMappingTargetOperation;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class CAFOperation
extends CAFBaseObject {
    private Operation op;

    public CAFOperation(BOMSystem bomSystem, Operation op, Map context) {
        super(bomSystem, (BaseObject)op, context);
        this.op = op;
    }

    public CAFOperation(BOMSystem bomSystem, Operation op) {
        this(bomSystem, op, null);
    }

    public Operation getOperation() {
        return this.op;
    }

    public void removeNulls() {
        CAFWrapperBase.removeNulls(this.op.getFault().iterator());
        CAFWrapperBase.removeNulls(this.op.getWrappedOperation().iterator());
        if (this.op.getPermission() != null) {
            new CAFPermission(this.bomSystem, this.op.getPermission(), this.context).removeNulls();
        }
        if (this.op.getInput() != null) {
            new CAFMessage(this.bomSystem, this.op.getInput(), this.context).removeNulls();
        }
        if (this.op.getOutput() != null) {
            new CAFMessage(this.bomSystem, this.op.getOutput(), this.context).removeNulls();
        }
        Iterator i = new LinkedList(this.op.getFault()).iterator();
        while (i.hasNext()) {
            new CAFMessage(this.bomSystem, (Message)i.next(), this.context).removeNulls();
        }
        super.removeNulls();
    }

    public String toString() {
        return "wrapped: " + this.op;
    }

    public boolean validate() {
        boolean result = super.validate();
        CAFWrapperBase wrapper = BOMActivity.getWrapper(this.bomSystem, this.op.getInput());
        if (wrapper != null && !wrapper.validate()) {
            result = false;
        }
        if (!this.validateList(this.op, this.op.getFault(), "fault")) {
            result = false;
        }
        if (this.op.getPermission() == null) {
            this.bomSystem.getStatus().addErrorMessage("Operation " + this.op.getObjectName() + " contains null permission in " + this.op.getMOFInterface().getObjectName(), null);
        }
        return result;
    }

    protected void removeInternal(CAFWrapperBase topMostRemovedObj) {
        MetamodelPackage metamodelPackage = this.bomSystem.getMetamodelPackage();
        OperationMappingSourceOperation operationMappingSourceOperation = metamodelPackage.getOperationMappingSourceOperation();
        Iterator i = operationMappingSourceOperation.getOperationMapping(this.op).iterator();
        while (i.hasNext()) {
            new CAFOperationMapping(this.bomSystem, (OperationMapping)i.next(), this.context).removeInternal(topMostRemovedObj);
        }
        OperationMappingTargetOperation operationMappingTargetOperation = metamodelPackage.getOperationMappingTargetOperation();
        i = operationMappingTargetOperation.getOperationMapping(this.op).iterator();
        while (i.hasNext()) {
            new CAFOperationMapping(this.bomSystem, (OperationMapping)i.next(), this.context).removeInternal(topMostRemovedObj);
        }
        if (this.op.getPermission() != null) {
            new CAFPermission(this.bomSystem, this.op.getPermission(), this.context).removeInternal(topMostRemovedObj);
        }
        if (this.op.getInput() != null) {
            new CAFMessage(this.bomSystem, this.op.getInput(), this.context).removeInternal(topMostRemovedObj);
        }
        if (this.op.getOutput() != null) {
            new CAFMessage(this.bomSystem, this.op.getOutput(), this.context).removeInternal(topMostRemovedObj);
        }
        CAFWrapperBase.removeInternal(topMostRemovedObj, this.op.getFault());
        i = this.op.getFault().iterator();
        while (i.hasNext()) {
            new CAFMessage(this.bomSystem, (Message)i.next(), this.context).removeInternal(topMostRemovedObj);
        }
        super.removeInternal(topMostRemovedObj);
    }
}

