/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBaseObject;
import com.sap.caf.designer.structure.CAFMappingRule;
import com.sap.caf.designer.structure.CAFMessage;
import com.sap.caf.designer.structure.CAFMessageAttribute;
import com.sap.caf.designer.structure.CAFWrapperBase;
import com.sap.caf.designer.utils.DatasourceUtils;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.MappingRule;
import com.sap.caf.metamodel.MessageMapping;
import com.sap.caf.metamodel.MetamodelPackage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class CAFMessageMapping
extends CAFBaseObject {
    private MessageMapping msgMapping;
    private CAFMessage targetMsg;
    private CAFMessage sourceMsg;
    private Map colMappings;
    private Map attrMappings;
    private Map constMappings;
    private Map colMappingsRefCounts;

    public CAFMessageMapping(BOMSystem bomSystem, MessageMapping msgMapping, Map context) {
        super(bomSystem, (BaseObject)msgMapping, context);
        this.msgMapping = msgMapping;
        this.targetMsg = new CAFMessage(this.bomSystem, this.msgMapping.getTarget(), context);
        this.sourceMsg = new CAFMessage(this.bomSystem, this.msgMapping.getSource(), context);
        this.loadMappings();
    }

    public CAFMessageMapping(BOMSystem bomSystem, MessageMapping msgMapping) {
        this(bomSystem, msgMapping, null);
    }

    public CAFMessageAttribute getAttributeMapping(CAFMessageAttribute target) {
        return (CAFMessageAttribute)this.attrMappings.get(target);
    }

    public boolean isAttributeMappingAllowed(CAFMessageAttribute target, CAFMessageAttribute source) {
        if (!target.isSimple() || !source.isSimple()) {
            return false;
        }
        if (!target.getMessage().getObjectId().equals(this.targetMsg.getMessage().getObjectId()) || !source.getMessage().getObjectId().equals(this.sourceMsg.getMessage().getObjectId())) {
            return false;
        }
        if (this.attrMappings.containsKey(target)) {
            return false;
        }
        if (source.isCollection() && !target.isCollection()) {
            return false;
        }
        List attributesToCheckForNonCol = target.getAttributes().size() > source.getAttributes().size() ? target.getAttributes().subList(0, target.getAttributes().size() - source.getAttributes().size()) : (source.getAttributes().size() > target.getAttributes().size() ? source.getAttributes().subList(0, source.getAttributes().size() - target.getAttributes().size()) : null);
        if (attributesToCheckForNonCol != null) {
            Iterator i = attributesToCheckForNonCol.iterator();
            while (i.hasNext()) {
                Attribute attr = (Attribute)i.next();
                if (attr.getMaxOccurs() == 1) continue;
                return false;
            }
        }
        ListIterator targetIt = target.getAttributes().listIterator(target.getAttributes().size() - 1);
        ListIterator sourceIt = source.getAttributes().listIterator(source.getAttributes().size() - 1);
        while (targetIt.hasPrevious() && sourceIt.hasPrevious()) {
            boolean sourceIsCol;
            Attribute targetAttr = (Attribute)targetIt.previous();
            Attribute sourceAttr = (Attribute)sourceIt.previous();
            boolean targetIsCol = targetAttr.getMaxOccurs() != 1;
            boolean bl = sourceIsCol = sourceAttr.getMaxOccurs() != 1;
            if (sourceIsCol && !targetIsCol) {
                return false;
            }
            if (!targetIsCol) continue;
            CAFMessageAttribute targetCol = new CAFMessageAttribute(this.bomSystem, target.getMessage(), target.getAttributes().subList(0, targetIt.nextIndex() + 1));
            CAFMessageAttribute sourceCol = new CAFMessageAttribute(this.bomSystem, source.getMessage(), source.getAttributes().subList(0, sourceIt.nextIndex() + 1));
            CAFMessageAttribute oldSourceCol = (CAFMessageAttribute)this.colMappings.get(targetCol);
            if (oldSourceCol == null || oldSourceCol.equals(sourceCol)) continue;
            return false;
        }
        return true;
    }

    public CAFMessageAttribute getCollectionMapping(CAFMessageAttribute target) {
        return (CAFMessageAttribute)this.colMappings.get(target);
    }

    public Set getCollectionTargets() {
        return this.colMappings.keySet();
    }

    public String getConstantMapping(CAFMessageAttribute target) {
        return (String)this.constMappings.get(target);
    }

    public MessageMapping getMessageMapping() {
        return this.msgMapping;
    }

    public void addAttributeMapping(CAFMessageAttribute target, CAFMessageAttribute source) {
        if (this.addAttributeMappingPrivate(target, source)) {
            this.saveMappings();
        }
    }

    public void addConstantMapping(CAFMessageAttribute target, String sourceConstant) {
        if (this.addConstantMappingPrivate(target, sourceConstant)) {
            this.saveMappings();
        }
    }

    public void removeAttributeMapping(CAFMessageAttribute target) {
        if (this.removeAttributeMappingPrivate(target)) {
            this.saveMappings();
        }
    }

    public void removeConstantMapping(CAFMessageAttribute target) {
        if (this.removeConstantMappingPrivate(target)) {
            this.saveMappings();
        }
    }

    public void removeNulls() {
        CAFWrapperBase.removeNulls(this.msgMapping.getMappingRules().iterator());
        Iterator i = new LinkedList(this.msgMapping.getMappingRules()).iterator();
        while (i.hasNext()) {
            new CAFMappingRule(this.bomSystem, (MappingRule)i.next(), this.context).removeNulls();
        }
        super.removeNulls();
    }

    public String toString() {
        return "wrapped: " + this.msgMapping;
    }

    public boolean validate() {
        boolean result = super.validate();
        if (!this.validateList(this.msgMapping, this.msgMapping.getMappingRules(), "mapping rule")) {
            result = false;
        }
        return result;
    }

    protected void removeInternal(CAFWrapperBase topMostRemovedObj) {
        CAFWrapperBase.removeInternal(topMostRemovedObj, this.msgMapping.getMappingRules());
        Iterator i = this.msgMapping.getMappingRules().iterator();
        while (i.hasNext()) {
            new CAFMappingRule(this.bomSystem, (MappingRule)i.next(), this.context).removeInternal(topMostRemovedObj);
        }
        super.removeInternal(topMostRemovedObj);
    }

    private boolean addAttributeMappingPrivate(CAFMessageAttribute target, CAFMessageAttribute source) {
        if (!this.isAttributeMappingAllowed(target, source)) {
            return false;
        }
        ListIterator targetIt = target.getAttributes().listIterator(target.getAttributes().size() - 1);
        ListIterator sourceIt = source.getAttributes().listIterator(source.getAttributes().size() - 1);
        while (targetIt.hasPrevious() && sourceIt.hasPrevious()) {
            Attribute targetAttr = (Attribute)targetIt.previous();
            Attribute sourceAttr = (Attribute)sourceIt.previous();
            if (targetAttr.getMaxOccurs() == 1) continue;
            CAFMessageAttribute targetCol = new CAFMessageAttribute(this.bomSystem, target.getMessage(), target.getAttributes().subList(0, targetIt.nextIndex() + 1));
            CAFMessageAttribute sourceCol = new CAFMessageAttribute(this.bomSystem, source.getMessage(), source.getAttributes().subList(0, sourceIt.nextIndex() + 1));
            this.colMappings.put(targetCol, sourceCol);
            Integer oldRefCount = (Integer)this.colMappingsRefCounts.get(targetCol);
            int newRefCount = oldRefCount != null ? oldRefCount + 1 : 1;
            this.colMappingsRefCounts.put(targetCol, new Integer(newRefCount));
        }
        this.attrMappings.put(target, source);
        return true;
    }

    private boolean addConstantMappingPrivate(CAFMessageAttribute target, String sourceConstant) {
        if (sourceConstant == null) {
            return this.removeConstantMappingPrivate(target);
        }
        return !sourceConstant.equals(this.constMappings.put(target, sourceConstant));
    }

    private Set constructCollectionMappingRule(CAFMessageAttribute target) {
        HashSet<String[]> retVal = new HashSet<String[]>();
        if (target.isSimple()) {
            CAFMessageAttribute source = (CAFMessageAttribute)this.attrMappings.get(target);
            String sourceConstant = (String)this.constMappings.get(target);
            if (source != null || sourceConstant != null) {
                String[] resolvedNames = new String[]{target.getResolvedName(), source != null ? source.getResolvedName() : null, sourceConstant != null ? sourceConstant : null};
                retVal.add(resolvedNames);
            }
        } else if (target.isCollection()) {
            CAFMessageAttribute source = (CAFMessageAttribute)this.colMappings.get(target);
            String[] resolvedNames = new String[]{"", "", ""};
            boolean attrMappingPresent = false;
            boolean constMappingPresent = false;
            Iterator i = target.getOwnedSubAttributes().iterator();
            while (i.hasNext()) {
                CAFMessageAttribute subAttr = (CAFMessageAttribute)i.next();
                Iterator j = this.constructCollectionMappingRule(subAttr).iterator();
                while (j.hasNext()) {
                    String[] resolvedSubNames = (String[])j.next();
                    resolvedNames[0] = resolvedNames[0] + resolvedSubNames[0].substring(target.getResolvedName().length() + 1) + ",";
                    if (resolvedSubNames[1] != null) {
                        resolvedNames[1] = resolvedNames[1] + resolvedSubNames[1].substring(source.getResolvedName().length() + 1);
                        attrMappingPresent = true;
                    }
                    resolvedNames[1] = resolvedNames[1] + ",";
                    if (resolvedSubNames[2] != null) {
                        resolvedNames[2] = resolvedNames[2] + DatasourceUtils.quoteAndEscape(resolvedSubNames[2]);
                        constMappingPresent = true;
                    }
                    resolvedNames[2] = resolvedNames[2] + ",";
                }
            }
            if (!resolvedNames[0].equals("")) {
                resolvedNames[0] = resolvedNames[0].substring(0, resolvedNames[0].length() - 1);
                resolvedNames[0] = target.getResolvedName() + "[" + resolvedNames[0] + "]";
                if (attrMappingPresent) {
                    resolvedNames[1] = resolvedNames[1].substring(0, resolvedNames[1].length() - 1);
                    resolvedNames[1] = source.getResolvedName() + "[" + resolvedNames[1] + "]";
                } else {
                    resolvedNames[1] = null;
                }
                if (constMappingPresent) {
                    resolvedNames[2] = resolvedNames[2].substring(0, resolvedNames[2].length() - 1);
                    resolvedNames[2] = "[" + resolvedNames[2] + "]";
                } else {
                    resolvedNames[2] = null;
                }
                retVal.add(resolvedNames);
            }
        } else {
            Iterator i = target.getOwnedSubAttributes().iterator();
            while (i.hasNext()) {
                CAFMessageAttribute subAttr = (CAFMessageAttribute)i.next();
                retVal.addAll(this.constructCollectionMappingRule(subAttr));
            }
        }
        return retVal;
    }

    private void deconstructCollectionMappingRule(String resolvedTargetName, String resolvedSourceName, String sourceConstant) {
        if (resolvedTargetName.charAt(resolvedTargetName.length() - 1) != ']') {
            CAFMessageAttribute target = this.targetMsg.getAttributeByResolvedName(resolvedTargetName);
            if (resolvedSourceName != null) {
                CAFMessageAttribute source = this.sourceMsg.getAttributeByResolvedName(resolvedSourceName);
                this.addAttributeMappingPrivate(target, source);
            }
            if (sourceConstant != null) {
                this.addConstantMappingPrivate(target, sourceConstant);
            }
        } else {
            int openingSqBracketIndex = resolvedTargetName.indexOf(91);
            CAFMessageAttribute target = this.targetMsg.getAttributeByResolvedName(resolvedTargetName.substring(0, openingSqBracketIndex));
            Iterator i = DatasourceUtils.parseList(resolvedTargetName.substring(openingSqBracketIndex + 1, resolvedTargetName.length() - 1)).iterator();
            Iterator j = null;
            CAFMessageAttribute source = null;
            if (resolvedSourceName != null) {
                openingSqBracketIndex = resolvedSourceName.indexOf(91);
                source = this.sourceMsg.getAttributeByResolvedName(resolvedSourceName.substring(0, openingSqBracketIndex));
                j = DatasourceUtils.parseList(resolvedSourceName.substring(openingSqBracketIndex + 1, resolvedSourceName.length() - 1)).iterator();
            }
            Iterator k = null;
            if (sourceConstant != null) {
                k = DatasourceUtils.parseListAndUnquoteAndUnescape(sourceConstant.substring(1, sourceConstant.length() - 1)).iterator();
            }
            while (i.hasNext()) {
                String newResolvedTargetName = target.getResolvedName() + '/' + (String)i.next();
                String newResolvedSourceName = null;
                if (j != null && (newResolvedSourceName = (String)j.next()) != null) {
                    newResolvedSourceName = source.getResolvedName() + '/' + newResolvedSourceName;
                }
                String newSourceConstant = null;
                if (k != null) {
                    newSourceConstant = (String)k.next();
                }
                this.deconstructCollectionMappingRule(newResolvedTargetName, newResolvedSourceName, newSourceConstant);
            }
        }
    }

    private void loadMappings() {
        this.colMappings = new HashMap();
        this.attrMappings = new HashMap();
        this.constMappings = new HashMap();
        this.colMappingsRefCounts = new HashMap();
        Iterator i = this.msgMapping.getMappingRules().iterator();
        while (i.hasNext()) {
            MappingRule mappingRule = (MappingRule)i.next();
            this.deconstructCollectionMappingRule(mappingRule.getResolvedTargetName(), mappingRule.getResolvedSourceName(), mappingRule.getSourceConstant());
        }
    }

    private boolean removeAttributeMappingPrivate(CAFMessageAttribute target) {
        ListIterator targetIt = target.getAttributes().listIterator(target.getAttributes().size() - 1);
        while (targetIt.hasPrevious()) {
            Attribute targetAttr = (Attribute)targetIt.previous();
            if (targetAttr.getMaxOccurs() == 1) continue;
            CAFMessageAttribute targetCol = new CAFMessageAttribute(this.bomSystem, target.getMessage(), target.getAttributes().subList(0, targetIt.nextIndex() + 1));
            int newRefCount = (Integer)this.colMappingsRefCounts.get(targetCol) - 1;
            if (newRefCount > 0) {
                this.colMappingsRefCounts.put(targetCol, new Integer(newRefCount));
                continue;
            }
            this.colMappings.remove(targetCol);
            this.colMappingsRefCounts.remove(targetCol);
        }
        return this.attrMappings.remove(target) != null;
    }

    private boolean removeConstantMappingPrivate(CAFMessageAttribute target) {
        return this.constMappings.remove(target) != null;
    }

    private void removeMappingRules() {
        Iterator i = new LinkedList(this.msgMapping.getMappingRules()).iterator();
        this.msgMapping.getMappingRules().clear();
        while (i.hasNext()) {
            new CAFMappingRule(this.bomSystem, (MappingRule)i.next(), this.context).remove();
        }
    }

    private void saveMappings() {
        this.removeMappingRules();
        MetamodelPackage metamodelPackage = this.bomSystem.getMetamodelPackage();
        Iterator i = this.targetMsg.getMessage().getMessageParts().iterator();
        while (i.hasNext()) {
            CAFMessageAttribute topAttr = new CAFMessageAttribute(this.bomSystem, this.targetMsg.getMessage(), (Attribute)i.next());
            Iterator j = this.constructCollectionMappingRule(topAttr).iterator();
            while (j.hasNext()) {
                String[] resolvedNames = (String[])j.next();
                MappingRule newMappingRule = metamodelPackage.getMappingRule().createMappingRule();
                newMappingRule.setResolvedTargetName(resolvedNames[0]);
                newMappingRule.setResolvedSourceName(resolvedNames[1]);
                newMappingRule.setSourceConstant(resolvedNames[2]);
                this.msgMapping.getMappingRules().add(newMappingRule);
            }
        }
    }
}

