/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFMessage;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class CAFMessageAttribute
implements Comparable {
    private Message message;
    private LinkedList attributes;
    private BOMSystem bomSystem;

    public CAFMessageAttribute(BOMSystem bomSystem, Message message, Attribute attribute) {
        this.bomSystem = bomSystem;
        this.message = message;
        this.attributes = new LinkedList();
        this.attributes.add(attribute);
    }

    public CAFMessageAttribute(BOMSystem bomSystem, Message message, List attributes) {
        this.bomSystem = bomSystem;
        this.message = message;
        this.attributes = new LinkedList(attributes);
    }

    public CAFMessageAttribute(BOMSystem bomSystem, Message message, List parentAttributes, Attribute attribute) {
        this.bomSystem = bomSystem;
        this.message = message;
        this.attributes = new LinkedList(parentAttributes);
        this.attributes.add(attribute);
    }

    public List getAttributes() {
        return this.attributes;
    }

    public List getAttributesWithoutLast() {
        LinkedList retVal = new LinkedList(this.attributes);
        retVal.removeLast();
        return retVal;
    }

    public boolean isCollection() {
        return this.getLastAttribute().getMaxOccurs() != 1;
    }

    public Attribute getLastAttribute() {
        return (Attribute)this.attributes.getLast();
    }

    public boolean isSimple() {
        return this.getLastAttribute().getReferencedObject() == null;
    }

    public Message getMessage() {
        return this.message;
    }

    public List getOwnedSubAttributes() {
        return this.getSubAttributesAux(true);
    }

    public BusinessEntityInterface getOwningBusinessEntityInterface() {
        MOFInterface owningInterface;
        Operation owningOp = new CAFMessage(this.bomSystem, this.message).getOwningOperation();
        if (owningOp != null && (owningInterface = owningOp.getMOFInterface()) instanceof BusinessEntityInterface) {
            return (BusinessEntityInterface)owningInterface;
        }
        return null;
    }

    public String getResolvedName() {
        String retVal = "";
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            retVal = retVal + ((Attribute)i.next()).getObjectName();
            if (!i.hasNext()) continue;
            retVal = retVal + "/";
        }
        return retVal;
    }

    public List getSubAttributes() {
        return this.getSubAttributesAux(false);
    }

    public int compareTo(Object o) {
        CAFMessageAttribute other = (CAFMessageAttribute)o;
        int intermediateResult = this.message.getObjectId().compareTo(other.message.getObjectId());
        if (intermediateResult != 0) {
            return intermediateResult;
        }
        Iterator i = this.attributes.iterator();
        Iterator j = other.attributes.iterator();
        while (i.hasNext() && j.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            Attribute otherAttribute = (Attribute)j.next();
            intermediateResult = attribute.getObjectId().compareTo(otherAttribute.getObjectId());
            if (intermediateResult == 0) continue;
            return intermediateResult;
        }
        if (i.hasNext() && !j.hasNext()) {
            return 1;
        }
        if (!i.hasNext() && j.hasNext()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CAFMessageAttribute)) {
            return false;
        }
        CAFMessageAttribute other = (CAFMessageAttribute)obj;
        if (!this.message.getObjectId().equals(other.message.getObjectId())) {
            return false;
        }
        Iterator i = this.attributes.iterator();
        Iterator j = other.attributes.iterator();
        while (i.hasNext() && j.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            Attribute otherAttribute = (Attribute)j.next();
            if (attribute.getObjectId().equals(otherAttribute.getObjectId())) continue;
            return false;
        }
        return !i.hasNext() && !j.hasNext();
    }

    public int hashCode() {
        int hashCode = this.message.getObjectId().hashCode();
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            hashCode += attribute.hashCode();
        }
        return hashCode;
    }

    private void getSubAttributesAux(boolean ownedOnly, Collection input, List output) {
        Iterator i = input.iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            if (ownedOnly && CAFBusinessEntityInterface.isEntityAttribute(attribute)) continue;
            output.add(new CAFMessageAttribute(this.bomSystem, this.message, this.attributes, attribute));
        }
    }

    private List getSubAttributesAux(boolean ownedOnly) {
        LinkedList subAttributes = new LinkedList();
        DataStructure dataStructure = this.getLastAttribute().getReferencedObject();
        if (dataStructure != null) {
            this.getSubAttributesAux(ownedOnly, dataStructure.getKeys(), subAttributes);
            this.getSubAttributesAux(ownedOnly, dataStructure.getAttributes(), subAttributes);
        }
        return subAttributes;
    }
}

