/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFAttribute;
import com.sap.caf.designer.structure.CAFBaseObject;
import com.sap.caf.designer.structure.CAFMessageAttribute;
import com.sap.caf.designer.structure.CAFProperty;
import com.sap.caf.designer.structure.CAFWrapperBase;
import com.sap.caf.designer.utils.DatasourceUtils;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.Property;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class CAFMessage
extends CAFBaseObject {
    private Message message;

    public CAFMessage(BOMSystem bomSystem, Message message, Map context) {
        super(bomSystem, (BaseObject)message, context);
        this.message = message;
    }

    public CAFMessage(BOMSystem bomSystem, Message message) {
        this(bomSystem, message, null);
    }

    public CAFMessageAttribute getAttributeByResolvedName(String resolvedName) {
        Iterator parsedResolvedNamePart = DatasourceUtils.parseResolvedName(resolvedName).iterator();
        if (!parsedResolvedNamePart.hasNext()) {
            return null;
        }
        String firstAttrName = (String)parsedResolvedNamePart.next();
        Attribute firstAttribute = DatasourceUtils.findAttributeByName(this.message.getMessageParts(), firstAttrName);
        if (firstAttribute == null) {
            return null;
        }
        CAFMessageAttribute retVal = new CAFMessageAttribute(this.bomSystem, this.message, firstAttribute);
        while (parsedResolvedNamePart.hasNext()) {
            String nextAttrName = (String)parsedResolvedNamePart.next();
            CAFMessageAttribute nextAttr = null;
            Iterator i = retVal.getOwnedSubAttributes().iterator();
            while (i.hasNext()) {
                nextAttr = (CAFMessageAttribute)i.next();
                if (nextAttr.getLastAttribute().getObjectName().equals(nextAttrName)) break;
                nextAttr = null;
            }
            if (nextAttr == null) {
                return null;
            }
            retVal = nextAttr;
        }
        return retVal;
    }

    public Message getMessage() {
        return this.message;
    }

    public Operation getOwningOperation() {
        Collection ops = this.message.getInputMessageOperation();
        if (!ops.isEmpty()) {
            return (Operation)ops.iterator().next();
        }
        ops = this.message.getOutputMessageOperation();
        if (!ops.isEmpty()) {
            return (Operation)ops.iterator().next();
        }
        if (this.message instanceof FaultMessage && !(ops = ((FaultMessage)this.message).getFaultMessageOperation()).isEmpty()) {
            return (Operation)ops.iterator().next();
        }
        return null;
    }

    public void removeNulls() {
        CAFWrapperBase.removeNulls(this.message.getInputMessageOperation().iterator());
        CAFWrapperBase.removeNulls(this.message.getMessageParts().iterator());
        CAFWrapperBase.removeNulls(this.message.getOutputMessageOperation().iterator());
        if (this.ownsAttributes()) {
            Iterator i = new LinkedList(this.message.getMessageParts()).iterator();
            while (i.hasNext()) {
                Attribute attr = (Attribute)i.next();
                if (attr instanceof Property) {
                    new CAFProperty(this.bomSystem, (Property)attr, this.context).removeNulls();
                    continue;
                }
                new CAFAttribute(this.bomSystem, attr, this.context).removeNulls();
            }
        }
        super.removeNulls();
    }

    public String toString() {
        return "wrapped: " + this.message;
    }

    public boolean validate() {
        boolean result = super.validate();
        if (!this.validateList(this.message, this.message.getMessageParts(), "parameter")) {
            result = false;
        }
        return result;
    }

    protected void removeInternal(CAFWrapperBase topMostRemovedObj) {
        if (this.ownsAttributes()) {
            CAFWrapperBase.removeInternal(topMostRemovedObj, this.message.getMessageParts());
            Iterator i = this.message.getMessageParts().iterator();
            while (i.hasNext()) {
                Attribute attr = (Attribute)i.next();
                if (attr instanceof Property) {
                    new CAFProperty(this.bomSystem, (Property)attr, this.context).removeInternal(topMostRemovedObj);
                    continue;
                }
                new CAFAttribute(this.bomSystem, attr, this.context).removeInternal(topMostRemovedObj);
            }
        }
        super.removeInternal(topMostRemovedObj);
    }

    private boolean ownsAttributes() {
        Collection ops = this.message.getInputMessageOperation();
        if (!ops.isEmpty()) {
            return ((Operation)ops.iterator().next()).getPatternType() == 5;
        }
        if (this.message instanceof FaultMessage) {
            ops = ((FaultMessage)this.message).getFaultMessageOperation();
            return ops.isEmpty();
        }
        return false;
    }
}

