/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFMessageAttribute;
import com.sap.caf.designer.structure.CAFWrapperBase;
import com.sap.caf.designer.utils.DatasourceUtils;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.MappingRule;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.MessageMapping;
import com.sap.caf.metamodel.MessageMappingMessageRules;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jmi.reflect.RefObject;

public class CAFMappingRule
extends CAFWrapperBase {
    private MappingRule mappingRule;

    public CAFMappingRule(BOMSystem bomSystem, MappingRule mappingRule, Map context) {
        super(bomSystem, (RefObject)mappingRule, context);
        this.mappingRule = mappingRule;
    }

    public CAFMappingRule(BOMSystem bomSystem, MappingRule mappingRule) {
        this(bomSystem, mappingRule, null);
    }

    public MappingRule getMappingRule() {
        return this.mappingRule;
    }

    public CAFMessageAttribute getSourceAttribute() {
        MessageMappingMessageRules messageMappingMessageRules = this.bomSystem.getMetamodelPackage().getMessageMappingMessageRules();
        MessageMapping msgMapping = messageMappingMessageRules.getMessageMapping(this.mappingRule);
        return this.getSourceOrTargetAttribute(this.mappingRule.getResolvedSourceName(), msgMapping.getSource());
    }

    public String getSourceConstant() {
        return this.mappingRule.getSourceConstant();
    }

    public CAFMessageAttribute getTargetAttribute() {
        MessageMappingMessageRules messageMappingMessageRules = this.bomSystem.getMetamodelPackage().getMessageMappingMessageRules();
        MessageMapping msgMapping = messageMappingMessageRules.getMessageMapping(this.mappingRule);
        return this.getSourceOrTargetAttribute(this.mappingRule.getResolvedTargetName(), msgMapping.getTarget());
    }

    public void removeNulls() {
        super.removeNulls();
    }

    public String toString() {
        return "wrapped: " + this.mappingRule;
    }

    public boolean validate() {
        boolean result = super.validate();
        return result;
    }

    protected void removeInternal(CAFWrapperBase topMostRemovedObj) {
        super.removeInternal(topMostRemovedObj);
    }

    private CAFMessageAttribute getSourceOrTargetAttribute(List parsedResolvedName, CAFMessageAttribute parentAttr) {
        if (parsedResolvedName.isEmpty()) {
            return parentAttr;
        }
        DataStructure dataStructure = parentAttr.getLastAttribute().getReferencedObject();
        if (dataStructure != null) {
            String namePart = (String)parsedResolvedName.get(0);
            Iterator i = dataStructure.getAttributes().iterator();
            Attribute attribute = null;
            while (i.hasNext()) {
                attribute = (Attribute)i.next();
                if (namePart.equals(attribute.getObjectName())) break;
                attribute = null;
            }
            if (attribute != null) {
                LinkedList restParsedResolvedName = new LinkedList(parsedResolvedName);
                restParsedResolvedName.remove(0);
                return this.getSourceOrTargetAttribute(restParsedResolvedName, new CAFMessageAttribute(this.bomSystem, parentAttr.getMessage(), parentAttr.getAttributes(), attribute));
            }
        }
        return null;
    }

    private CAFMessageAttribute getSourceOrTargetAttribute(String resolvedName, Message msg) {
        if (resolvedName == null) {
            return null;
        }
        LinkedList parsedResolvedName = DatasourceUtils.parseResolvedName(resolvedName);
        String firstNamePart = (String)parsedResolvedName.get(0);
        LinkedList restParsedResolvedName = parsedResolvedName = new LinkedList(parsedResolvedName);
        restParsedResolvedName.remove(0);
        Iterator i = msg.getMessageParts().iterator();
        Attribute firstAttribute = null;
        while (i.hasNext()) {
            firstAttribute = (Attribute)i.next();
            if (firstNamePart.equals(firstAttribute.getObjectName())) break;
            firstAttribute = null;
        }
        if (firstAttribute != null) {
            return this.getSourceOrTargetAttribute(restParsedResolvedName, new CAFMessageAttribute(this.bomSystem, msg, firstAttribute));
        }
        return null;
    }
}

