/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.exception.CAFBaseException;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFConfiguration;
import com.sap.caf.designer.structure.CAFInterface;
import com.sap.caf.designer.structure.CAFWrapperBase;
import com.sap.caf.designer.utils.ProxyConfig;
import com.sap.caf.imports.mp2mmr.ConversionException;
import com.sap.caf.imports.mp2mmr.MP2MMRImportImpl;
import com.sap.caf.metamodel.ExternalInterface;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.MetamodelPackage;
import com.sap.caf.mp.base.exception.EngineException;
import com.sap.caf.mp.base.exception.InvocationException;
import com.sap.caf.mp.core.data.service.manager.wsdl11.WsdlToIMessageConverter;
import com.sap.caf.mp.core.data.service.registry.IServiceDefinition;
import com.sap.caf.mp.core.data.service.registry.ServiceDefinition;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.AbstractList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class CAFExternalInterface
extends CAFInterface {
    private ExternalInterface externalInterface;

    public CAFExternalInterface(BOMSystem bomSystem, ExternalInterface externalInterface, Map context) {
        super(bomSystem, (MOFInterface)externalInterface, context);
        this.externalInterface = externalInterface;
    }

    public CAFExternalInterface(BOMSystem bomSystem, ExternalInterface externalInterface) {
        this(bomSystem, externalInterface, null);
    }

    public ExternalInterface getExternalInterface() {
        return this.externalInterface;
    }

    public String getTechnicalIdentifier() {
        return super.getTechnicalIdentifier((MOFInterface)this.externalInterface, this.bomSystem);
    }

    public void removeNulls() {
        if (this.externalInterface.getConfiguration() != null) {
            new CAFConfiguration(this.bomSystem, this.externalInterface.getConfiguration(), this.context).removeNulls();
        }
        super.removeNulls();
    }

    public String toString() {
        return "wrapped: " + this.externalInterface;
    }

    public boolean validate() {
        boolean result = true;
        if (!super.validate()) {
            result = false;
        }
        if (this.externalInterface.getOperations().size() == 0 && this.externalInterface.getClientDependency().size() == 0) {
            this.bomSystem.getStatus().addWarningMessage("XS (" + this.externalInterface.getObjectName() + ") has no usefull features defined.", null);
        }
        return result;
    }

    protected void removeInternal(CAFWrapperBase topMostRemovedObj) {
        super.removeInternal(topMostRemovedObj);
    }

    public static IServiceDefinition[] importWebServicesMP(URL wsld, ProxyConfig proxyconf) throws InvocationException, EngineException {
        URL proxy = null;
        if (proxyconf != null) {
            proxy = proxyconf.checkNeedProxy(wsld) ? proxyconf.urlHttpProxy : null;
        }
        WsdlToIMessageConverter converter = new WsdlToIMessageConverter(wsld.toExternalForm(), proxy, null);
        return CAFExternalInterface.extractServiceDefinitions(converter);
    }

    private static IServiceDefinition[] extractServiceDefinitions(WsdlToIMessageConverter converter) throws InvocationException, EngineException {
        Vector wsres = converter.getServiceDefinitions("WSDL 1.1");
        int i = 0;
        IServiceDefinition[] res = new IServiceDefinition[wsres.size()];
        Properties properties = new Properties();
        Iterator iter = ((AbstractList)wsres).iterator();
        while (iter.hasNext()) {
            IServiceDefinition serviceDefinition;
            res[i] = serviceDefinition = (IServiceDefinition)iter.next();
            ++i;
            Enumeration enumeration = serviceDefinition.getOperationProperties().elements();
            while (enumeration.hasMoreElements()) {
                Properties prop = (Properties)enumeration.nextElement();
                ((Hashtable)prop).putAll(serviceDefinition.getPortTypeProperties());
                ((Hashtable)prop).putAll(properties);
                ((Hashtable)prop).put("endpoint.url", serviceDefinition.getPortTypeProperties().getProperty("address"));
            }
            ((Hashtable)serviceDefinition.getPortTypeProperties()).putAll(properties);
        }
        return res;
    }

    public static IServiceDefinition analyseWSDLContent(Reader wsdl) throws InvocationException, EngineException, IOException {
        IServiceDefinition iServiceDefinition;
        File tmpFile = CAFExternalInterface.storeIntoTempFile(wsdl);
        try {
            WsdlToIMessageConverter converter = new WsdlToIMessageConverter(tmpFile.toURL().toExternalForm(), null, null);
            IServiceDefinition[] res = CAFExternalInterface.extractServiceDefinitions(converter);
            if (res.length != 1) {
                throw new RuntimeException("Unexpected number of Web Services described into one WSDL file.");
            }
            iServiceDefinition = res[1];
            Object var6_5 = null;
            tmpFile.deleteOnExit();
            tmpFile.delete();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            tmpFile.deleteOnExit();
            tmpFile.delete();
            throw throwable;
        }
        return iServiceDefinition;
    }

    public static CAFExternalInterface createFromWSDLContent(BOMSystem bos, Reader wsdl) throws InvocationException, EngineException, ConversionException, CAFBaseException {
        try {
            IServiceDefinition ws = CAFExternalInterface.analyseWSDLContent(wsdl);
            return CAFExternalInterface.createFromMPServiceDef(bos, ws, ws.getPortType().getName());
        }
        catch (IOException ex) {
            throw new CAFBaseException(ex);
        }
    }

    private static File storeIntoTempFile(Reader r) throws IOException {
        File file;
        block6: {
            boolean bSucc = false;
            file = File.createTempFile("externalsrv", ".wsdl", new File(System.getProperty("java.io.tmpdir")));
            try {
                char[] buffer = new char[8192];
                FileWriter output = new FileWriter(file);
                try {
                    int nLen = r.read(buffer);
                    while (nLen >= 0) {
                        output.write(buffer, 0, nLen);
                        nLen = r.read(buffer);
                    }
                    output.flush();
                    Object var7_6 = null;
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    output.close();
                    throw throwable;
                }
                output.close();
                bSucc = true;
                Object var9_9 = null;
                if (bSucc) break block6;
                file.delete();
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (!bSucc) {
                    file.delete();
                }
                throw throwable;
            }
            {
            }
        }
        return file;
    }

    public static CAFExternalInterface createFromMPServiceDef(BOMSystem bomsystem, IServiceDefinition sf, String name) throws InvocationException, EngineException, ConversionException, CAFBaseException {
        MetamodelPackage metamodel = bomsystem.getMetamodelPackage();
        MP2MMRImportImpl mmrImporter = new MP2MMRImportImpl();
        mmrImporter.setCreator(System.getProperty("user.name"));
        mmrImporter.setCreationDate(new Date());
        if (bomsystem.getExternalInterfaces().containsKey(name)) {
            throw new ConversionException(1);
        }
        ExternalInterface newExtInterface = mmrImporter.storeService((ServiceDefinition)sf, metamodel, name);
        CAFExternalInterface res = new CAFExternalInterface(bomsystem, newExtInterface);
        bomsystem.getExternalInterfaces().put(newExtInterface.getObjectName(), res);
        bomsystem.getApplication().getBaseObjects().add(newExtInterface);
        return res;
    }
}

