/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFDataStructure;
import com.sap.caf.designer.structure.CAFTable;
import com.sap.caf.designer.structure.CAFWrapperBase;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.Table;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class CAFDataObject
extends CAFDataStructure {
    private DataObject dataObject;

    public CAFDataObject(BOMSystem bomSystem, DataObject dataObject, Map context) {
        super(bomSystem, (DataStructure)dataObject, context);
        this.dataObject = dataObject;
    }

    public CAFDataObject(BOMSystem bomSystem, DataObject dataObject) {
        this(bomSystem, dataObject, null);
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    protected void removeInternal(CAFWrapperBase topMostRemovedObj) {
        if (this.dataObject.getMasterTable() != null) {
            new CAFTable(this.bomSystem, this.dataObject.getMasterTable(), this.context).removeInternal(topMostRemovedObj);
        }
        CAFWrapperBase.removeInternal(topMostRemovedObj, this.dataObject.getSourceTable());
        Iterator i = this.dataObject.getSourceTable().iterator();
        while (i.hasNext()) {
            new CAFTable(this.bomSystem, (Table)i.next(), this.context).removeInternal(topMostRemovedObj);
        }
        CAFWrapperBase.removeInternal(topMostRemovedObj, this.dataObject.getTargetTable());
        i = this.dataObject.getTargetTable().iterator();
        while (i.hasNext()) {
            new CAFTable(this.bomSystem, (Table)i.next(), this.context).removeInternal(topMostRemovedObj);
        }
        super.removeInternal(topMostRemovedObj);
    }

    public void removeNulls() {
        CAFWrapperBase.removeNulls(this.dataObject.getSourceTable().iterator());
        CAFWrapperBase.removeNulls(this.dataObject.getTargetTable().iterator());
        if (this.dataObject.getMasterTable() != null) {
            new CAFTable(this.bomSystem, this.dataObject.getMasterTable(), this.context).removeNulls();
        }
        Iterator i = new LinkedList(this.dataObject.getSourceTable()).iterator();
        while (i.hasNext()) {
            new CAFTable(this.bomSystem, (Table)i.next(), this.context).removeNulls();
        }
        i = new LinkedList(this.dataObject.getTargetTable()).iterator();
        while (i.hasNext()) {
            new CAFTable(this.bomSystem, (Table)i.next(), this.context).removeNulls();
        }
        super.removeNulls();
    }

    public boolean validate() {
        boolean result = super.validate();
        if (!this.validateList(this.dataObject, this.dataObject.getTargetTable(), "target table")) {
            result = false;
        }
        if (!this.validateList(this.dataObject, this.dataObject.getSourceTable(), "source table")) {
            result = false;
        }
        if (this.dataObject.getBusinessEntityInterface() != null && !this.validateList(this.dataObject, this.dataObject.getKeys(), "KEY ATTRIBUTE")) {
            this.bomSystem.getStatus().addErrorMessage("The DATA OBJECT '" + this.dataObject.getObjectName() + "' has no KEY ATTRIBUTE.");
            result = false;
        }
        return result;
    }

    public String toString() {
        return "wrapped: " + this.dataObject;
    }
}

