/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.dtr.DtrService;
import com.sap.caf.designer.dtr.IResourceChangeListener;
import com.sap.caf.designer.exception.CAFResourceException;
import com.sap.caf.designer.exception.CAFRuntimeException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.exception.GeneratorNotificationException;
import com.sap.caf.designer.generation.CAFApplicationGenerator;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.generation.IGenerateable;
import com.sap.caf.designer.generation.utils.NameServiceNameValidator;
import com.sap.caf.designer.structure.BOMActivity;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFAttribute;
import com.sap.caf.designer.structure.CAFDataObject;
import com.sap.caf.designer.structure.CAFField;
import com.sap.caf.designer.structure.CAFInterface;
import com.sap.caf.designer.structure.CAFOperation;
import com.sap.caf.designer.structure.CAFOperationMapping;
import com.sap.caf.designer.structure.CAFProperty;
import com.sap.caf.designer.structure.CAFTable;
import com.sap.caf.designer.structure.CAFWrapperBase;
import com.sap.caf.designer.structure.TableNameGenerator;
import com.sap.caf.designer.structure.util.DefaultValues;
import com.sap.caf.designer.utils.OpenSQLReservedWords;
import com.sap.caf.designer.validation.AMarkerResolution;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.metamodel.Field;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.OperationMapping;
import com.sap.caf.metamodel.Permission;
import com.sap.caf.metamodel.Property;
import com.sap.caf.metamodel.Table;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.ResourceException;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.lcr.namealloc.api.CommunicationFailureException;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.IMarkerResolution;

public class CAFBusinessEntityInterface
extends CAFInterface
implements IGenerateable {
    private static IConnection conn = null;
    private static final TextPool mTextPool = TextPool.getInstance();
    private static HashSet m_hashTblNames = new HashSet();
    private static HashSet m_bomSystemsTblNamesImported = new HashSet();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$structure$CAFBusinessEntityInterface == null ? (class$com$sap$caf$designer$structure$CAFBusinessEntityInterface = CAFBusinessEntityInterface.class$("com.sap.caf.designer.structure.CAFBusinessEntityInterface")) : class$com$sap$caf$designer$structure$CAFBusinessEntityInterface);
    public static final String FIND_BY_MULTIPLE_PARAMS_METHOD = "findByMultipleParameters";
    public static final String[] DEFAULT_ATTRIBUTES = new String[]{"key", "createdAt", "createdBy", "lastChangedAt", "lastChangedBy"};
    public static final String[] CRUDOperations = new String[]{"validate", "create", "read", "update", "delete"};
    public static final String[] KMOperations = new String[]{"getCategories", "getClassification", "addClassification", "removeClassification", "findByKMPropertySearch", "searchidxForSimilar"};
    public static final String[] RESERVEDOperations = new String[]{"validate", "create", "read", "update", "delete", "getCategories", "getClassification", "addClassification", "removeClassification", "findByKMPropertySearch", "searchidxForSimilar", "findByMultipleParameters"};
    public static final int ATTR_CREATE = 1;
    public static final int ATTR_REMOVE = 2;
    public static final int ATTR_CHANGE = 3;
    public static final int ATTR_RENAME = 4;
    private BusinessEntityInterface businessEntityInterface;
    private final Integer DEFAULT_KM_TRANSACTION_TYPE = new Integer(4);
    static /* synthetic */ Class class$com$sap$caf$designer$structure$CAFBusinessEntityInterface;

    public CAFBusinessEntityInterface(BOMSystem bomSystem, BusinessEntityInterface businessEntityInterface, Map context) {
        super(bomSystem, (MOFInterface)businessEntityInterface, context);
        this.businessEntityInterface = businessEntityInterface;
    }

    public CAFBusinessEntityInterface(BOMSystem bomSystem, BusinessEntityInterface businessEntityInterface) {
        this(bomSystem, businessEntityInterface, null);
    }

    public static boolean isComplexAttribute(Attribute attr) {
        return attr.getTypeJavaDdic() == null && attr.getReferencedObject() != null && attr.getReferencedObject() instanceof DataObject && ((DataObject)attr.getReferencedObject()).getBusinessEntityInterface() == null;
    }

    public static boolean isDefaultAttribute(Attribute attr) {
        int i = 0;
        while (i < DEFAULT_ATTRIBUTES.length) {
            if (attr != null && DEFAULT_ATTRIBUTES[i].equals(attr.getObjectName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isDefaultAttributeName(String attrName) {
        int i = 0;
        while (i < DEFAULT_ATTRIBUTES.length) {
            if (DEFAULT_ATTRIBUTES[i].equals(attrName)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isEntityAttribute(Attribute attr) {
        return attr.getTypeJavaDdic() == null && attr.getReferencedObject() != null && attr.getReferencedObject() instanceof DataObject && ((DataObject)attr.getReferencedObject()).getBusinessEntityInterface() != null;
    }

    public static Table getLanguageTable(DataObject data) {
        Table langTable = null;
        Iterator it = data.getAttributes().iterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            if (!prop.isLanguageDependent().booleanValue()) continue;
            langTable = ((Field)prop.getField().iterator().next()).getTable();
            if (data.getMasterTable() == langTable) continue;
            return langTable;
        }
        return null;
    }

    public static final String getNamePrefix() {
        return "XAP";
    }

    public static String getRandomString(int len) {
        byte[] bytes = new byte[len];
        int i = 0;
        while (i < len) {
            byte x = (byte)(36.0 * Math.random());
            bytes[i] = x >= 26 ? (byte)(x + 48 - 26) : (byte)(x + 65);
            ++i;
        }
        return new String(bytes);
    }

    public static CAFBusinessEntityInterface createBusinessEntityInterface(BOMSystem bomsystem, String name) throws CAFResourceException {
        bomsystem.notifyCreateBussinesEntityServiceBefore(null);
        BusinessEntityInterface bei = bomsystem.getMetamodelPackage().getBusinessEntityInterface().createBusinessEntityInterface();
        DefaultValues.setDefaults(bei, DefaultValues.BUSINESS_ENTITY_INTERFACE);
        bei.setObjectName(name + "Service");
        DataObject data = bomsystem.getMetamodelPackage().getDataObject().createDataObject();
        data.setObjectId(data.refMofId());
        data.setObjectName(name);
        BOMSystem.baseObjectCreated((BaseObject)data);
        bei.setBusinessEntity(data);
        bomsystem.getApplication().getBaseObjects().add(bei);
        CAFBusinessEntityInterface wbai = new CAFBusinessEntityInterface(bomsystem, bei);
        bomsystem.getBusinessEntityInterfaces().put(bei.getBusinessEntity().getObjectName(), wbai);
        try {
            Table table = wbai.createTable(name, "");
            data.setMasterTable(table);
            String description = CAFBusinessEntityInterface.createTableDescription("TABLENAME_DESCRIPTION_BUSINESSENTITY", name, "");
            table.setTableDescription(description);
        }
        catch (TableNameGenerator.InvalidNameArgument ex) {
            throw new CAFRuntimeException("New entity name cannot be invalid table name.");
        }
        Property attrKey = wbai.addKeyAttribute("key");
        DefaultValues.setDefaults(attrKey, null);
        attrKey.setTypeJavaDdic("com.sap.caf.core.id");
        attrKey.setShortText("Key");
        attrKey.setMinOccurs(new Integer(0));
        Property createdBy = wbai.addSimpleAttribute("createdBy");
        DefaultValues.setDefaults(createdBy, null);
        createdBy.setTypeJavaDdic("com.sap.caf.core.userId");
        createdBy.setShortText("Created By");
        Property createdAt = wbai.addSimpleAttribute("createdAt");
        DefaultValues.setDefaults(createdAt, null);
        createdAt.setTypeJavaDdic("com.sap.caf.core.timestamp");
        createdAt.setShortText("Created At");
        Property lastChangedBy = wbai.addSimpleAttribute("lastChangedBy");
        DefaultValues.setDefaults(lastChangedBy, null);
        lastChangedBy.setTypeJavaDdic("com.sap.caf.core.userId");
        lastChangedBy.setShortText("Last Changed By");
        Property lastChangedAt = wbai.addSimpleAttribute("lastChangedAt");
        DefaultValues.setDefaults(lastChangedAt, null);
        lastChangedAt.setTypeJavaDdic("com.sap.caf.core.timestamp");
        lastChangedAt.setShortText("Last Changed At");
        Operation createOp = wbai.createOperation();
        DefaultValues.setDefaults(createOp, DefaultValues.OPERATION_CREATE);
        createOp.getPermission().setImplicitCheck(new Integer(1));
        wbai.addOperationInputAttribute(createOp, attrKey);
        wbai.addOperationInputAttribute(createOp, createdBy);
        wbai.addOperationInputAttribute(createOp, createdAt);
        wbai.addOperationInputAttribute(createOp, lastChangedBy);
        wbai.addOperationInputAttribute(createOp, lastChangedAt);
        Operation readOp = wbai.createOperation();
        DefaultValues.setDefaults(readOp, DefaultValues.OPERATION_READ);
        wbai.addOperationInputAttribute(readOp, attrKey);
        Operation updateOp = wbai.createOperation();
        DefaultValues.setDefaults(updateOp, DefaultValues.OPERATION_UPDATE);
        wbai.addOperationInputAttribute(updateOp, attrKey);
        wbai.addOperationInputAttribute(updateOp, createdBy);
        wbai.addOperationInputAttribute(updateOp, createdAt);
        wbai.addOperationInputAttribute(updateOp, lastChangedBy);
        wbai.addOperationInputAttribute(updateOp, lastChangedAt);
        Operation deleteOp = wbai.createOperation();
        DefaultValues.setDefaults(deleteOp, DefaultValues.OPERATION_DELETE);
        wbai.addOperationInputAttribute(deleteOp, attrKey);
        bomsystem.notifyCreateBussinesEntityServiceAfter(wbai);
        return wbai;
    }

    public static String createFieldName(String name, Table table) {
        String fieldName = name.toUpperCase();
        if (fieldName.length() > 18) {
            fieldName = fieldName.substring(0, 18);
        }
        Iterator it = table.getFields().iterator();
        HashMap<String, String> m = new HashMap<String, String>();
        while (it.hasNext()) {
            Field fld = (Field)it.next();
            if (fld == null) continue;
            m.put(fld.getFieldName(), fld.getFieldName());
        }
        return CAFBusinessEntityInterface.getName(name, m);
    }

    public static void registerGeneratedTableNames(BOMSystem bomsyst) throws CAFResourceException {
        if (!m_bomSystemsTblNamesImported.contains(bomsyst)) {
            Collection allTables = CAFBusinessEntityInterface.getAllLocalTableNames(bomsyst);
            m_hashTblNames.addAll(allTables);
            m_bomSystemsTblNamesImported.add(bomsyst);
        }
    }

    public static void registerTableName(String tableName) {
        m_hashTblNames.add(tableName);
    }

    public static void unregisterTableName(String tableName) {
        m_hashTblNames.remove(tableName);
    }

    public Collection getAllLocalTableNames() throws CAFResourceException {
        return CAFBusinessEntityInterface.getAllLocalTableNames(this.bomSystem);
    }

    public static Collection getAllLocalTableNames(BOMSystem bomSystem) throws CAFResourceException {
        try {
            List typeList = Utilities.getUtilities().decodeQualifiedName("com.sap.caf.metamodel.Table");
            List tabs = bomSystem.getConnection().queryM1(typeList, null, true);
            Iterator it = tabs.iterator();
            ArrayList<String> result = new ArrayList<String>();
            while (it.hasNext()) {
                try {
                    result.add(((Table)it.next()).getTableName());
                }
                catch (ClassCastException ex) {
                    // empty catch block
                }
            }
            return result;
        }
        catch (ResourceException e) {
            throw new CAFResourceException((Exception)((Object)e));
        }
    }

    public Attribute getAttributeByName(String name) {
        DataObject data = this.businessEntityInterface.getBusinessEntity();
        return this.getSubAttributeByName(name, (DataStructure)data);
    }

    public Map getAttributesMap() {
        List attrs = this.readCurrentAttributes();
        HashMap<String, Attribute> m = new HashMap<String, Attribute>();
        int i = 0;
        while (i < attrs.size()) {
            Attribute attr = (Attribute)attrs.get(i);
            m.put(attr.getObjectName(), attr);
            ++i;
        }
        return null;
    }

    public BusinessEntityInterface getBusinesEntityInterface() {
        return this.businessEntityInterface;
    }

    public Attribute getComplexParent(Attribute attr) {
        List allAttrs = this.readCurrentAttributes();
        Iterator it = allAttrs.iterator();
        while (it.hasNext()) {
            Attribute prop = (Attribute)it.next();
            if (!CAFBusinessEntityInterface.isComplexAttribute(prop)) continue;
            List allSubAttr = prop.getReferencedObject().getAttributes();
            int i = 0;
            while (i < allSubAttr.size()) {
                Attribute sub = (Attribute)allSubAttr.get(i);
                if (sub == attr) {
                    return prop;
                }
                ++i;
            }
        }
        return null;
    }

    public Attribute getFindByInputAttributeByName(Operation opr, String name) {
        if (opr.getInput() == null) {
            return null;
        }
        List attrs = opr.getInput().getMessageParts();
        int i = 0;
        while (i < attrs.size()) {
            Attribute attr = (Attribute)attrs.get(i);
            if (attr.getObjectName().equals(name)) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    public Attribute getFindByInputAttributeByNameStart(Operation opr, String name) {
        if (opr.getInput() == null) {
            return null;
        }
        List attrs = opr.getInput().getMessageParts();
        int i = 0;
        while (i < attrs.size()) {
            Attribute attr = (Attribute)attrs.get(i);
            if (attr.getObjectName().startsWith(name)) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    public static boolean isSimpleAttribute(Attribute attr) {
        return attr.getTypeJavaDdic() != null;
    }

    public void setFindByOutputAttributes(Operation opr) {
        Property output = null;
        DataStructure ds = null;
        if (opr != null) {
            if (opr.getOutput() == null) {
                output = this.createProperty("Result");
                output.setMinOccurs(new Integer(0));
                output.setMaxOccurs(new Integer(-1));
                this.addOperationOutputAttribute(opr, output);
                ds = this.bomSystem.getMetamodelPackage().getDataStructure().createDataStructure();
                output.setReferencedObject(ds);
            } else {
                output = (Property)opr.getOutput().getMessageParts().get(0);
                ds = output.getReferencedObject();
            }
        } else {
            return;
        }
        List currentAttributes = this.readCurrentAttributes();
        Iterator c = currentAttributes.iterator();
        while (c.hasNext()) {
            Attribute curAttr = (Attribute)c.next();
            boolean inUse = false;
            if ("key".equalsIgnoreCase(curAttr.getObjectName()) || output.getReferencedObject().getAttributes().contains(curAttr)) continue;
            output.getReferencedObject().getAttributes().add(curAttr);
        }
    }

    public File getGeneratedImplementation() throws GeneratorException {
        CAFApplicationGenerator objGenImpl = this.bomSystem.getApplicationCodeGenerator();
        return objGenImpl.getGeneratedImplementation(this.getBaseObject());
    }

    public boolean isKeyAttribute(Attribute attr) {
        return this.businessEntityInterface.getBusinessEntity().getKeys().contains(attr);
    }

    public Property getKeyAttributeByName(String name) {
        DataObject data = this.businessEntityInterface.getBusinessEntity();
        List keys = data.getKeys();
        int i = 0;
        while (i < keys.size()) {
            Property attr = (Property)keys.get(i);
            if (name.equals(attr.getObjectName())) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    public Operation getOperationByName(String name) {
        List ops = this.businessEntityInterface.getOperations();
        int i = 0;
        while (i < ops.size()) {
            Operation op = (Operation)ops.get(i);
            if (op.getObjectName().equals(name)) {
                return op;
            }
            ++i;
        }
        return null;
    }

    public Property getOperationInputAttributeByName(Operation opr, String name) {
        if (opr.getInput() == null) {
            return null;
        }
        List attrs = opr.getInput().getMessageParts();
        int i = 0;
        while (i < attrs.size()) {
            Property attr = (Property)attrs.get(i);
            if (attr.getObjectName().equals(name)) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    public CAFOperationMapping getOperationMappingByOperation(Operation beOp) {
        Iterator i = this.businessEntityInterface.getOperationMappings().iterator();
        OperationMapping opMapping = null;
        while (i.hasNext()) {
            opMapping = (OperationMapping)i.next();
            if (opMapping.getSource().getObjectId().equals(beOp.getObjectId())) break;
            opMapping = null;
        }
        if (opMapping != null) {
            return new CAFOperationMapping(this.bomSystem, opMapping);
        }
        return null;
    }

    public void setOperationPermissions(Integer check) {
        Iterator it = this.businessEntityInterface.getOperations().iterator();
        while (it.hasNext()) {
            Operation opr = (Operation)it.next();
            Permission perm = opr.getPermission();
            perm.setImplicitCheck(check);
        }
    }

    public Integer getOperationPermissions() {
        Permission perm;
        Operation opr;
        Iterator it = this.businessEntityInterface.getOperations().iterator();
        if (it.hasNext() && (opr = (Operation)it.next()) != null && (perm = opr.getPermission()) != null) {
            return perm.getImplicitCheck();
        }
        return new Integer(0);
    }

    public Attribute getSubAttributeByName(String name, DataStructure data) {
        List attrs = data.getAttributes();
        List keys = data.getKeys();
        int i = 0;
        while (i < attrs.size()) {
            Attribute attr = (Attribute)attrs.get(i);
            if (name.equals(attr.getObjectName())) {
                return attr;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < keys.size()) {
            Attribute attr = (Attribute)keys.get(i2);
            if (name.equals(attr.getObjectName())) {
                return attr;
            }
            ++i2;
        }
        return null;
    }

    public Attribute getSubAttributeByName(Attribute attribute, String name) {
        DataObject data = (DataObject)attribute.getReferencedObject();
        if (data == null) {
            return null;
        }
        List attrs = data.getAttributes();
        List keys = data.getKeys();
        int i = 0;
        while (i < attrs.size()) {
            Attribute attr = (Attribute)attrs.get(i);
            if (name.equals(attr.getObjectName())) {
                return attr;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < keys.size()) {
            Attribute attr = (Attribute)keys.get(i2);
            if (name.equals(attr.getObjectName())) {
                return attr;
            }
            ++i2;
        }
        return null;
    }

    public String getSubProjectPrefix() {
        String strName = this.bomSystem.getApplicationName().toUpperCase();
        int nFPointPos = strName.indexOf(46);
        if (nFPointPos == -1 || nFPointPos == strName.length() - 1) {
            return strName.length() >= 3 ? strName.substring(0, 3) : strName;
        }
        return (strName = strName.substring(nFPointPos + 1)).length() >= 3 ? strName.substring(0, 3) : strName;
    }

    public String getTechnicalIdentifier(BusinessEntityInterface mofInterface, BOMSystem abomsystem) {
        return super.getTechnicalIdentifier((MOFInterface)mofInterface, abomsystem);
    }

    public String getTechnicalIdentifier() {
        return this.getTechnicalIdentifier(this.businessEntityInterface, this.bomSystem);
    }

    public Property addComplexAttribute(String name) throws CAFResourceException {
        Property attr = this.createProperty(name);
        attr.setTypeJavaDdic(null);
        attr.setMinOccurs(new Integer(0));
        DataObject ds = this.bomSystem.getMetamodelPackage().getDataObject().createDataObject();
        ds.setObjectId(ds.refMofId());
        String dsName = name.substring(0, 1).toUpperCase() + name.substring(1);
        ds.setObjectName(dsName);
        attr.setReferencedObject((DataStructure)ds);
        this.businessEntityInterface.getBusinessEntity().getAttributes().add(attr);
        this.createComlexTable(attr);
        this.updateOperations((Attribute)attr, 1);
        return attr;
    }

    public Property addEntityAttribute(BusinessEntityInterface be, String name) throws CAFResourceException {
        Property attr = this.createProperty(name);
        attr.setReferencedObject((DataStructure)be.getBusinessEntity());
        attr.setTypeJavaDdic(null);
        attr.setMinOccurs(new Integer(0));
        this.businessEntityInterface.getBusinessEntity().getAttributes().add(attr);
        this.createJoinTable(attr);
        this.updateOperations((Attribute)attr, 1);
        return attr;
    }

    public void addFieldToMasterTable(Property attr) {
        if (this.businessEntityInterface.getBackend() >= 0) {
            Table masterTable = this.businessEntityInterface.getBusinessEntity().getMasterTable();
            this.addFieldToTable(attr, masterTable);
        }
    }

    public Field addFieldToTable(Property attr, Table tabl) {
        Collection fields = attr.getField();
        Field field = this.createField(attr.getObjectName(), tabl);
        fields.add(field);
        return field;
    }

    public Attribute addFindByInputAttribute(Operation opr, String attrName) {
        Attribute attr = null;
        if (opr != null && attrName != null) {
            if (opr.getInput() == null) {
                Message msg = this.bomSystem.getMetamodelPackage().getMessage().createMessage();
                msg.setObjectId(msg.refMofId());
                opr.setInput(msg);
            }
            if (this.getFindByInputAttributeByName(opr, attrName) == null) {
                attr = this.createAttribute(attrName);
                DataStructure ds = this.bomSystem.getMetamodelPackage().getDataStructure().createDataStructure();
                DefaultValues.setDefaults(ds, DefaultValues.ENTITY_INTERFACE_OPERATION_INPUT_DATA_STRUCTURE);
                attr.setReferencedObject(ds);
                Attribute attrOperation = this.createAttribute("option");
                attrOperation.setTypeJavaDdic("com.sap.caf.base.string");
                Attribute attrMinValue = this.createAttribute("minValue");
                attrMinValue.setTypeJavaDdic("com.sap.caf.base.string");
                Attribute attrMaxValue = this.createAttribute("maxValue");
                attrMaxValue.setTypeJavaDdic("com.sap.caf.base.string");
                ds.getAttributes().add(attrOperation);
                ds.getAttributes().add(attrMinValue);
                ds.getAttributes().add(attrMaxValue);
                opr.getInput().getMessageParts().add(attr);
            }
        }
        return attr;
    }

    public Property addKeyAttribute(String name) {
        Property attr = this.createProperty(name);
        attr.setMinOccurs(new Integer(1));
        this.businessEntityInterface.getBusinessEntity().getKeys().add(attr);
        attr.setTypeJavaDdic("com.sap.caf.core.shortText");
        this.addFieldToMasterTable(attr);
        this.updateOperations((Attribute)attr, 1);
        return attr;
    }

    public Property addOperationInputAttribute(Operation opr, Property attr) {
        if (opr != null && attr != null) {
            if (opr.getInput() == null) {
                Message msg = this.bomSystem.getMetamodelPackage().getMessage().createMessage();
                msg.setObjectId(msg.refMofId());
                opr.setInput(msg);
            }
            opr.getInput().getMessageParts().add(attr);
        }
        return attr;
    }

    public Property addOperationOutputAttribute(Operation opr, Property attr) {
        if (opr != null && attr != null) {
            if (opr.getOutput() == null) {
                Message msg = this.bomSystem.getMetamodelPackage().getMessage().createMessage();
                msg.setObjectId(msg.refMofId());
                opr.setOutput(msg);
            }
            opr.getOutput().getMessageParts().add(attr);
        }
        return attr;
    }

    public Property addSimpleAttribute(String name) {
        Property attr = this.createProperty(name);
        this.businessEntityInterface.getBusinessEntity().getAttributes().add(attr);
        attr.setTypeJavaDdic("com.sap.caf.core.shortText");
        this.addFieldToMasterTable(attr);
        this.updateOperations((Attribute)attr, 1);
        return attr;
    }

    public Property addSubAttribute(Attribute attribute, String name, boolean isKey) {
        DataObject data = (DataObject)attribute.getReferencedObject();
        Property attr = this.createProperty(name);
        if (isKey) {
            data.getKeys().add(attr);
        } else {
            data.getAttributes().add(attr);
        }
        Table complexTable = ((Field)((Property)attribute).getField().iterator().next()).getTable();
        Field attrFiled = this.createField(name, complexTable);
        attr.getField().add(attrFiled);
        this.updateOperations((Attribute)attr, 1);
        return attr;
    }

    public void changeAttributeMultiplicity(Property attr, boolean isCollection) {
        if (attr == null) {
            return;
        }
        Table masterTable = this.businessEntityInterface.getBusinessEntity().getMasterTable();
        Iterator it = attr.getField().iterator();
        Field fld = null;
        if (it.hasNext()) {
            fld = (Field)it.next();
        }
        it = attr.getField().iterator();
        while (it.hasNext()) {
            Field fss = (Field)it.next();
        }
        if (isCollection) {
            attr.getField().remove(fld);
            new CAFField(this.bomSystem, fld).remove();
            Table collectionTable = null;
            try {
                collectionTable = this.createTable(this.businessEntityInterface.getBusinessEntity().getObjectName(), attr.getObjectName());
                String description = CAFBusinessEntityInterface.createTableDescription("TABLENAME_DESCRIPTION_COLLECTION_TYPE", this.businessEntityInterface.getBusinessEntity().getObjectName(), attr.getObjectName());
                collectionTable.setTableDescription(description);
            }
            catch (CAFResourceException ex) {
                ((Throwable)((Object)ex)).printStackTrace();
                return;
            }
            catch (TableNameGenerator.InvalidNameArgument ex) {
                throw new CAFRuntimeException("Business object name cannot be invalid table name.");
            }
            Field primaryKey = this.createField("OBJECTKEY", collectionTable);
            Field parentKey = this.createField("PARENTKEY", collectionTable);
            Field attrField = this.createField("" + attr.getObjectName(), collectionTable);
            attr.getField().add(attrField);
        } else {
            Field ff;
            Collection c = attr.getField();
            Iterator itr = c.iterator();
            Table collectionTable = null;
            if (itr.hasNext() && (ff = (Field)itr.next()) != null) {
                collectionTable = ff.getTable();
            }
            if (collectionTable == null) {
                return;
            }
            new CAFTable(this.bomSystem, collectionTable).remove();
            Field attrField = this.createField("" + attr.getObjectName(), masterTable);
            attr.getField().add(attrField);
        }
    }

    public void changeLanaguageDependency(CAFBusinessEntityInterface cbei, Property attr, boolean isLanguageDependent) throws CAFResourceException, CAFRuntimeException {
        if (attr == null) {
            return;
        }
        Table masterTable = this.businessEntityInterface.getBusinessEntity().getMasterTable();
        Iterator it = attr.getField().iterator();
        Field fld = null;
        if (it.hasNext()) {
            fld = (Field)it.next();
        }
        it = attr.getField().iterator();
        while (it.hasNext()) {
            Field fss = (Field)it.next();
        }
        Table languageTable = CAFBusinessEntityInterface.getLanguageTable(cbei.getBusinesEntityInterface().getBusinessEntity());
        if (isLanguageDependent) {
            attr.getField().remove(fld);
            new CAFField(this.bomSystem, fld).remove();
            if (languageTable == null) {
                try {
                    languageTable = this.createTable(this.businessEntityInterface.getBusinessEntity().getObjectName(), "_LANG");
                    String description = CAFBusinessEntityInterface.createTableDescription("TABLENAME_DESCRIPTION_LANGUAGE_VALUES", this.businessEntityInterface.getBusinessEntity().getObjectName(), "");
                    languageTable.setTableDescription(description);
                }
                catch (TableNameGenerator.InvalidNameArgument ex) {
                    throw new CAFRuntimeException("Business object name cannot be invalid table name.");
                }
                Field primaryKey = this.createField("OBJECTKEY", languageTable);
                Field parentKey = this.createField("PARENTKEY", languageTable);
                Field langKey = this.createField("LANG", languageTable);
            }
            Field attrField = this.createField("" + attr.getObjectName(), languageTable);
            attr.getField().add(attrField);
        } else {
            if (languageTable == null) {
                Field ff;
                Collection c = attr.getField();
                Iterator itr = c.iterator();
                if (itr.hasNext() && (ff = (Field)itr.next()) != null) {
                    languageTable = ff.getTable();
                }
                if (languageTable != null) {
                    new CAFTable(this.bomSystem, languageTable).remove();
                }
            } else {
                attr.getField().remove(fld);
                new CAFField(this.bomSystem, fld, null).remove();
            }
            Field attrField = this.createField("" + attr.getObjectName(), masterTable);
            attr.getField().add(attrField);
        }
    }

    public void changePersistency(int state) {
    }

    public void clearTables(String[] tables) throws CAFResourceException {
        try {
            List typeList = Utilities.getUtilities().decodeQualifiedName("com.sap.caf.metamodel.Table");
            List tabs = this.bomSystem.getConnection().queryM1(typeList, null, true);
            Iterator it = tabs.iterator();
            while (it.hasNext()) {
                Table t = (Table)it.next();
                int i = 0;
                while (i < tables.length) {
                    if (tables[i].equals(t.getTableName())) {
                        new CAFTable(this.bomSystem, t).remove();
                    }
                    ++i;
                }
            }
        }
        catch (ResourceException ex) {
            throw new CAFResourceException((Exception)((Object)ex));
        }
    }

    public Attribute createAttribute(String name) {
        Attribute attr = this.bomSystem.getMetamodelPackage().getAttribute().createAttribute();
        DefaultValues.setDefaults(attr, DefaultValues.DEFAULT_ATTRIBUTE);
        attr.setObjectName(name);
        attr.setShortText(name);
        attr.setListType(new Integer(1));
        return attr;
    }

    public Table createComlexTable(Property attr) throws CAFResourceException {
        Table complexTable = null;
        try {
            complexTable = this.createTable(this.businessEntityInterface.getBusinessEntity().getObjectName(), attr.getObjectName());
            String description = CAFBusinessEntityInterface.createTableDescription("TABLENAME_DESCRIPTION_COMPLEX_TYPE", this.businessEntityInterface.getBusinessEntity().getObjectName(), attr.getObjectName());
            complexTable.setTableDescription(description);
        }
        catch (TableNameGenerator.InvalidNameArgument ex) {
            throw new CAFRuntimeException("Business object name cannot be invalid table name.");
        }
        Table masterTable = this.businessEntityInterface.getBusinessEntity().getMasterTable();
        Field primaryKey = this.createField("OBJECTKEY", complexTable);
        Field parentKey = this.createField("PARENTKEY", complexTable);
        Property parentKeyAttr = (Property)this.getAttributeByName("key");
        Field parentKeyField = (Field)parentKeyAttr.getField().iterator().next();
        parentKey.setPkfield(parentKeyField);
        attr.getField().add(primaryKey);
        return complexTable;
    }

    public FaultMessage createFaultMessage(String name) {
        FaultMessage msg = this.bomSystem.getMetamodelPackage().getFaultMessage().createFaultMessage();
        msg.setObjectId(msg.refMofId());
        msg.setObjectName(name);
        return msg;
    }

    public Field createField(String name, Table table) {
        Field field = this.bomSystem.getMetamodelPackage().getField().createField(CAFBusinessEntityInterface.createFieldName(name, table));
        DefaultValues.setDefaults(field, null);
        table.getFields().add(field);
        return field;
    }

    public Table createJoinTable(Property attr) throws CAFResourceException {
        Table joinTable = null;
        try {
            joinTable = this.createTable(this.businessEntityInterface.getBusinessEntity().getObjectName(), attr.getReferencedObject().getObjectName());
            String description = CAFBusinessEntityInterface.createTableDescription("TABLENAME_DESCRIPTION_JOINTABLE", this.businessEntityInterface.getBusinessEntity().getObjectName(), attr.getReferencedObject().getObjectName());
            joinTable.setTableDescription(description);
        }
        catch (TableNameGenerator.InvalidNameArgument ex) {
            throw new CAFRuntimeException("Business object name cannot be invalid table name.");
        }
        Table masterTable = this.businessEntityInterface.getBusinessEntity().getMasterTable();
        Field primaryKey = this.createField("PRIMARYKEY", joinTable);
        Field parentKey = this.createField("PARENTKEY", joinTable);
        Field objectKey = this.createField("OBJECTKEY", joinTable);
        Property parentKeyAttr = (Property)this.getAttributeByName("key");
        Field parentKeyField = (Field)parentKeyAttr.getField().iterator().next();
        parentKey.setPkfield(parentKeyField);
        Property childKeyAttr = (Property)this.getSubAttributeByName((Attribute)attr, "key");
        Field childKeyField = (Field)parentKeyAttr.getField().iterator().next();
        objectKey.setPkfield(childKeyField);
        attr.getField().add(primaryKey);
        joinTable.setTargetDataObject((DataObject)attr.getReferencedObject());
        joinTable.setSourceDataObject(this.businessEntityInterface.getBusinessEntity());
        return joinTable;
    }

    public Message createMessage(String name) {
        Message msg = this.bomSystem.getMetamodelPackage().getMessage().createMessage();
        DefaultValues.setDefaults(msg, null);
        msg.setObjectId(msg.refMofId());
        msg.setObjectName(name);
        return msg;
    }

    public void createMultyParamMethods() {
        Operation findByMultipleParameters = this.createOperation();
        findByMultipleParameters.setObjectName(FIND_BY_MULTIPLE_PARAMS_METHOD);
        findByMultipleParameters.setTransactionType(this.DEFAULT_KM_TRANSACTION_TYPE);
        findByMultipleParameters.setPatternType((Integer)DefaultValues.OPERATION_FINDBY[2][2]);
        Message msgout = this.createMessage("Output");
        Attribute attr = this.createAttribute("Output");
        attr.setMinOccurs(new Integer(-1));
        attr.setTypeJavaDdic("*");
        attr.setListType(new Integer(0));
        attr.setMaxOccurs(new Integer(-1));
        msgout.getMessageParts().add(attr);
        findByMultipleParameters.setOutput(msgout);
        Message msgin = this.createMessage("Input");
        attr = this.createAttribute("mapNameToFilter");
        attr.setTypeJavaDdic("*");
        msgin.getMessageParts().add(attr);
        attr = this.createAttribute("implCheck");
        attr.setTypeJavaDdic("com.sap.caf.base.boolean");
        msgin.getMessageParts().add(attr);
        attr = this.createAttribute("findByName");
        attr.setTypeJavaDdic("com.sap.caf.core.shortText");
        msgin.getMessageParts().add(attr);
        findByMultipleParameters.setInput(msgin);
        findByMultipleParameters.getFault().add(this.createFaultMessage("BEException"));
        this.bomSystem.notifyCAFObjectChanged(findByMultipleParameters, 25);
    }

    public Operation createOperation() {
        Operation opr = this.bomSystem.getMetamodelPackage().getOperation().createOperation();
        opr.setObjectId(opr.refMofId());
        this.businessEntityInterface.getOperations().add(opr);
        Permission perm = this.bomSystem.getMetamodelPackage().getPermission().createPermission();
        perm.setPermissionName("OperationPermission");
        Integer currentPerm = this.getOperationPermissions();
        currentPerm = currentPerm == 1 ? new Integer(1) : new Integer(0);
        perm.setImplicitCheck(currentPerm);
        opr.setPermission(perm);
        return opr;
    }

    public Property createProperty(String name) {
        Property attr = this.bomSystem.getMetamodelPackage().getProperty().createProperty();
        DefaultValues.setDefaults(attr, DefaultValues.BUSINESS_ENTITY_PROPERTY);
        attr.setObjectName(name);
        attr.setShortText(name);
        attr.setListType(new Integer(1));
        return attr;
    }

    public Table createTable(String masterObjectName, String detailObjectName) throws CAFResourceException, TableNameGenerator.InvalidNameArgument {
        Table tab = this.bomSystem.getMetamodelPackage().getTable().createTable(this.createTableName(masterObjectName, detailObjectName), "");
        return tab;
    }

    public String createTableName(String masterObjectName, String detailObjectName) throws CAFResourceException, TableNameGenerator.InvalidNameArgument {
        return this.createTableName(masterObjectName, detailObjectName, null);
    }

    public String createTableName(String masterObjectName, String detailObjectName, boolean[] bNameIterated) throws CAFResourceException, TableNameGenerator.InvalidNameArgument {
        CAFBusinessEntityInterface.registerGeneratedTableNames(this.bomSystem);
        TableNameGenerator tableIterator = new TableNameGenerator(CAFBusinessEntityInterface.getNamePrefix(), this.getSubProjectPrefix(), masterObjectName, detailObjectName);
        boolean isProjectLocal = this.isLocalDevelopment();
        NameServiceNameValidator nsTableVal = null;
        try {
            if (!isProjectLocal) {
                nsTableVal = new NameServiceNameValidator(this.bomSystem);
            }
        }
        catch (CommunicationFailureException ex) {
            logger.errorT("NameServer Check Failed.", ex.getMessage());
            ex.printStackTrace();
        }
        boolean bExists = true;
        String tableName = null;
        if (bNameIterated != null && bNameIterated.length > 0) {
            bNameIterated[0] = false;
        }
        do {
            boolean bLocalName;
            if (!(bLocalName = m_hashTblNames.contains(tableName = tableIterator.getNextValue()))) {
                boolean bRemoveName = false;
                if (nsTableVal != null) {
                    try {
                        bRemoveName = nsTableVal.isDBTableNameRegistered(tableName);
                    }
                    catch (CommunicationFailureException ex) {
                        logger.errorT("NameServer Check Failed.", ex.getMessage());
                        ex.printStackTrace();
                    }
                }
                bExists = bRemoveName;
            }
            if (!bExists || bNameIterated == null || bNameIterated.length <= 0 || bNameIterated[0]) continue;
            bNameIterated[0] = true;
        } while (bExists);
        CAFBusinessEntityInterface.registerTableName(tableName);
        return tableName;
    }

    public void deleteAttribute(Attribute attr) {
        if (this.getComplexParent(attr) != null) {
            this.updateOperations(attr, 2);
        }
        if (attr instanceof Property) {
            new CAFProperty(this.bomSystem, (Property)attr).remove();
        } else {
            new CAFAttribute(this.bomSystem, attr).remove();
        }
        if (this.getComplexParent(attr) == null) {
            this.updateOperations(attr, 2);
        }
    }

    public void deleteOperation(Operation opr) {
        new CAFOperation(this.bomSystem, opr).remove();
    }

    public void eraseGeneratedCode(IResourceChangeListener changeListener) throws GeneratorException {
        CAFApplicationGenerator objGenImpl = this.bomSystem.getApplicationCodeGenerator();
        objGenImpl.eraseGeneratedCode(this.getBaseObject(), changeListener);
    }

    public void generateObject(GenerationMonitor monitor, IResourceChangeListener changeListener) throws GeneratorException, GeneratorNotificationException {
        CAFApplicationGenerator objGenImpl = this.bomSystem.getApplicationCodeGenerator();
        objGenImpl.generateObject(this.getBaseObject(), monitor, changeListener);
    }

    public boolean hasFyndByOperation() {
        Iterator ioperations = this.getBusinesEntityInterface().getOperations().iterator();
        while (ioperations.hasNext()) {
            Operation operation = (Operation)ioperations.next();
            if (!DefaultValues.OPERATION_FINDBY[2][2].equals(operation.getPatternType()) || this.isOperationReserved(operation)) continue;
            return true;
        }
        return false;
    }

    public void manageClasifiableMethods() {
        if (this.businessEntityInterface.isClassifiable().booleanValue()) {
            Operation getCategories = this.createOperation();
            DefaultValues.setDefaults(getCategories, DefaultValues.OPERATION_CLASSIFIABLE_AND_RETRIEVAL);
            getCategories.setObjectName("getCategories");
            Message msg = this.createMessage("Output");
            Attribute attr = this.createAttribute("Output");
            attr.setMinOccurs(new Integer(-1));
            attr.setTypeJavaDdic("*");
            msg.getMessageParts().add(attr);
            getCategories.setOutput(msg);
            getCategories.getFault().add(this.createFaultMessage("BEException"));
            Operation getClassification = this.createOperation();
            DefaultValues.setDefaults(getClassification, DefaultValues.OPERATION_CLASSIFIABLE_AND_RETRIEVAL);
            getClassification.setObjectName("getClassification");
            msg = this.createMessage("Output");
            attr = this.createAttribute("Output");
            attr.setMinOccurs(new Integer(-1));
            attr.setTypeJavaDdic("*");
            msg.getMessageParts().add(attr);
            getClassification.setOutput(msg);
            msg = this.createMessage("Input");
            attr = this.createAttribute("beKey");
            attr.setTypeJavaDdic("com.sap.caf.core.id");
            msg.getMessageParts().add(attr);
            attr = this.createAttribute("categoryGUID");
            attr.setTypeJavaDdic("com.sap.caf.core.id");
            msg.getMessageParts().add(attr);
            getClassification.setInput(msg);
            getClassification.getFault().add(this.createFaultMessage("BEException"));
            Operation addClassification = this.createOperation();
            DefaultValues.setDefaults(addClassification, DefaultValues.OPERATION_CLASSIFIABLE_AND_RETRIEVAL);
            addClassification.setObjectName("addClassification");
            msg = this.createMessage("Input");
            attr = this.createAttribute("beKey");
            attr.setTypeJavaDdic("com.sap.caf.core.id");
            msg.getMessageParts().add(attr);
            attr = this.createAttribute("valueGUID");
            attr.setTypeJavaDdic("com.sap.caf.core.id");
            msg.getMessageParts().add(attr);
            attr = this.createAttribute("categoryGUID");
            attr.setTypeJavaDdic("com.sap.caf.core.id");
            msg.getMessageParts().add(attr);
            addClassification.setInput(msg);
            addClassification.getFault().add(this.createFaultMessage("BEException"));
            Operation removeClassification = this.createOperation();
            DefaultValues.setDefaults(removeClassification, DefaultValues.OPERATION_CLASSIFIABLE_AND_RETRIEVAL);
            removeClassification.setObjectName("removeClassification");
            msg = this.createMessage("Input");
            attr = this.createAttribute("beKey");
            attr.setTypeJavaDdic("com.sap.caf.core.id");
            msg.getMessageParts().add(attr);
            attr = this.createAttribute("valueGUID");
            attr.setTypeJavaDdic("com.sap.caf.core.id");
            msg.getMessageParts().add(attr);
            attr = this.createAttribute("categoryGUID");
            attr.setTypeJavaDdic("com.sap.caf.core.id");
            msg.getMessageParts().add(attr);
            removeClassification.setInput(msg);
            removeClassification.getFault().add(this.createFaultMessage("BEException"));
            this.bomSystem.notifyCAFObjectChanged(removeClassification, 25);
        } else {
            Operation getCategories = this.getOperationByName("getCategories");
            this.removeBEOperation(getCategories);
            Operation getClassification = this.getOperationByName("getClassification");
            this.removeBEOperation(getClassification);
            Operation addClassification = this.getOperationByName("addClassification");
            this.removeBEOperation(addClassification);
            Operation removeClassification = this.getOperationByName("removeClassification");
            this.removeBEOperation(removeClassification);
            this.bomSystem.notifyCAFObjectChanged(removeClassification, 29);
        }
    }

    public void manageRetrievalMethods() {
        if (this.businessEntityInterface.isSearchAndRetrieval().booleanValue()) {
            Operation findByKMPropertySearch = this.createOperation();
            DefaultValues.setDefaults(findByKMPropertySearch, DefaultValues.OPERATION_CLASSIFIABLE_AND_RETRIEVAL);
            findByKMPropertySearch.setObjectName("findByKMPropertySearch");
            Message msg = this.createMessage("Input");
            Attribute attr = this.createAttribute("Input");
            attr.setMinOccurs(new Integer(-1));
            attr.setTypeJavaDdic("*");
            msg.getMessageParts().add(attr);
            findByKMPropertySearch.setInput(msg);
            msg = this.createMessage("Output");
            attr = this.createAttribute("Output");
            attr.setMinOccurs(new Integer(-1));
            attr.setTypeJavaDdic("*");
            msg.getMessageParts().add(attr);
            findByKMPropertySearch.setOutput(msg);
            findByKMPropertySearch.getFault().add(this.createFaultMessage("FinderException"));
            findByKMPropertySearch.getFault().add(this.createFaultMessage("CAFFindException"));
            Operation searchidxForSimilar = this.createOperation();
            DefaultValues.setDefaults(searchidxForSimilar, DefaultValues.OPERATION_CLASSIFIABLE_AND_RETRIEVAL);
            searchidxForSimilar.setObjectName("searchidxForSimilar");
            msg = this.createMessage("Input");
            attr = this.createAttribute("thisCourse");
            attr.setTypeJavaDdic("IBusinessObject");
            msg.getMessageParts().add(attr);
            attr = this.createAttribute("maxResults");
            attr.setTypeJavaDdic("com.sap.caf.core.userId");
            msg.getMessageParts().add(attr);
            searchidxForSimilar.setInput(msg);
            msg = this.createMessage("Output");
            attr = this.createAttribute("Output");
            attr.setMinOccurs(new Integer(-1));
            attr.setTypeJavaDdic("*");
            msg.getMessageParts().add(attr);
            searchidxForSimilar.setOutput(msg);
            searchidxForSimilar.getFault().add(this.createFaultMessage("BEException"));
            this.bomSystem.notifyCAFObjectChanged(findByKMPropertySearch, 25);
        } else {
            Operation findByKMPropertySearch = this.getOperationByName("findByKMPropertySearch");
            this.removeBEOperation(findByKMPropertySearch);
            Operation searchidxForSimilar = this.getOperationByName("searchidxForSimilar");
            this.removeBEOperation(searchidxForSimilar);
            this.bomSystem.notifyCAFObjectChanged(searchidxForSimilar, 29);
        }
    }

    public void printAlltables() {
        try {
            List typeList = Utilities.getUtilities().decodeQualifiedName("com.sap.caf.metamodel.Table");
            List tabs = this.bomSystem.getConnection().queryM1(typeList, null, true);
            Iterator it = tabs.iterator();
            while (it.hasNext()) {
                Table t = (Table)it.next();
                Iterator it1 = t.getFields().iterator();
                while (it1.hasNext()) {
                    Field f = (Field)it1.next();
                    if (f == null) continue;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List readCurrentAttributes() {
        DataObject data = this.businessEntityInterface.getBusinessEntity();
        return this.readCurrentSubAttributes((DataStructure)data);
    }

    public List readCurrentSubAttributes(DataStructure data) {
        ArrayList attributes = new ArrayList();
        if (data == null) {
            return null;
        }
        if (data.getKeys() != null) {
            attributes.addAll(data.getKeys());
        }
        if (data.getAttributes() != null) {
            attributes.addAll(data.getAttributes());
        }
        return attributes;
    }

    public List getReferenceAttributes() {
        List attrs = this.readCurrentAttributes();
        ArrayList<Attribute> refs = new ArrayList<Attribute>();
        Iterator it = attrs.iterator();
        while (it.hasNext()) {
            Attribute atr = (Attribute)it.next();
            if (!CAFBusinessEntityInterface.isEntityAttribute(atr)) continue;
            refs.add(atr);
        }
        return refs;
    }

    public void removeBEOperation(Operation opr) {
        try {
            Attribute attr;
            List ls;
            int i;
            if (opr == null) {
                return;
            }
            if (opr.getFault() != null) {
                Object[] cl = opr.getFault().toArray();
                i = 0;
                while (i < cl.length) {
                    FaultMessage fm = (FaultMessage)cl[i];
                    fm.refDelete();
                    ++i;
                }
                opr.getFault().clear();
            }
            if (opr.getInput() != null) {
                ls = opr.getInput().getMessageParts();
                if (ls != null) {
                    i = 0;
                    while (i < ls.size()) {
                        attr = (Attribute)ls.get(i);
                        attr.refDelete();
                        ++i;
                    }
                }
                opr.getInput().refDelete();
            }
            if (opr.getOutput() != null) {
                ls = opr.getOutput().getMessageParts();
                if (ls != null) {
                    i = 0;
                    while (i < ls.size()) {
                        attr = (Attribute)ls.get(i);
                        attr.refDelete();
                        ++i;
                    }
                }
                opr.getOutput().refDelete();
            }
            opr.refDelete();
            this.businessEntityInterface.getOperations().remove(opr);
        }
        catch (Exception exc) {
            logger.errorT("An error has occured while removing Entity operation object.Error is:" + exc.getMessage());
            exc.printStackTrace();
        }
    }

    public Field removeFieldFromTable(Property attr, Table tabl) {
        Collection fields = attr.getField();
        Field field = (Field)fields.iterator().next();
        tabl.getFields().remove(field);
        return field;
    }

    public void removeNulls() {
        CAFWrapperBase.removeNulls(this.businessEntityInterface.getOperationMappings().iterator());
        Iterator i = new LinkedList(this.businessEntityInterface.getOperationMappings()).iterator();
        while (i.hasNext()) {
            CAFOperationMapping opMapping = new CAFOperationMapping(this.bomSystem, (OperationMapping)i.next(), this.context);
            opMapping.removeNulls();
        }
        CAFDataObject dataObj = new CAFDataObject(this.bomSystem, this.businessEntityInterface.getBusinessEntity(), this.context);
        dataObj.removeNulls();
        super.removeNulls();
    }

    public void removeUnusedFinByAttributes(Operation opr, List selectedAttributes) {
        List currentAttributes = null;
        if (opr != null) {
            if (opr.getInput() == null) {
                return;
            }
            currentAttributes = opr.getInput().getMessageParts();
        }
        Iterator c = new LinkedList(currentAttributes).iterator();
        while (c.hasNext()) {
            Attribute curAttr = (Attribute)c.next();
            boolean inUse = false;
            Iterator i = new LinkedList(selectedAttributes).iterator();
            while (i.hasNext()) {
                if (!curAttr.getObjectName().equals((String)i.next())) continue;
                inUse = true;
                break;
            }
            if (inUse) continue;
            new CAFAttribute(this.bomSystem, curAttr).remove();
        }
    }

    public String toString() {
        return "wrapped: " + this.businessEntityInterface;
    }

    public void updateFindByAttributeNames(Attribute attr, String newName) {
        List ops1 = this.businessEntityInterface.getOperations();
        int i = 0;
        while (i < ops1.size()) {
            Operation op = (Operation)ops1.get(i);
            Attribute parent = this.getComplexParent(attr);
            if (op.getPatternType() != null && op.getPatternType() == 5) {
                Attribute attrF;
                if (parent != null) {
                    attrF = this.getFindByInputAttributeByName(op, parent.getObjectName() + "." + attr.getObjectName());
                    if (attrF != null) {
                        attrF.setObjectName(parent.getObjectName() + "." + newName);
                    }
                } else {
                    attrF = this.getFindByInputAttributeByName(op, attr.getObjectName());
                    if (attrF != null) {
                        attrF.setObjectName(newName);
                    }
                    if ((attrF = this.getFindByInputAttributeByNameStart(op, attr.getObjectName() + ".")) != null) {
                        String attrName = attrF.getObjectName();
                        attrF.setObjectName(newName + attrName.substring(attr.getObjectName().length()));
                    }
                }
            }
            ++i;
        }
    }

    public void updateOperations(Attribute attr, int Action2) {
        Operation createOp = this.getOperationByName("create");
        Operation readOp = this.getOperationByName("read");
        Operation updateOp = this.getOperationByName("update");
        Operation deleteOp = this.getOperationByName("delete");
        if (createOp == null || readOp == null || updateOp == null || deleteOp == null) {
            return;
        }
        switch (Action2) {
            case 1: {
                if (this.getComplexParent(attr) != null) {
                    this.bomSystem.notifyCAFObjectChanged(attr, 35);
                    break;
                }
                if (attr.getMinOccurs() > 0 && !createOp.getInput().getMessageParts().contains(attr)) {
                    createOp.getInput().getMessageParts().add(attr);
                }
                if (this.isKeyAttribute(attr)) {
                    this.addOperationInputAttribute(readOp, (Property)attr);
                    if (!CAFBusinessEntityInterface.isDefaultAttribute(attr)) {
                        this.addOperationOutputAttribute(createOp, (Property)attr);
                    }
                    this.addOperationInputAttribute(deleteOp, (Property)attr);
                }
                if (!this.isKeyAttribute(attr) && !CAFBusinessEntityInterface.isDefaultAttribute(attr)) {
                    this.addOperationOutputAttribute(readOp, (Property)attr);
                    List ops = this.businessEntityInterface.getOperations();
                    int i = 0;
                    while (i < ops.size()) {
                        Attribute res;
                        Operation op = (Operation)ops.get(i);
                        if (op.getPatternType() == 5 && (res = (Attribute)op.getOutput().getMessageParts().get(0)).getReferencedObject() != null) {
                            res.getReferencedObject().getAttributes().add(attr);
                        }
                        ++i;
                    }
                }
                if (!updateOp.getInput().getMessageParts().contains(attr)) {
                    updateOp.getInput().getMessageParts().add(attr);
                }
                this.bomSystem.notifyCAFObjectChanged(attr, 35);
                break;
            }
            case 2: {
                List ops = this.businessEntityInterface.getOperations();
                int i = 0;
                while (i < ops.size()) {
                    Operation op = (Operation)ops.get(i);
                    Attribute parent = this.getComplexParent(attr);
                    if (op.getPatternType() != null && op.getPatternType() == 5) {
                        Attribute attrF;
                        if (parent != null) {
                            attrF = this.getFindByInputAttributeByName(op, parent.getObjectName() + "." + attr.getObjectName());
                            if (attrF != null) {
                                new CAFAttribute(this.bomSystem, attrF).remove();
                            }
                        } else {
                            attrF = this.getFindByInputAttributeByName(op, attr.getObjectName());
                            if (attrF != null) {
                                new CAFAttribute(this.bomSystem, attrF).remove();
                            }
                        }
                    }
                    ++i;
                }
                this.bomSystem.notifyCAFObjectChanged(attr, 39);
                break;
            }
            case 3: {
                if (attr.getMinOccurs() > 0) {
                    if (!createOp.getInput().getMessageParts().contains(attr)) {
                        createOp.getInput().getMessageParts().add(attr);
                    }
                } else if (createOp.getInput().getMessageParts().contains(attr)) {
                    createOp.getInput().getMessageParts().remove(attr);
                }
                this.bomSystem.notifyCAFObjectChanged(attr, 37);
            }
        }
    }

    public boolean validate() {
        IMarkerResolution[] resolutions;
        boolean result = true;
        if (!super.validate()) {
            result = false;
        }
        if (!this.validateList(this.businessEntityInterface, this.businessEntityInterface.getOperationMappings(), "operation mappings")) {
            result = false;
        }
        if (!this.validateList(this.businessEntityInterface, this.businessEntityInterface.getBusinessEntity().getAttributes(), "attribute")) {
            result = false;
        }
        if (this.businessEntityInterface.getOperations().size() == 4 && this.businessEntityInterface.getBusinessEntity().getAttributes().size() == 4 && this.businessEntityInterface.getClientDependency().size() == 0) {
            resolutions = new IMarkerResolution[]{new AMarkerResolution("Remove the service", this.businessEntityInterface, this.bomSystem){

                public void run(IMarker marker) {
                    BOMActivity.showMessage("Resolution", "Service removed");
                }
            }};
            this.bomSystem.getStatus().addWarningMessage("ES (" + this.businessEntityInterface.getObjectName() + ") has no usefull features defined.", resolutions);
        }
        if (this.businessEntityInterface.getOperations().size() < 4 || this.businessEntityInterface.getBusinessEntity().getAttributes().size() < 4) {
            resolutions = new IMarkerResolution[]{new AMarkerResolution("Remove the service", this.businessEntityInterface, this.bomSystem){

                public void run(IMarker marker) {
                    BOMActivity.showMessage("Resolution", "Service removed");
                }
            }};
            this.bomSystem.getStatus().addErrorMessage(this.businessEntityInterface.getObjectName() + " is invalid ES. There are no CRUD operations", resolutions);
            result = false;
        }
        Iterator it = this.businessEntityInterface.getOperations().iterator();
        ArrayList attribs = new ArrayList(this.businessEntityInterface.getBusinessEntity().getAttributes());
        attribs.addAll(this.businessEntityInterface.getBusinessEntity().getKeys());
        while (it.hasNext()) {
            Operation op = (Operation)it.next();
            if (op.getPatternType() != 5) continue;
            Message msg = op.getOutput();
            if (msg == null) {
                this.bomSystem.getStatus().addErrorMessage("Operation " + op.getObjectName() + " contains null output message in BE " + this.businessEntityInterface.getObjectName(), null);
                result = false;
                continue;
            }
            Iterator itMsg = msg.getMessageParts().iterator();
            while (itMsg.hasNext()) {
                Attribute attr = (Attribute)itMsg.next();
                if (!attribs.contains(attr)) continue;
                this.bomSystem.getStatus().addErrorMessage("Operation " + op.getObjectName() + " contains output message that participates in BE " + this.businessEntityInterface.getObjectName(), null);
                result = false;
            }
        }
        if (this.businessEntityInterface.getBusinessEntity() == null) {
            this.bomSystem.getStatus().addWarningMessage("ES (" + this.businessEntityInterface.getObjectName() + ") contains no DATA OBJECT defined.", null);
            result = false;
        } else if (!BOMActivity.getWrapper(this.bomSystem, this.businessEntityInterface.getBusinessEntity()).validate()) {
            result = false;
        }
        return result;
    }

    protected void removeInternal(CAFWrapperBase topMostRemovedObj) {
        CAFWrapperBase.removeInternal(topMostRemovedObj, this.businessEntityInterface.getOperationMappings());
        Iterator i = this.businessEntityInterface.getOperationMappings().iterator();
        while (i.hasNext()) {
            new CAFOperationMapping(this.bomSystem, (OperationMapping)i.next(), this.context).removeInternal(topMostRemovedObj);
        }
        new CAFDataObject(this.bomSystem, this.businessEntityInterface.getBusinessEntity(), this.context).removeInternal(topMostRemovedObj);
        super.removeInternal(topMostRemovedObj);
        try {
            this.eraseGeneratedCode(this.bomSystem.getResourceChangeListener());
        }
        catch (GeneratorException ex) {
            logger.catching((Throwable)((Object)ex));
            ex.printStackTrace();
        }
    }

    private static String getUniqueFieldName(String oldName, Map names) {
        oldName = oldName.toUpperCase();
        StringBuffer newName = new StringBuffer(18);
        if (oldName.length() > newName.capacity()) {
            newName.append(oldName.substring(0, newName.capacity()));
        } else {
            newName.append(oldName);
        }
        int i = 0;
        while (names.get(newName.toString()) != null) {
            newName.delete(newName.length() - ("" + i).length(), newName.length());
            newName.append("" + i);
            ++i;
        }
        names.put(newName.toString(), newName.toString());
        return newName.toString();
    }

    private static String createTableDescription(String patternTextPoolID, String master, String detail) {
        return mTextPool.getText(patternTextPoolID, new String[]{master, detail});
    }

    private boolean isLocalDevelopment() {
        IProject prj;
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        if (myWorkspaceRoot != null && (prj = myWorkspaceRoot.getProject(this.bomSystem.getRelatedProjectNameByType("MMR"))) != null) {
            return DtrService.isLocalConfiguration(prj);
        }
        return true;
    }

    private static String getName(String oldName, Map names) {
        int capacity = 18;
        oldName = oldName.toUpperCase();
        StringBuffer newName = new StringBuffer(capacity);
        if (oldName.length() > capacity) {
            newName.append(oldName.substring(0, capacity));
        } else {
            newName.append(oldName);
        }
        if ("KEY".equalsIgnoreCase(newName.toString())) {
            return "OBJECTKEY";
        }
        if (OpenSQLReservedWords.isWordReserved(newName.toString())) {
            names.put(newName.toString(), newName.toString());
        }
        int i = 0;
        while (names.get(newName.toString()) != null) {
            if (newName.length() > capacity - ("" + i).length()) {
                newName.delete(newName.length() - ("" + i).length(), newName.length());
            } else if (i > 0) {
                newName = new StringBuffer(oldName);
            }
            newName.append("" + i);
            ++i;
        }
        names.put(newName.toString(), newName.toString());
        return newName.toString();
    }

    private boolean isOperationReserved(Operation operation) {
        if (operation == null) {
            return false;
        }
        boolean isReserved = false;
        int i = 0;
        while (i < RESERVEDOperations.length) {
            if (operation.getObjectName().equals(RESERVEDOperations[i])) {
                isReserved = true;
            }
            ++i;
        }
        return isReserved;
    }

    public static String getReferersNames(Map map) {
        String msg = "";
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            Attribute attr = (Attribute)me.getKey();
            Operation opr = (Operation)me.getValue();
            msg = msg + (msg.equals("") ? "" : ";\n") + opr.getMOFInterface().getObjectName() + "." + opr.getObjectName() + "(" + attr.getObjectName() + ")";
        }
        return msg;
    }

    public static Map getAssociatedOperations(Attribute attr, Attribute parent, CAFBusinessEntityInterface cbei) {
        List entityOperations = cbei.getBusinesEntityInterface().getOperations();
        HashMap<Attribute, Operation> result = new HashMap<Attribute, Operation>();
        HashMap eis = cbei.getBomSystem().getBusinessEntityInterfaces();
        BusinessEntityInterface bei = cbei.getBusinesEntityInterface();
        Iterator itEI = eis.entrySet().iterator();
        while (itEI.hasNext()) {
            Map.Entry e = itEI.next();
            CAFBusinessEntityInterface wrapper = (CAFBusinessEntityInterface)e.getValue();
            BusinessEntityInterface ei = wrapper.getBusinesEntityInterface();
            List references = wrapper.getReferenceAttributes();
            List operations = ei.getOperations();
            int i = 0;
            while (i < operations.size()) {
                Message input;
                Operation currentOperation = (Operation)operations.get(i);
                if (!(currentOperation.getObjectName().equals("update") || currentOperation.getObjectName().equals("read") || currentOperation.getObjectName().equals("delete") || currentOperation.getObjectName().equals("create") || (input = currentOperation.getInput()) == null || input.getMessageParts() == null)) {
                    Iterator mpIterator = input.getMessageParts().iterator();
                    while (mpIterator.hasNext()) {
                        Attribute inputAttr = (Attribute)mpIterator.next();
                        if (wrapper == cbei) {
                            if (!(parent == null && inputAttr.getObjectName().equals(attr.getObjectName()) || parent != null && inputAttr.getObjectName().equals(parent.getObjectName() + "." + attr.getObjectName())) && (parent != null || !inputAttr.getObjectName().startsWith(attr.getObjectName() + "."))) continue;
                            result.put(inputAttr, currentOperation);
                            continue;
                        }
                        int j = 0;
                        while (j < references.size()) {
                            Attribute ref = (Attribute)references.get(j);
                            if (ref.getReferencedObject() == bei.getBusinessEntity() && (parent == null && inputAttr.getObjectName().equals(ref.getObjectName() + "." + attr.getObjectName()) || parent != null && inputAttr.getObjectName().equals(ref.getObjectName() + "." + parent.getObjectName() + "." + attr.getObjectName()) || parent == null && inputAttr.getObjectName().startsWith(ref.getObjectName() + "." + attr.getObjectName() + "."))) {
                                result.put(inputAttr, currentOperation);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        }
        return result;
    }

    public static void renameAffectedAttributes(Attribute attr, Attribute parent, CAFBusinessEntityInterface cbei, String newName) {
        Map affected = CAFBusinessEntityInterface.getAssociatedOperations(attr, parent, cbei);
        BusinessEntityInterface bei = cbei.getBusinesEntityInterface();
        boolean isComplex = CAFBusinessEntityInterface.isComplexAttribute(attr);
        Iterator it = affected.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            Attribute affectedAttr = (Attribute)me.getKey();
            String attrNewName = "";
            String affectedName = affectedAttr.getObjectName();
            Operation opr = (Operation)me.getValue();
            CAFBusinessEntityInterface cbei1 = (CAFBusinessEntityInterface)cbei.getBomSystem().getBusinessEntityInterfaces().get(((BusinessEntityInterface)opr.getMOFInterface()).getBusinessEntity().getObjectName());
            if (cbei == cbei1) continue;
            Iterator refAttrIter = cbei1.getReferenceAttributes().iterator();
            while (refAttrIter.hasNext()) {
                Attribute ref = (Attribute)refAttrIter.next();
                if (ref.getReferencedObject() != bei.getBusinessEntity()) continue;
                if (isComplex) {
                    if (!affectedName.startsWith(ref.getObjectName() + "." + attr.getObjectName() + ".")) continue;
                    int dot1 = affectedName.indexOf(".");
                    int dot2 = affectedName.indexOf(".", dot1 + 1);
                    attrNewName = affectedName.substring(0, dot1 + 1) + newName + affectedName.substring(dot2);
                    break;
                }
                if (parent != null) {
                    if (!affectedName.startsWith(ref.getObjectName() + "." + parent.getObjectName() + "." + attr.getObjectName())) continue;
                    attrNewName = affectedName.substring(0, affectedName.lastIndexOf(".")) + "." + newName;
                    break;
                }
                if (!affectedName.startsWith(ref.getObjectName() + "." + attr.getObjectName())) continue;
                attrNewName = affectedName.substring(0, affectedName.lastIndexOf(".")) + "." + newName;
                break;
            }
            affectedAttr.setObjectName(attrNewName);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

