/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBaseObject;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFConstraint;
import com.sap.caf.designer.structure.CAFDataObject;
import com.sap.caf.designer.structure.CAFDataStructure;
import com.sap.caf.designer.structure.CAFMappingRule;
import com.sap.caf.designer.structure.CAFMessageAttribute;
import com.sap.caf.designer.structure.CAFWrapperBase;
import com.sap.caf.designer.validation.IValidatable;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.AttributeObjectAssociation;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.MappingRule;
import com.sap.caf.metamodel.MessageMapping;
import com.sap.caf.metamodel.MetamodelPackage;
import com.sap.caf.metamodel.ObjectAttributeAssociation;
import com.sap.caf.metamodel.OperationMapping;
import java.util.Iterator;
import java.util.Map;

public class CAFAttribute
extends CAFBaseObject
implements IValidatable {
    public Attribute attribute;

    public CAFAttribute(BOMSystem bomSystem, Attribute attribute, Map context) {
        super(bomSystem, (BaseObject)attribute, context);
        this.attribute = attribute;
    }

    public CAFAttribute(BOMSystem bomSystem, Attribute attribute) {
        this(bomSystem, attribute, null);
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public BusinessEntityInterface getBusinessEntityInterface() {
        MetamodelPackage metamodelPackage = this.bomSystem.getMetamodelPackage();
        ObjectAttributeAssociation objectAttributeAssociation = metamodelPackage.getObjectAttributeAssociation();
        DataStructure owningDataStructure = objectAttributeAssociation.getObject(this.attribute);
        if (owningDataStructure != null) {
            BusinessEntityInterface retVal;
            if (owningDataStructure instanceof DataObject && (retVal = ((DataObject)owningDataStructure).getBusinessEntityInterface()) != null) {
                return retVal;
            }
            AttributeObjectAssociation attributeObjectAssociation = metamodelPackage.getAttributeObjectAssociation();
            Iterator owningAttrIterator = attributeObjectAssociation.getObject(owningDataStructure).iterator();
            if (owningAttrIterator.hasNext()) {
                return new CAFAttribute(this.bomSystem, (Attribute)owningAttrIterator.next(), this.context).getBusinessEntityInterface();
            }
        }
        return null;
    }

    public void removeNulls() {
        CAFWrapperBase.removeNulls(this.attribute.getMessages().iterator());
        DataStructure ownedDataStructure = this.attribute.getReferencedObject();
        if (!CAFBusinessEntityInterface.isEntityAttribute(this.attribute) && ownedDataStructure != null) {
            if (ownedDataStructure instanceof DataObject) {
                new CAFDataObject(this.bomSystem, (DataObject)ownedDataStructure, this.context).removeNulls();
            } else {
                new CAFDataStructure(this.bomSystem, ownedDataStructure, this.context).removeNulls();
            }
        }
        if (this.attribute.getAttributeConstraint() != null) {
            new CAFConstraint(this.bomSystem, this.attribute.getAttributeConstraint(), this.context).removeNulls();
        }
        super.removeNulls();
    }

    public String toString() {
        return "wrapped: " + this.attribute;
    }

    public boolean validate() {
        boolean result = super.validate();
        if (this.attribute.getReferencedObject() == null && this.attribute.getTypeJavaDdic() == null || this.attribute.getReferencedObject() != null && this.attribute.getTypeJavaDdic() != null) {
            this.bomSystem.getStatus().addErrorMessage("Attribute (" + this.attribute.getObjectName() + ") is invalid. Only one of ReferencedObject and TypeJavaDdic must be not null.");
            result = false;
        }
        if (this.attribute.getMaxOccurs() == null || this.attribute.getMaxOccurs() < -1 || this.attribute.getMaxOccurs() > 1) {
            this.bomSystem.getStatus().addErrorMessage("The ATTRIBUTE '" + this.attribute.getObjectName() + "' has invalid MAX OCCURS value. Must be -1, 0 or 1.");
            result = false;
        }
        return result;
    }

    protected void removeInternal(CAFWrapperBase topMostRemovedObj) {
        DataStructure ownedDataStructure = this.attribute.getReferencedObject();
        if (ownedDataStructure != null && !CAFBusinessEntityInterface.isEntityAttribute(this.attribute)) {
            if (ownedDataStructure instanceof DataObject) {
                new CAFDataObject(this.bomSystem, (DataObject)ownedDataStructure, this.context).removeInternal(topMostRemovedObj);
            } else {
                new CAFDataStructure(this.bomSystem, ownedDataStructure, this.context).removeInternal(topMostRemovedObj);
            }
        }
        if (this.attribute.getAttributeConstraint() != null) {
            new CAFConstraint(this.bomSystem, this.attribute.getAttributeConstraint(), this.context).removeInternal(topMostRemovedObj);
        }
        this.removeAffectedMappingRules(topMostRemovedObj);
        super.removeInternal(topMostRemovedObj);
    }

    private void removeAffectedMappingRules(MessageMapping msgMapping, CAFWrapperBase topMostRemovedObj) {
        Iterator i = msgMapping.getMappingRules().iterator();
        while (i.hasNext()) {
            CAFMappingRule mappingRule = new CAFMappingRule(this.bomSystem, (MappingRule)i.next(), this.context);
            CAFMessageAttribute attr = mappingRule.getSourceAttribute();
            if (attr != null && attr.getLastAttribute().getObjectId().equals(this.attribute.getObjectId())) {
                mappingRule.removeInternal(topMostRemovedObj);
                continue;
            }
            attr = mappingRule.getTargetAttribute();
            if (attr == null || !attr.getLastAttribute().getObjectId().equals(this.attribute.getObjectId())) continue;
            mappingRule.removeInternal(topMostRemovedObj);
        }
    }

    private void removeAffectedMappingRules(OperationMapping opMapping, CAFWrapperBase topMostRemovedObj) {
        if (opMapping.getInput() != null) {
            this.removeAffectedMappingRules(opMapping.getInput(), topMostRemovedObj);
        }
        if (opMapping.getOutput() != null) {
            this.removeAffectedMappingRules(opMapping.getOutput(), topMostRemovedObj);
        }
    }

    private void removeAffectedMappingRules(CAFWrapperBase topMostRemovedObj) {
        Iterator beIterator = this.bomSystem.getBusinessEntityInterfaces().values().iterator();
        while (beIterator.hasNext()) {
            CAFBusinessEntityInterface be = (CAFBusinessEntityInterface)beIterator.next();
            Iterator opMappingIterator = be.getBusinesEntityInterface().getOperationMappings().iterator();
            while (opMappingIterator.hasNext()) {
                OperationMapping opMapping = (OperationMapping)opMappingIterator.next();
                this.removeAffectedMappingRules(opMapping, topMostRemovedObj);
            }
        }
    }
}

