/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.dtr.IResourceChangeListener;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.exception.GeneratorNotificationException;
import com.sap.caf.designer.generation.CAFApplicationGenerator;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.generation.IGenerateable;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFInterface;
import com.sap.caf.designer.structure.CAFOperation;
import com.sap.caf.designer.structure.CAFWrapperBase;
import com.sap.caf.designer.structure.IContainCustomCode;
import com.sap.caf.designer.utils.CustomCodeSnippet;
import com.sap.caf.designer.utils.CustomCodeTokenizer;
import com.sap.caf.designer.utils.ImportsExtractor;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.Operation;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CAFApplicationInterface
extends CAFInterface
implements IGenerateable,
IContainCustomCode {
    private static String SNIPPET_START_MARK = "//@@custom code start -";
    private static String SNIPPET_END_MARK = "//@@custom code end -";
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$structure$CAFApplicationInterface == null ? (class$com$sap$caf$designer$structure$CAFApplicationInterface = CAFApplicationInterface.class$("com.sap.caf.designer.structure.CAFApplicationInterface")) : class$com$sap$caf$designer$structure$CAFApplicationInterface);
    private static final String IMPORT_SNIPPET_SECTION = "[imports]";
    private static final String ATTRIBUTES_SNIPPET_SECTION = "[attributes]";
    private static final String INTERNAL_SNIPPET_SECTION = "[internal coding]";
    private ApplicationInterface applicationInterface;
    static /* synthetic */ Class class$com$sap$caf$designer$structure$CAFApplicationInterface;

    public CAFApplicationInterface(BOMSystem bomSystem, ApplicationInterface applicationInterface, Map context) {
        super(bomSystem, (MOFInterface)applicationInterface, context);
        this.applicationInterface = applicationInterface;
    }

    public CAFApplicationInterface(BOMSystem bomSystem, ApplicationInterface applicationInterface) {
        this(bomSystem, applicationInterface, null);
    }

    public ApplicationInterface getApplicationInterface() {
        return this.applicationInterface;
    }

    public File getGeneratedImplementation() throws GeneratorException {
        CAFApplicationGenerator objGen = this.bomSystem.getApplicationCodeGenerator();
        return objGen.getGeneratedImplementation(this.getBaseObject());
    }

    public Operation getOperationByMOFId(String operationId) {
        if (operationId == null) {
            return null;
        }
        Operation operation = null;
        List operations = this.applicationInterface.getOperations();
        int i = 0;
        while (i < operations.size()) {
            if (((Operation)operations.get(i)).getObjectId().equals(operationId)) {
                operation = (Operation)operations.get(i);
                break;
            }
            ++i;
        }
        return operation;
    }

    public String getTechnicalIdentifier() {
        return super.getTechnicalIdentifier((MOFInterface)this.applicationInterface, this.bomSystem);
    }

    public void deleteFaultMessage(FaultMessage aFault) {
        List operations = this.getApplicationInterface().getOperations();
        Iterator methodsIterator = operations.iterator();
        block0: while (methodsIterator.hasNext()) {
            Operation curOperation = (Operation)methodsIterator.next();
            Collection faults = curOperation.getFault();
            if (faults == null) continue;
            Iterator faultsIterator = faults.iterator();
            while (faultsIterator.hasNext()) {
                FaultMessage fault = (FaultMessage)faultsIterator.next();
                if (!fault.equals((Object)aFault)) continue;
                if (faults.size() == 1) {
                    faults.clear();
                    continue block0;
                }
                faults.remove(fault);
                continue block0;
            }
        }
    }

    public void deleteOperation(String operationId) {
        new CAFOperation(this.bomSystem, this.getOperationByMOFId(operationId)).remove();
    }

    public void eraseGeneratedCode(IResourceChangeListener changeListener) throws GeneratorException {
        CAFApplicationGenerator objGen = this.bomSystem.getApplicationCodeGenerator();
        objGen.eraseGeneratedCode(this.getBaseObject(), changeListener);
    }

    public void generateObject(GenerationMonitor monitor, IResourceChangeListener changeListener) throws GeneratorException, GeneratorNotificationException {
        CAFApplicationGenerator objGen = this.bomSystem.getApplicationCodeGenerator();
        objGen.generateObject(this.getBaseObject(), monitor, changeListener);
    }

    public void removeNulls() {
        super.removeNulls();
    }

    public String toString() {
        return "wrapped: " + this.applicationInterface;
    }

    public void updateCode(String strObjectCode) {
        CustomCodeTokenizer tokenizer = new CustomCodeTokenizer(strObjectCode, SNIPPET_START_MARK, SNIPPET_END_MARK);
        int i = 0;
        while (i < tokenizer.getSnippetCount()) {
            this.updateCodeSnippet(tokenizer.getSnippet(i));
            ++i;
        }
    }

    public String[] getCustomImports() {
        if (this.applicationInterface.getImportsCoding() != null) {
            ImportsExtractor importList = new ImportsExtractor(this.applicationInterface.getImportsCoding());
            String[] res = new String[importList.getLength()];
            int i = 0;
            while (i < res.length) {
                res[i] = importList.getImportName(i);
                ++i;
            }
            return res;
        }
        return new String[0];
    }

    public void setCustomImports(String[] customImports) {
        StringBuffer res = new StringBuffer();
        int i = 0;
        while (i < customImports.length) {
            res.append("import ");
            res.append(customImports[i]);
            res.append(";\n");
            ++i;
        }
        this.applicationInterface.setImportsCoding(res.toString());
    }

    public boolean validate() {
        boolean result = super.validate();
        if (this.applicationInterface.getOperations().size() == 0 && this.applicationInterface.getUsedInterfaces().size() == 0) {
            this.bomSystem.getStatus().addWarningMessage("AS (" + this.applicationInterface.getObjectName() + ") has no usefull features defined.", null);
        }
        return result;
    }

    protected void removeInternal(CAFWrapperBase topMostRemovedObj) {
        super.removeInternal(topMostRemovedObj);
        try {
            this.eraseGeneratedCode(this.bomSystem.getResourceChangeListener());
        }
        catch (Exception ex) {
            logger.catching((Throwable)ex);
            ex.printStackTrace();
        }
    }

    private Operation getOperationByMethodDecl(String methodDeclr) {
        MethodDescription methodDescr = new MethodDescription(methodDeclr);
        Iterator opListIterator = this.applicationInterface.getOperations().iterator();
        while (opListIterator.hasNext()) {
            Operation nextOp = (Operation)opListIterator.next();
            if (nextOp == null || !this.checkOperation2MethodDecl(nextOp, methodDescr)) continue;
            return nextOp;
        }
        return null;
    }

    private boolean checkOperation2MethodDecl(Operation op, MethodDescription methodDescr) {
        return op.getObjectName().equals(methodDescr.methodName);
    }

    private void updateCodeSnippet(CustomCodeSnippet codeSippet) {
        if (codeSippet.getName().equals(ATTRIBUTES_SNIPPET_SECTION)) {
            this.applicationInterface.setAttributesCoding(codeSippet.getBody());
        } else if (codeSippet.getName().equals(INTERNAL_SNIPPET_SECTION)) {
            this.applicationInterface.setInternalCoding(codeSippet.getBody());
        } else {
            Operation targetOperation = this.getOperationByMethodDecl(codeSippet.getName());
            if (targetOperation != null) {
                targetOperation.setCoding(codeSippet.getBody());
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class MethodDescription {
        public String methodName = "";
        public ArrayList listArgumenTypes = new ArrayList();

        public MethodDescription(String methodDeclr) {
            int i = methodDeclr.indexOf(40);
            this.methodName = i == -1 ? methodDeclr : methodDeclr.substring(0, i);
            this.methodName = this.methodName.trim();
        }
    }
}

