/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.dtr.IResourceChangeListener;
import com.sap.caf.designer.exception.CAFRuntimeException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.exception.GeneratorNotificationException;
import com.sap.caf.designer.generation.CAFApplicationGenerator;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.generation.IGenerateable;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFApplicationInterface;
import com.sap.caf.designer.structure.CAFBaseObject;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFDataStructure;
import com.sap.caf.designer.structure.CAFExternalInterface;
import com.sap.caf.designer.structure.CAFFaultMessage;
import com.sap.caf.designer.structure.CAFWrapperBase;
import com.sap.caf.designer.utils.GeneratedFilesList;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.ExternalInterface;
import com.sap.caf.metamodel.FaultMessage;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class CAFApplication
extends CAFBaseObject
implements IGenerateable {
    private Application app;
    private HashMap businessEntityInterfaces = new HashMap();
    private HashMap applicationInterfaces = new HashMap();
    private HashMap externalInterfaces = new HashMap();
    private HashMap datastructures = new HashMap();
    private HashMap faultmesages = new HashMap();
    private GeneratedFilesList generatedFilesList;

    protected CAFApplication(BOMSystem bomSystem, Application app, Map context) {
        super(bomSystem, (BaseObject)app, context);
        this.app = app;
        this.removeNulls();
        this.load();
    }

    protected CAFApplication(BOMSystem bomSystem, Application app) {
        this(bomSystem, app, null);
    }

    public Application getApplication() {
        return this.app;
    }

    public HashMap getApplicationDataStructures() {
        return this.datastructures;
    }

    public HashMap getApplicationFaultMessages() {
        return this.faultmesages;
    }

    public HashMap getApplicationInterfaces() {
        return this.applicationInterfaces;
    }

    public HashMap getBusinessEntityInterfaces() {
        return this.businessEntityInterfaces;
    }

    public HashMap getExternalInterfaces() {
        return this.externalInterfaces;
    }

    public File getGeneratedImplementation() throws GeneratorException {
        throw new CAFRuntimeException("The method 'CAFApplication.getGeneratedImplementation()' is not supposed to be called. No sensible output.");
    }

    public String getName() {
        return this.app.getObjectId();
    }

    public void setProvider(String provider) {
        this.app.setProviderName(provider);
    }

    public String getProvider() {
        return this.app.getProviderName();
    }

    public void eraseGeneratedCode(IResourceChangeListener changeListener) throws GeneratorException {
        CAFApplicationGenerator codeGenerator = this.bomSystem.getApplicationCodeGenerator();
        codeGenerator.eraseGeneratedCode((BaseObject)this.app, changeListener);
    }

    public void generateObject(GenerationMonitor monitor, IResourceChangeListener changeListener) throws GeneratorException, GeneratorNotificationException {
        CAFApplicationGenerator codeGenerator = this.bomSystem.getApplicationCodeGenerator();
        codeGenerator.generateObject((BaseObject)this.app, monitor, changeListener);
    }

    public void generateWDModel(GenerationMonitor monitor, IResourceChangeListener changeListener) throws GeneratorException, GeneratorNotificationException {
        CAFApplicationGenerator codeGenerator = this.bomSystem.getApplicationCodeGenerator();
        codeGenerator.generateWDModel(this.app, monitor, changeListener);
    }

    public void removeNulls() {
        CAFWrapperBase.removeNulls(this.app.getBaseObjects().iterator());
        Iterator i = new LinkedList(this.app.getBaseObjects()).iterator();
        while (i.hasNext()) {
            BaseObject baseObj = (BaseObject)i.next();
            CAFBaseObject baseObjWrap = baseObj instanceof ApplicationInterface ? new CAFApplicationInterface(this.bomSystem, (ApplicationInterface)baseObj, this.context) : (baseObj instanceof BusinessEntityInterface ? new CAFBusinessEntityInterface(this.bomSystem, (BusinessEntityInterface)baseObj, this.context) : (baseObj instanceof ExternalInterface ? new CAFExternalInterface(this.bomSystem, (ExternalInterface)baseObj, this.context) : (baseObj instanceof DataStructure ? new CAFDataStructure(this.bomSystem, (DataStructure)baseObj, this.context) : (baseObj instanceof FaultMessage ? new CAFFaultMessage(this.bomSystem, (FaultMessage)baseObj, this.context) : new CAFBaseObject(this.bomSystem, baseObj, this.context)))));
            ((CAFBaseObject)baseObjWrap).removeNulls();
        }
        super.removeNulls();
    }

    public String toString() {
        return "wrapped: " + this.app;
    }

    public boolean validate() {
        this.bomSystem.clearValidatedObjects();
        Iterator it = this.app.getBaseObjects().iterator();
        boolean result = super.validate();
        if (!this.validateList(this.app, this.app.getBaseObjects(), "service")) {
            result = false;
        }
        return result;
    }

    protected void removeInternal(CAFWrapperBase topMostRemovedObj) {
        CAFWrapperBase.removeInternal(topMostRemovedObj, this.app.getBaseObjects());
        Iterator i = this.app.getBaseObjects().iterator();
        while (i.hasNext()) {
            BaseObject baseObj = (BaseObject)i.next();
            CAFBaseObject baseObjWrap = baseObj instanceof ApplicationInterface ? new CAFApplicationInterface(this.bomSystem, (ApplicationInterface)baseObj, this.context) : (baseObj instanceof BusinessEntityInterface ? new CAFBusinessEntityInterface(this.bomSystem, (BusinessEntityInterface)baseObj, this.context) : (baseObj instanceof ExternalInterface ? new CAFExternalInterface(this.bomSystem, (ExternalInterface)baseObj, this.context) : (baseObj instanceof DataStructure ? new CAFDataStructure(this.bomSystem, (DataStructure)baseObj, this.context) : (baseObj instanceof FaultMessage ? new CAFFaultMessage(this.bomSystem, (FaultMessage)baseObj, this.context) : new CAFBaseObject(this.bomSystem, baseObj, this.context)))));
            ((CAFBaseObject)baseObjWrap).removeInternal(topMostRemovedObj);
        }
        super.removeInternal(topMostRemovedObj);
    }

    private void load() {
        Application application = this.app;
        this.businessEntityInterfaces.clear();
        this.applicationInterfaces.clear();
        this.externalInterfaces.clear();
        this.datastructures.clear();
        this.faultmesages.clear();
        Iterator iter = application.getBaseObjects().iterator();
        while (iter.hasNext()) {
            ApplicationInterface baseObj;
            Object obj = iter.next();
            if (obj instanceof ApplicationInterface) {
                baseObj = (ApplicationInterface)obj;
                CAFApplicationInterface cafApplicationInterface = new CAFApplicationInterface(this.bomSystem, baseObj);
                cafApplicationInterface.setNew(false);
                this.applicationInterfaces.put(baseObj.getObjectName(), cafApplicationInterface);
            }
            if (obj instanceof BusinessEntityInterface) {
                baseObj = (BusinessEntityInterface)obj;
                CAFBusinessEntityInterface cafBusinessEntityInterface = new CAFBusinessEntityInterface(this.bomSystem, (BusinessEntityInterface)baseObj);
                cafBusinessEntityInterface.setNew(false);
                this.businessEntityInterfaces.put(baseObj.getBusinessEntity().getObjectName(), cafBusinessEntityInterface);
            }
            if (obj instanceof ExternalInterface) {
                baseObj = (ExternalInterface)obj;
                CAFExternalInterface cafExternalInterface = new CAFExternalInterface(this.bomSystem, (ExternalInterface)baseObj);
                cafExternalInterface.setNew(false);
                this.externalInterfaces.put(baseObj.getObjectName(), cafExternalInterface);
            }
            if (obj instanceof DataStructure) {
                baseObj = (DataStructure)obj;
                this.datastructures.put(baseObj.getObjectName(), baseObj);
            }
            if (!(obj instanceof FaultMessage)) continue;
            baseObj = (FaultMessage)obj;
            this.faultmesages.put(baseObj.getObjectName(), baseObj);
        }
    }
}

