/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.IProjectTypes;
import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.actions.ProjectGenerateAllAction;
import com.sap.caf.designer.dtr.DtrService;
import com.sap.caf.designer.dtr.MMRResourceChangeListener;
import com.sap.caf.designer.exception.CAFNullPointerException;
import com.sap.caf.designer.exception.CAFResourceException;
import com.sap.caf.designer.exception.CAFRuntimeException;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.exception.GeneratorNotificationException;
import com.sap.caf.designer.generation.CAFApplicationGenerator;
import com.sap.caf.designer.generation.CAFProjectLocations;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.generation.utils.GenerationUtilsDt;
import com.sap.caf.designer.model.MetamodelProvider;
import com.sap.caf.designer.preferences.AppDesignerPreferencePage;
import com.sap.caf.designer.preferences.XMLMapStore;
import com.sap.caf.designer.status.Status;
import com.sap.caf.designer.structure.BOMActivity;
import com.sap.caf.designer.structure.CAFApplication;
import com.sap.caf.designer.structure.CAFApplicationInterface;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFExternalInterface;
import com.sap.caf.designer.structure.MModelConsistencyRegulator;
import com.sap.caf.designer.structure.util.DefaultValues;
import com.sap.caf.designer.utils.DTRReplicatorList;
import com.sap.caf.designer.utils.DateUtils;
import com.sap.caf.designer.utils.GeneratedFilesList;
import com.sap.caf.designer.utils.ModifiedServicesList;
import com.sap.caf.designer.views.ModelTreeViewer;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.metamodel.MetamodelPackage;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.tools.velocity.MainGenerator;
import com.sap.ide.eclipse.component.provider.preference.DevConfPreferencePage;
import com.sap.ide.eclipse.dii.component.ComponentUtil;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.RootImpl;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.ip.mmr.Connection;
import com.sap.ip.mmr.ConnectionFactory;
import com.sap.ip.mmr.ConnectionSpec;
import com.sap.ip.mmr.IConnection;
import com.sap.ip.mmr.IPersistence;
import com.sap.ip.mmr.RepositoryServer;
import com.sap.ip.mmr.ResourceException;
import com.sap.ip.mmr.foundation.Utilities;
import com.sap.ip.mmr.persistence.IResourceChangeListener;
import com.sap.ip.mmr.persistence.PersistenceJar;
import com.sap.ip.mmr.persistence.Workspace;
import com.sap.ip.mmr.search.QueryFilter;
import com.sap.ip.mmr.search.QueryFilters;
import com.sap.tc.devconf.IDevelopmentConfiguration;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.eclipse.workspaceMonitor.WorkspaceMonitor;
import java.io.File;
import java.net.URL;
import java.text.DateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.jmi.reflect.RefPackage;
import javax.resource.cci.LocalTransaction;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class BOMSystem
implements IProjectTypes {
    public static final int SAVE_ALL_BEFORE = 1;
    public static final int SAVE_ALL_AFTER = 2;
    public static final int ROLLBACK_ALL_BEFORE = 3;
    public static final int ROLLBACK_ALL_AFTER = 4;
    public static final int CLOSE_PROJECT_BEFORE = 5;
    public static final int ADD_AS_BEFORE = 6;
    public static final int ADD_AS_AFTER = 7;
    public static final int CHANGE_AS_BEFORE = 8;
    public static final int CHANGE_AS_AFTER = 9;
    public static final int REMOVE_AS_BEFORE = 10;
    public static final int REMOVE_AS_AFTER = 11;
    public static final int ADD_ES_BEFORE = 12;
    public static final int ADD_ES_AFTER = 13;
    public static final int CHANGE_ES_BEFORE = 14;
    public static final int CHANGE_ES_AFTER = 15;
    public static final int REMOVE_ES_BEFORE = 16;
    public static final int REMOVE_ES_AFTER = 17;
    public static final int ADD_BES_BEFORE = 18;
    public static final int ADD_BES_AFTER = 19;
    public static final int CHANGE_BES_BEFORE = 20;
    public static final int CHANGE_BES_AFTER = 21;
    public static final int REMOVE_BES_BEFORE = 22;
    public static final int REMOVE_BES_AFTER = 23;
    public static final int ADD_BES_OP_BEFORE = 24;
    public static final int ADD_BES_OP_AFTER = 25;
    public static final int CHANGE_BES_OP_BEFORE = 26;
    public static final int CHANGE_BES_OP_AFTER = 27;
    public static final int REMOVE_BES_OP_BEFORE = 28;
    public static final int REMOVE_BES_OP_AFTER = 29;
    public static final int ADD_FM_BEFORE = 30;
    public static final int ADD_FM_AFTER = 31;
    public static final int REMOVE_FM_BEFORE = 32;
    public static final int REMOVE_FM_AFTER = 33;
    public static final int ADD_BES_OP_ATTR_BEFORE = 34;
    public static final int ADD_BES_OP_ATTR_AFTER = 35;
    public static final int CHANGE_BES_OP_ATTR_BEFORE = 36;
    public static final int CHANGE_BES_OP_ATTR_AFTER = 37;
    public static final int REMOVE_BES_OP_ATTR_BEFORE = 38;
    public static final int REMOVE_BES_OP_ATTR_AFTER = 39;
    public static final int DELETE_PROJECT_BEFORE = 40;
    public static final int DELETE_PROJECT_AFTER = 41;
    public static final int GENERATE_PROJECT_BEFORE = 42;
    public static final int GENERATE_PROJECT_AFTER = 43;
    public static final int INIT_PROJECT_AFTER = 44;
    public static final String CORE_APL_NAME = "caf.core";
    public static final String DDIC_SUFFIX = "Dict";
    public static final String DDIC_PATH = "DDIC_PATH";
    public static final String DDIC_CORE = "DDIC_CORE";
    public static final String DDIC_DSMGR = "DDIC_DSMGR";
    public static final String CAF_GEN_PROJECT = "CAF_GEN_PROJECT";
    public static final String CAF_APP_DICT = "CAF_APP_DICT";
    public static final String CAF_APPICATION = "CAF_APPICATION";
    public static final String CAF_CORE_APP_DICT = "CAF_CORE_APP_DICT";
    public static final String CAF_GEN_FILES = "CAF_GN_FILES";
    public static final String CAF_VEL_PROPS = "caf_ejbs.prop";
    public static final String TECHKEY = "OBJECTKEY";
    public static final String VALIDATE = "validate";
    public static final String CREATED_AT = "createdAt";
    public static final String CREATED_BY = "createdBy";
    public static final String LAST_CHANGED_AT = "lastChangedAt";
    public static final String LAST_CHANGED_BY = "lastChangedBy";
    public static final String FOLDER = "parentFolder";
    public static final String DOCUMENT_ID = "documentId";
    public static final String STANDARD_USER = "IUser";
    public static final String STANDARD_DATE = "Date";
    public static final String STANDARD_COLLECTION = "Collection";
    public static final String RELATED_OBJ_RIDS = "relatedObjectRids";
    public static final String KEY = "key";
    public static final String MODEL_PCKG = "com.sap.caf.metamodel";
    protected static String TABLE_PREFIX = "XAP_";
    public static final int FILE_NAMES_MAX_LENGTH = 38;
    protected static DtDictionaryRoot _dictRootCore = null;
    protected static HashMap bomSystems = new HashMap();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$structure$BOMSystem == null ? (class$com$sap$caf$designer$structure$BOMSystem = BOMSystem.class$("com.sap.caf.designer.structure.BOMSystem")) : class$com$sap$caf$designer$structure$BOMSystem);
    private static final TextPool mTextPool = TextPool.getInstance();
    public static final String PLUGIN_NAME = "com.sap.caf.designer";
    public static final String PLUGIN_SUBDIR_VELOCITY_TEMPLATES = "templates";
    private static final String CORE_METADATA_JAR_PATH = "/plugins/com.sap.tc.ap/comp/CAF/DCs/sap.com/caf/core/metadata/_comp/gen/default/public/compilation/lib/java/sap.com~caf~core~metadata.jar";
    private static File pluginBaseLocation = null;
    private static File vtemplatesBaseLocation = null;
    private static HashMap deletedProjects = new HashMap();
    private static final String PROGRAM_ERROR_INVALID_CALL = "BOMSystem: Invalid Call. No Application Loaded.";
    private BOMActivity bomActivity = null;
    private MModelConsistencyRegulator mmRegulator = null;
    private Workspace m_workspace;
    protected String _appName = "CORE";
    protected String _providerName;
    private CAFApplication cafApplication = null;
    private GeneratedFilesList generatedFilesList;
    private ModifiedServicesList modifiedServicesList = null;
    private DTRReplicatorList dtrReplicatorList = null;
    private DtrService resourceChangeListener;
    protected HashMap relatedProjects = new HashMap();
    protected IConnection _repository = null;
    protected LocalTransaction _txn = null;
    protected MetamodelPackage _metamodel = null;
    protected String _projectName;
    protected DtDictionaryRoot _dictRoot = null;
    protected Metamodel _metamodelDdicProject;
    protected HashSet _objects = new HashSet();
    protected HashSet _objectsVS = new HashSet();
    protected boolean _changed;
    protected boolean isCore = false;
    protected HashMap validatedObjects = new HashMap();
    private Status status = new Status();
    private transient Vector systemListeners = new Vector();
    private IPreferenceStore store = null;
    private boolean isExistsErrors = false;
    MainGenerator projectVelocityGenerator = null;
    private Application coreApplication = null;
    private HashMap coreBusinessEntities = new HashMap();
    private HashMap coreApplicationServices = new HashMap();
    private HashMap coreFaults = new HashMap();
    private HashMap coreDataStructures = new HashMap();
    static /* synthetic */ Class class$com$sap$caf$designer$structure$BOMSystem;
    static /* synthetic */ Class class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot;

    protected BOMSystem() {
        this.addWindowCloseListener();
    }

    private BOMSystem(String projName) throws CAFResourceException {
        this._projectName = projName;
        this.addWindowCloseListener();
        this.init(true);
        this.bomActivity = BOMActivity.registerBOMSystem(this);
        MModelConsistencyRegulator.createInstance(this);
        this.generatedFilesList = new GeneratedFilesList(new CAFProjectLocations(this));
        this.dtrReplicatorList = new DTRReplicatorList(new CAFProjectLocations(this));
        this.resourceChangeListener = new DtrService(true, this);
        this.modifiedServicesList = new ModifiedServicesList(new CAFProjectLocations(this), this.getApplication(), this.resourceChangeListener);
    }

    private BOMSystem(String projectName, String appName, String providerName) throws CAFResourceException {
        this._projectName = projectName;
        this._appName = appName;
        this._providerName = providerName;
        this.addWindowCloseListener();
        this.init(false);
        this.bomActivity = BOMActivity.registerBOMSystem(this);
        logger.infoT("create new application..." + appName);
        boolean bSuccess = false;
        try {
            try {
                Application application = this.createApplication(this._appName, this._providerName);
                this.cafApplication = new CAFApplication(this, application);
                this.generatedFilesList = new GeneratedFilesList(new CAFProjectLocations(this));
                this.dtrReplicatorList = new DTRReplicatorList(new CAFProjectLocations(this));
                this.resourceChangeListener = new DtrService(false, this);
                this.modifiedServicesList = new ModifiedServicesList(new CAFProjectLocations(this), this.getApplication(), this.resourceChangeListener);
                MetamodelProvider.setDirtyOn(projectName);
                this.commit();
                if (this._repository == null) {
                    this.createConnection();
                }
                this.startTransaction();
                bSuccess = true;
            }
            catch (javax.resource.ResourceException ex) {
                logger.infoT(ex.getMessage());
                Object var7_8 = null;
                if (!bSuccess) {
                    this.cafApplication = null;
                    this.rollbackSystem();
                }
            }
            Object var7_7 = null;
            if (!bSuccess) {
                this.cafApplication = null;
                this.rollbackSystem();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!bSuccess) {
                this.cafApplication = null;
                this.rollbackSystem();
            }
            throw throwable;
        }
        logger.infoT("new application created..." + appName);
    }

    public static BOMSystem getBOMSystem(String projName) {
        BOMSystem bomsystem = null;
        if (projName == null) {
            return null;
        }
        try {
            bomsystem = (BOMSystem)bomSystems.get(projName);
            if (bomsystem == null) {
                bomsystem = new BOMSystem(projName);
                bomsystem.notifyCAFObjectChanged(null, 44);
                logger.infoT("BOMSystem " + projName + " created... (getBOMSystem)");
                bomSystems.put(projName, bomsystem);
                MetamodelProvider.unRegisterMetamodelProvider(projName);
            }
        }
        catch (javax.resource.ResourceException ex) {
            logger.infoT(ex.getMessage());
        }
        return bomsystem;
    }

    public static String[] getBomSystemNames() {
        String[] ret = new String[bomSystems.size()];
        Iterator iter = bomSystems.keySet().iterator();
        int i = 0;
        while (i < ret.length) {
            ret[i] = (String)iter.next();
            ++i;
        }
        return ret;
    }

    public static HashMap getBomSystems() {
        return bomSystems;
    }

    public static boolean isContainBOMSystem(String projName) {
        return bomSystems.containsKey(projName);
    }

    public static boolean isDeletedProject(String projectName) {
        return deletedProjects.containsKey(projectName);
    }

    public static File getPluginLocation() {
        if (pluginBaseLocation == null) {
            Plugin modeler = Platform.getPlugin((String)PLUGIN_NAME);
            URL urlPluginXML = modeler.find((IPath)new Path("plugin.xml"));
            if (urlPluginXML == null) {
                throw new CAFRuntimeException("Unexpected Error. Cannot get plug-in location.");
            }
            if (!urlPluginXML.getProtocol().equals("file")) {
                throw new CAFRuntimeException("Unexpected Error. Cannot get plug-in location.");
            }
            pluginBaseLocation = new File(urlPluginXML.getPath()).getParentFile();
        }
        return pluginBaseLocation;
    }

    public static String getProjectNameFromAppName(String strAppName) {
        BOMSystem bomsystem = null;
        String[] projNamesArr = BOMSystem.getBomSystemNames();
        int ic1 = 0;
        while (ic1 < projNamesArr.length) {
            bomsystem = (BOMSystem)bomSystems.get(projNamesArr[ic1]);
            if (bomsystem != null && strAppName.equals(bomsystem.getApplicationName())) {
                return bomsystem.getProjectName();
            }
            ++ic1;
        }
        return null;
    }

    public static File getVelocityTemplatesLocation() {
        File baseDir;
        File vtemplates;
        if (vtemplatesBaseLocation == null && (vtemplates = new File(baseDir = BOMSystem.getPluginLocation(), PLUGIN_SUBDIR_VELOCITY_TEMPLATES)).exists() && vtemplates.isDirectory()) {
            vtemplatesBaseLocation = vtemplates;
        }
        return vtemplatesBaseLocation;
    }

    public static boolean closeSystem(String system) {
        BOMSystem bos = (BOMSystem)bomSystems.get(system);
        if (bos == null) {
            return false;
        }
        return bos.closeSystem();
    }

    public static BOMSystem createBOMSystem(String projectName, String appName, String providerName) {
        logger.infoT(appName);
        logger.infoT(providerName);
        if (appName == null) {
            logger.infoT("WARNING: Project Name not passed in to BOMSystem.getSystem, using 'default'. Project - " + projectName);
            return null;
        }
        BOMSystem bomsystem = null;
        try {
            bomsystem = new BOMSystem(projectName, appName, providerName);
            logger.infoT("BOMSystem " + appName + " created...");
            bomsystem.initCoreApplication();
            bomSystems.put(appName, bomsystem);
            bomSystems.put(projectName, bomsystem);
        }
        catch (javax.resource.ResourceException ex) {
            logger.infoT("createBOMSystem, exception" + ex.getMessage());
        }
        return bomsystem;
    }

    public static void deleteProject(String projectName) {
        deletedProjects.put(projectName, projectName);
    }

    public DtDictionaryRoot getAppDdicRoot() {
        return this._dictRoot;
    }

    public Application getApplication() {
        if (!this.isApplicationLoaded()) {
            this.initApplicationAndObjects(this._repository);
        }
        if (this.isApplicationLoaded()) {
            return this.cafApplication.getApplication();
        }
        return null;
    }

    public CAFApplicationGenerator getApplicationCodeGenerator() throws GeneratorException {
        return new CAFApplicationGenerator(this.getProjectVelocityGenerator());
    }

    public HashMap getApplicationDataStructures() {
        if (!this.isApplicationLoaded()) {
            throw new CAFRuntimeException(PROGRAM_ERROR_INVALID_CALL);
        }
        return this.cafApplication.getApplicationDataStructures();
    }

    public HashMap getApplicationFaultMessages() {
        if (!this.isApplicationLoaded()) {
            throw new CAFRuntimeException(PROGRAM_ERROR_INVALID_CALL);
        }
        return this.cafApplication.getApplicationFaultMessages();
    }

    public HashMap getApplicationInterfaces() {
        if (!this.isApplicationLoaded()) {
            throw new CAFRuntimeException(PROGRAM_ERROR_INVALID_CALL);
        }
        return this.cafApplication.getApplicationInterfaces();
    }

    public boolean isApplicationLoaded() {
        return this.cafApplication != null;
    }

    public String getApplicationName() {
        if (BOMSystem.getBOMSystem(this._projectName) != null && BOMSystem.getBOMSystem(this._projectName).getApplication() != null && BOMSystem.getBOMSystem(this._projectName).getApplication().getObjectName() != null) {
            logger.infoT("getApplicationName return getObjectName =" + BOMSystem.getBOMSystem(this._projectName).getApplication().getObjectName());
            return BOMSystem.getBOMSystem(this._projectName).getApplication().getObjectName();
        }
        logger.infoT("getApplicationName return _appName =" + this._appName);
        return this._appName;
    }

    public HashMap getBusinessEntityInterfaces() {
        if (!this.isApplicationLoaded()) {
            throw new CAFRuntimeException(PROGRAM_ERROR_INVALID_CALL);
        }
        return this.cafApplication.getBusinessEntityInterfaces();
    }

    public CAFApplication getCAFApplication() {
        if (this.isApplicationLoaded()) {
            return this.cafApplication;
        }
        return null;
    }

    public IConnection getConnection() {
        return this._repository;
    }

    public Application getCoreApplication() {
        return this.coreApplication;
    }

    public HashMap getCoreApplicationInterfaces() {
        return this.coreApplicationServices;
    }

    public HashMap getCoreBusinessEntities() {
        return this.coreBusinessEntities;
    }

    public DtDictionaryRoot getCoreDdicRoot() {
        return _dictRootCore;
    }

    public HashMap getCoreFaults() {
        return this.coreFaults;
    }

    public Metamodel getDSManager() {
        return this._metamodelDdicProject;
    }

    public void setExistsErrors(boolean b) {
        this.isExistsErrors = b;
        ModelTreeViewer.refreshInstances();
    }

    public boolean isExistsErrors() {
        return this.isExistsErrors;
    }

    public HashMap getExternalInterfaces() {
        if (!this.isApplicationLoaded()) {
            throw new CAFRuntimeException(PROGRAM_ERROR_INVALID_CALL);
        }
        return this.cafApplication.getExternalInterfaces();
    }

    public List getFilesForBo() {
        ArrayList list = new ArrayList();
        return list;
    }

    public Object[] getHierarchyObjects() {
        return null;
    }

    public Collection getObjectList() {
        return this._objects;
    }

    public Collection getObjectVSList() {
        return this._objectsVS;
    }

    public IProject getPhysicalProjectByType(String type) {
        String projectName = this.getRelatedProjectNameByType(type);
        IProject project = null;
        if (projectName != null && !"".equals(projectName)) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            return project;
        }
        return project;
    }

    public String getPhysicalProjectPath(String type) {
        IProject project;
        String result = null;
        String projectName = this.getRelatedProjectNameByType(type);
        if (projectName != null && !"".equals(projectName) && (project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)) != null && project.getLocation() != null) {
            result = GenerationUtilsDt.definePhysicalProjectPath(project.getLocation().toOSString(), type);
        }
        return result;
    }

    public String getProjectName() {
        return this._projectName;
    }

    public static String getProjectNameFromDCName(String compName) {
        if (compName != null && !"".equals(compName)) {
            String vendor;
            String dcName;
            String configName;
            String ret;
            int index1 = compName.indexOf(":");
            int index2 = compName.lastIndexOf(":");
            if (index1 != -1 && index2 != -1 && index1 < index2 && (ret = ComponentUtil.createProjectName((String)(configName = compName.substring(0, index1)), (String)(dcName = compName.substring(index1 + 1, index2)), (String)(vendor = compName.substring(index2 + 1)))) != null && !"".equals(ret)) {
                return ret;
            }
        }
        return null;
    }

    public GeneratedFilesList getGeneratedFilesList() {
        return this.generatedFilesList;
    }

    public ModifiedServicesList getModifiedServicesList() {
        return this.modifiedServicesList;
    }

    public DTRReplicatorList getDTRReplicatorList() {
        return this.dtrReplicatorList;
    }

    public boolean isLowLevelValidationEnabled() {
        return AppDesignerPreferencePage.isPreferenceLowLevelModelValidationEnabled();
    }

    public MetamodelPackage getMetamodelPackage() {
        return this._metamodel;
    }

    public boolean isModelObjectTraceLogEnabled() {
        return AppDesignerPreferencePage.isPreferenceModelObjectTraceLogEnabled();
    }

    public String getProviderName() {
        return this._providerName;
    }

    public String getRelatedProjectNameByType(String type) {
        if ("MMR_CORE".equals(type)) {
            return this._projectName;
        }
        if ("ASSEMBLY".equals(type)) {
            return (String)this.relatedProjects.get("EJB");
        }
        String result = null;
        result = (String)this.relatedProjects.get(type);
        if (result != null && "".equals(result)) {
            result = null;
        }
        return result;
    }

    public HashMap getRelatedProjects() {
        return this.relatedProjects;
    }

    public DtrService getResourceChangeListener() {
        return this.resourceChangeListener;
    }

    public Status getStatus() {
        return this.status;
    }

    public IPreferenceStore getStore() {
        return this.store;
    }

    public void addSystemListener(BOMListener listener) {
        Vector vector = this.systemListeners;
        synchronized (vector) {
            this.systemListeners.add(listener);
        }
    }

    public static void baseObjectCreated(BaseObject baseObject) {
        String currentTimeAsString = DateUtils.getTimeStampDateAsString(new Date());
        String userName = System.getProperty("user.name");
        baseObject.setObjectId(baseObject.refMofId());
        baseObject.setCreatedAt(currentTimeAsString);
        baseObject.setCreatedBy(userName);
        baseObject.setLastChangedAt(currentTimeAsString);
        baseObject.setLastChangedBy(userName);
    }

    public static void baseObjectUpdated(BaseObject baseObject) {
        baseObject.setLastChangedBy(System.getProperty("user.name"));
        baseObject.setLastChangedAt(DateFormat.getDateInstance().format(new Date()));
    }

    public HashMap getValidatedObjects() {
        return this.validatedObjects;
    }

    public void checkWorkspaceForChanges() throws CAFResourceException {
        if (this._repository != null && this.m_workspace != null) {
            this._repository.workspaceContentHasChanged(this.m_workspace);
        }
        this.init(true);
    }

    public void clearValidatedObjects() {
        this.validatedObjects = new HashMap();
    }

    public boolean closeSystem() {
        boolean retVal;
        if (this._changed) {
            retVal = false;
        } else {
            try {
                this._txn.commit();
                this._repository.close();
                this._repository = null;
                retVal = true;
            }
            catch (javax.resource.ResourceException ex) {
                retVal = false;
            }
        }
        return retVal;
    }

    public void commit() throws CAFResourceException {
        try {
            logger.infoT("before commit------------------------------------->>>>>>>>>>>>");
            if (this._txn != null) {
                this._txn.commit();
            }
            logger.infoT("after commit----------------------------------------->>>>>>>>>>>");
            this._changed = true;
            this.getResourceChangeListener().finalizeModifications();
        }
        catch (javax.resource.ResourceException ex) {
            throw new CAFResourceException((Exception)((Object)ex));
        }
    }

    public boolean deleteBOByName() {
        return false;
    }

    public void deleteSystem() {
        bomSystems.remove(this._projectName);
        bomSystems.remove(this._appName);
        this._projectName = null;
    }

    public boolean deleteVOByName() {
        return false;
    }

    public void generateAll(GenerationMonitor monitor) throws GeneratorException, GeneratorNotificationException {
        this.cafApplication.generateObject(monitor, this.getResourceChangeListener());
        this.refreshAllProjects();
    }

    public void generateWDModel(GenerationMonitor monitor, com.sap.caf.designer.dtr.IResourceChangeListener changeListener) throws GeneratorException, GeneratorNotificationException {
        this.cafApplication.generateWDModel(monitor, changeListener);
        this.refreshAllProjects();
    }

    public void init(boolean readfromDB) throws CAFResourceException {
        logger.infoT("start init" + this._appName);
        this.initInfo();
        this.clearValidatedObjects();
        this.refreshStatus();
        if (this._repository == null) {
            this.createConnection();
        }
        this.startTransaction();
        if (readfromDB) {
            IProject cafProject;
            this.initApplicationAndObjects(this._repository);
            String projectAppDdic = this.getRelatedProjectNameByType("DICT");
            if (projectAppDdic != null && !"".equals(projectAppDdic) && (cafProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectAppDdic)) != null && cafProject.exists()) {
                try {
                    MetamodelManager mmgr = MetamodelManager.getMetamodelManager((String)projectAppDdic);
                    this._metamodelDdicProject = mmgr.getMetamodel();
                    if (this._metamodelDdicProject == null) {
                        this._metamodelDdicProject = new Metamodel(projectAppDdic, this.getPhysicalProjectPath("DICT"));
                    }
                    if (this._metamodelDdicProject != null) {
                        this._dictRoot = (DtDictionaryRoot)this._metamodelDdicProject.getRoot(class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot == null ? (class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot = BOMSystem.class$("com.sap.ide.metamodel.dictionary.DtDictionaryRoot")) : class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot);
                        if (this._dictRoot == null) {
                            this._dictRoot = (DtDictionaryRoot)this._metamodelDdicProject.createRoot(class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot == null ? (class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot = BOMSystem.class$("com.sap.ide.metamodel.dictionary.DtDictionaryRoot")) : class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot);
                        }
                    }
                }
                catch (MetamodelException ex) {
                    logger.infoT(ex.getMessage());
                }
                catch (Exception ex) {
                    logger.catching((Throwable)ex);
                }
            }
            logger.infoT("_dictRoot: " + this._dictRoot);
        }
        CAFBusinessEntityInterface.registerGeneratedTableNames(this);
    }

    public boolean initApplicationAndObjects(IConnection connection) {
        logger.infoT("reading applications from repository..." + this._appName);
        Utilities utils = Utilities.getUtilities();
        List typeList = utils.decodeQualifiedName("com.sap.caf.metamodel.Application");
        List c = null;
        List corecollection = null;
        QueryFilters coreqfs = new QueryFilters();
        QueryFilter coreqf = new QueryFilter("objectName", 0, CORE_APL_NAME);
        coreqfs.add(coreqf);
        QueryFilters thisqfs = new QueryFilters();
        QueryFilter thisqf = new QueryFilter("objectName", 1, CORE_APL_NAME);
        thisqfs.add(thisqf);
        try {
            c = connection.queryM1(typeList, thisqfs, true);
            corecollection = connection.queryM1(typeList, coreqfs, true);
            logger.infoT("BOMSystem...query executed..." + this._appName);
        }
        catch (ResourceException ex) {
            logger.errorT("ResourceException..." + ex.getMessage());
            return false;
        }
        if (c == null) {
            return false;
        }
        Application application = null;
        if (c.size() == 0) {
            return false;
        }
        Iterator appIt = c.iterator();
        application = (Application)appIt.next();
        logger.infoT("got one..." + application.getName());
        if (corecollection != null && corecollection.size() != 0) {
            Iterator coreappIt = corecollection.iterator();
            this.coreApplication = (Application)coreappIt.next();
            logger.infoT("got core...!!!" + this.coreApplication.getName());
        }
        logger.infoT(application.getObjectId());
        logger.infoT(application.getProviderName());
        this._appName = application.getObjectId();
        this._providerName = application.getProviderName();
        if (application == null) {
            logger.infoT("BOMSystem... no application read. ..." + this._projectName);
            return false;
        }
        logger.infoT("BOMSystem...reading base objects from filesystem for application " + application.getObjectName() + "...");
        this.cafApplication = new CAFApplication(this, application);
        this.initCoreObjects();
        return true;
    }

    public void initInfo() {
        IProject cafProject = ResourcesPlugin.getWorkspace().getRoot().getProject(this._projectName);
        boolean isDCProject = false;
        String dcConfigurationName = null;
        try {
            if (cafProject.hasNature("com.sap.ide.eclipse.component.provider.dcnature")) {
                IPath projectLocation;
                isDCProject = true;
                Path drtRootFolder = new Path(DevConfPreferencePage.getDevConfPoolRoot());
                if (drtRootFolder.isPrefixOf(projectLocation = cafProject.getDescription().getLocation())) {
                    IDevelopmentConfiguration devConf = ComponentUtil.getParentDevConf((IProject)cafProject);
                    dcConfigurationName = devConf == null || devConf.getConfigurationData() == null ? this._projectName.substring(0, this._projectName.indexOf(126)) : devConf.getConfigurationData().getName();
                }
            }
        }
        catch (CoreException ce) {
            dcConfigurationName = null;
            isDCProject = false;
        }
        IPath dir_path = null;
        try {
            dir_path = cafProject.getDescription() != null && cafProject.getDescription().getLocation() != null ? cafProject.getDescription().getLocation().append("cfg") : cafProject.getLocation().append("cfg");
        }
        catch (Exception e) {
            e.printStackTrace();
            dir_path = null;
        }
        File dir = dir_path.toFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        File file = new File(dir, "caf_prop.xml");
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            this.store = new XMLMapStore("root", file.getAbsolutePath());
            ((XMLMapStore)this.store).load();
            this.isCore = this.store.getBoolean("IS_CORE");
            if (!isDCProject) {
                this.relatedProjects.put("MMR", this._projectName);
                this.relatedProjects.put("MMR_CORE", this.store.getString("MMR_CORE"));
                this.relatedProjects.put("DICT", this.store.getString("DICT"));
                this.relatedProjects.put("EJB", this.store.getString("EJB"));
                this.relatedProjects.put("ENTERPRISE_APPLICATION", this.store.getString("ENTERPRISE_APPLICATION"));
                this.relatedProjects.put("WDP_PROJECT", this.store.getString("WDP_PROJECT"));
                this.relatedProjects.put("UME_PROJECT", this.store.getString("UME_PROJECT"));
            } else {
                String ume_project;
                String wdp_project;
                String enterprise_application_project;
                String ejb_project;
                String dict_project;
                this.relatedProjects.put("MMR", this._projectName);
                WorkspaceMonitor dtrMonitor = WorkspaceMonitor.getInstance();
                String mmr_core = BOMSystem.getProjectNameFromDCName(dcConfigurationName + ":" + this.store.getString("MMR_CORE"));
                if (mmr_core != null && !"".equals(mmr_core)) {
                    this.relatedProjects.put("MMR_CORE", mmr_core);
                }
                if ((dict_project = BOMSystem.getProjectNameFromDCName(dcConfigurationName + ":" + this.store.getString("DICT"))) != null && !"".equals(dict_project)) {
                    this.relatedProjects.put("DICT", dict_project);
                }
                if ((ejb_project = BOMSystem.getProjectNameFromDCName(dcConfigurationName + ":" + this.store.getString("EJB"))) != null && !"".equals(ejb_project)) {
                    this.relatedProjects.put("EJB", ejb_project);
                }
                if ((enterprise_application_project = BOMSystem.getProjectNameFromDCName(dcConfigurationName + ":" + this.store.getString("ENTERPRISE_APPLICATION"))) != null && !"".equals(enterprise_application_project)) {
                    this.relatedProjects.put("ENTERPRISE_APPLICATION", enterprise_application_project);
                }
                if ((wdp_project = BOMSystem.getProjectNameFromDCName(dcConfigurationName + ":" + this.store.getString("WDP_PROJECT"))) != null && !"".equals(wdp_project)) {
                    this.relatedProjects.put("WDP_PROJECT", wdp_project);
                }
                if ((ume_project = BOMSystem.getProjectNameFromDCName(dcConfigurationName + ":" + this.store.getString("UME_PROJECT"))) != null && !"".equals(ume_project)) {
                    this.relatedProjects.put("UME_PROJECT", ume_project);
                }
                dtrMonitor.setMonitorResource((IResource)this.getPhysicalProjectByType("MMR_CORE"), false, -1);
                dtrMonitor.setMonitorResource((IResource)this.getPhysicalProjectByType("DICT"), false, -1);
                dtrMonitor.setMonitorResource((IResource)this.getPhysicalProjectByType("EJB"), false, -1);
                dtrMonitor.setMonitorResource((IResource)this.getPhysicalProjectByType("ENTERPRISE_APPLICATION"), false, -1);
                dtrMonitor.setMonitorResource((IResource)this.getPhysicalProjectByType("WDP_PROJECT"), false, -1);
                dtrMonitor.setMonitorResource((IResource)this.getPhysicalProjectByType("UME_PROJECT"), false, -1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.catching((Throwable)e);
            this.store = null;
        }
        this.refreshStatus();
    }

    public void notifyCAFObjectChanged(Object object, int eventNum) {
        this.fireSystemListenerEvent(new BOMEvent(eventNum, object));
    }

    public void notifyCloseProject() {
        this.fireSystemListenerEvent(new BOMEvent(5, this._projectName));
    }

    public void notifyCreateApplicationServiceAfter(CAFApplicationInterface object) {
        this.fireSystemListenerEvent(new BOMEvent(7, object));
    }

    public void notifyCreateApplicationServiceBefore(CAFApplicationInterface object) {
        this.fireSystemListenerEvent(new BOMEvent(6, object));
    }

    public void notifyCreateBussinesEntityServiceAfter(CAFBusinessEntityInterface object) {
        this.fireSystemListenerEvent(new BOMEvent(19, object));
    }

    public void notifyCreateBussinesEntityServiceBefore(CAFBusinessEntityInterface object) {
        this.fireSystemListenerEvent(new BOMEvent(18, object));
    }

    public void notifyCreateExternalServiceAfter(CAFExternalInterface object) {
        this.fireSystemListenerEvent(new BOMEvent(13, object));
    }

    public void notifyCreateExternalServiceBefore(CAFExternalInterface object) {
        this.fireSystemListenerEvent(new BOMEvent(12, object));
    }

    public void notifyDeleteBussinesEntityServiceAfter(CAFBusinessEntityInterface object) {
        this.fireSystemListenerEvent(new BOMEvent(23, object));
    }

    public void notifyDeleteBussinesEntityServiceBefore(CAFBusinessEntityInterface object) {
        this.fireSystemListenerEvent(new BOMEvent(22, object));
    }

    public void notifyRemoveApplicationServiceAfter(CAFApplicationInterface object) {
        this.fireSystemListenerEvent(new BOMEvent(11, object));
    }

    public void notifyRemoveApplicationServiceBefore(CAFApplicationInterface object) {
        this.fireSystemListenerEvent(new BOMEvent(10, object));
    }

    public void notifyRemoveExternalServiceAfter(CAFExternalInterface object) {
        this.fireSystemListenerEvent(new BOMEvent(17, object));
    }

    public void notifyRemoveExternalServiceBefore(CAFExternalInterface object) {
        this.fireSystemListenerEvent(new BOMEvent(16, object));
    }

    public void refreshAllProjects() {
        String[] arrPrjNames = new String[]{this.getRelatedProjectNameByType("EJB"), this.getRelatedProjectNameByType("ASSEMBLY"), this.getRelatedProjectNameByType("DICT"), this.getRelatedProjectNameByType("MMR"), this.getRelatedProjectNameByType("MMR_CORE"), this.getRelatedProjectNameByType(DDIC_CORE), this.getRelatedProjectNameByType("IS_CORE"), this.getRelatedProjectNameByType("SERVICE_ASSEMBLY"), this.getRelatedProjectNameByType("ENTERPRISE_APPLICATION"), this.getRelatedProjectNameByType("WDP_PROJECT"), this.getRelatedProjectNameByType("UME_PROJECT")};
        int i = 0;
        while (i < arrPrjNames.length) {
            if (arrPrjNames[i] != null) {
                this.refreshProject(arrPrjNames[i]);
            }
            ++i;
        }
    }

    public void refreshProject(String projectName) {
        IWorkspaceRoot myWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject prj = myWorkspaceRoot.getProject(projectName);
        if (prj != null) {
            try {
                prj.refreshLocal(2, null);
            }
            catch (Exception ex) {
                logger.catching("Cannot refresh project '" + projectName + "'.", (Throwable)ex);
            }
        }
    }

    public void refreshStatus() {
        if (this.bomActivity != null) {
            this.bomActivity.refreshStatus();
        }
    }

    public void reloadRelatedProjects() {
        IProject cafProject;
        String projectAppDdic = this.getRelatedProjectNameByType("DICT");
        this.initInfo();
        projectAppDdic = this.getRelatedProjectNameByType("DICT");
        if (projectAppDdic != null && !"".equals(projectAppDdic) && (cafProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projectAppDdic)) != null && cafProject.exists()) {
            try {
                MetamodelManager mmgr = MetamodelManager.getMetamodelManager((String)projectAppDdic);
                this._metamodelDdicProject = mmgr.getMetamodel();
                if (this._metamodelDdicProject == null) {
                    this._metamodelDdicProject = new Metamodel(projectAppDdic, this.getPhysicalProjectPath("DICT"));
                }
                if (this._metamodelDdicProject != null) {
                    this._dictRoot = (DtDictionaryRoot)this._metamodelDdicProject.getRoot(class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot == null ? (class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot = BOMSystem.class$("com.sap.ide.metamodel.dictionary.DtDictionaryRoot")) : class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot);
                    if (this._dictRoot == null) {
                        this._dictRoot = (DtDictionaryRoot)this._metamodelDdicProject.createRoot(class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot == null ? (class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot = BOMSystem.class$("com.sap.ide.metamodel.dictionary.DtDictionaryRoot")) : class$com$sap$ide$metamodel$dictionary$DtDictionaryRoot);
                    }
                }
            }
            catch (MetamodelException ex) {
                logger.infoT(ex.getMessage());
            }
            catch (Exception ex) {
                logger.catching((Throwable)ex);
            }
            logger.infoT("_dictRoot: " + this._dictRoot);
        }
    }

    public void removeSystemListener(BOMListener listener) {
        Vector vector = this.systemListeners;
        synchronized (vector) {
            this.systemListeners.remove(listener);
        }
    }

    public void rollbackReloadSystem() throws CAFResourceException {
        try {
            this.notifyRollbackBefore();
            this._txn.rollback();
            this._repository.close();
            this._repository = null;
            this.init(true);
            this.notifyRollbackAfter();
        }
        catch (javax.resource.ResourceException ex) {
            throw new CAFResourceException((Exception)((Object)ex));
        }
    }

    public void rollbackSystem() throws CAFResourceException {
        try {
            this.notifyRollbackBefore();
            this._txn.rollback();
            this.init(true);
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            while (window.getShell().getDisplay().readAndDispatch()) {
            }
            this.notifyRollbackAfter();
            this.getModifiedServicesList().clearList();
            ProjectGenerateAllAction.generateCodeUIAction(this);
        }
        catch (javax.resource.ResourceException ex) {
            throw new CAFResourceException((Exception)((Object)ex));
        }
    }

    public void startTransaction() throws CAFResourceException {
        try {
            this._txn = this._repository.getLocalTransaction();
            this._txn.begin();
            logger.infoT("transaction started..._txn.hashCode()= " + this._txn.hashCode());
            RefPackage outerMost = this._repository.getTopLevelPackageM1();
            String pckName = MODEL_PCKG;
            this._metamodel = (MetamodelPackage)outerMost.refPackage(pckName);
            if (this._metamodel == null) {
                logger.infoT("Metamodel not initilaized..." + this._appName);
            } else {
                logger.infoT("Metamodel initilaized..." + this._appName);
            }
            this._changed = false;
        }
        catch (javax.resource.ResourceException ex) {
            throw new CAFResourceException((Exception)((Object)ex));
        }
    }

    public void storeMetadata() throws CAFResourceException {
        this.storeMetadata(null);
    }

    public void storeMetadata(IProgressMonitor monitor) throws CAFResourceException {
        if (monitor != null) {
            monitor.beginTask(mTextPool.getText("BOM_BOMSYS_0001"), 5);
            monitor.worked(1);
        }
        this.notifySaveBefore();
        if (this.isLowLevelValidationEnabled() && this.status.hasErrors()) {
            return;
        }
        if (monitor != null) {
            monitor.setTaskName(mTextPool.getText("BOM_BOMSYS_0008"));
            monitor.worked(1);
        }
        try {
            this.commit();
        }
        catch (javax.resource.ResourceException ex) {
            logger.catching("Metadata Commit Failed.", (Throwable)ex);
            this.startTransaction();
            throw new CAFResourceException((Exception)((Object)ex));
        }
        catch (NullPointerException ex) {
            logger.catching("Severe Error : Metadata Commit Failed with NullPointer Exception", (Throwable)ex);
            ex.printStackTrace();
            throw new CAFNullPointerException(ex);
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        Iterator i = this.getApplicationInterfaces().keySet().iterator();
        while (i.hasNext()) {
            CAFApplicationInterface currentInterface = (CAFApplicationInterface)this.getApplicationInterfaces().get(i.next());
            currentInterface.setNew(false);
        }
        Iterator i2 = this.getBusinessEntityInterfaces().keySet().iterator();
        while (i2.hasNext()) {
            CAFBusinessEntityInterface currentInterface = (CAFBusinessEntityInterface)this.getBusinessEntityInterfaces().get(i2.next());
            currentInterface.setNew(false);
        }
        Iterator i3 = this.getExternalInterfaces().keySet().iterator();
        while (i3.hasNext()) {
            CAFExternalInterface currentInterface = (CAFExternalInterface)this.getExternalInterfaces().get(i3.next());
            currentInterface.setNew(false);
        }
        if (monitor != null) {
            monitor.worked(1);
        }
        try {
            IProject project = this.getPhysicalProjectByType("EJB");
            project.refreshLocal(2, monitor);
            project = this.getPhysicalProjectByType("DICT");
            project.refreshLocal(2, monitor);
            MetamodelProvider.setDirty(this._projectName, false);
            project = this.getPhysicalProjectByType("MMR");
            project.refreshLocal(2, monitor);
            MetamodelProvider.setDirty(this._projectName, false);
            project = this.getPhysicalProjectByType("ENTERPRISE_APPLICATION");
            project.refreshLocal(2, monitor);
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    ((RootImpl)BOMSystem.this._dictRoot)._getObjectCacheManager().setDirty(false);
                }
            });
            this.init(true);
            MetamodelProvider.setDirty(this._projectName, false);
        }
        catch (CoreException ex) {
            logger.catching((Throwable)ex);
            ex.printStackTrace();
        }
        if (monitor != null) {
            monitor.worked(1);
            monitor.done();
        }
        this.startTransaction();
        this.notifySaveAfter();
        this.refreshProject(this.getRelatedProjectNameByType("EJB"));
    }

    public void validate() {
        try {
            this.clearValidatedObjects();
            logger.infoT("Validation started for project: " + this._projectName);
            if (this.cafApplication == null || this.coreApplication == null) {
                this.status.addErrorMessage("Project" + this._projectName + " has invalid application or core application", null);
            } else {
                this.cafApplication.validate();
            }
            this.bomActivity.logValidationErrors();
        }
        catch (Exception e) {
            this.status.addErrorMessage("Validation failed.", null);
            e.printStackTrace();
        }
    }

    protected Application createApplication() {
        this._changed = true;
        Application app = this._metamodel.getApplication().createApplication();
        return app;
    }

    protected void fireSystemListenerEvent(BOMEvent e) {
        Vector listeners;
        Vector vector = this.systemListeners;
        synchronized (vector) {
            listeners = (Vector)this.systemListeners.clone();
        }
        Iterator it = ((AbstractList)listeners).iterator();
        while (it.hasNext()) {
            ((BOMListener)it.next()).systemChanged(e);
        }
    }

    protected void notifyRollbackAfter() {
        this.fireSystemListenerEvent(new BOMEvent(4, null));
    }

    protected void notifyRollbackBefore() {
        this.fireSystemListenerEvent(new BOMEvent(3, null));
    }

    protected void notifySaveAfter() {
        this.fireSystemListenerEvent(new BOMEvent(2, null));
    }

    protected void notifySaveBefore() {
        this.fireSystemListenerEvent(new BOMEvent(1, null));
    }

    private List getJars() {
        ArrayList<String> jars = new ArrayList<String>();
        String PATH_MMRCORE = JavaCore.getClasspathVariable((String)"ECLIPSE_HOME") + CORE_METADATA_JAR_PATH;
        jars.add(PATH_MMRCORE);
        return jars;
    }

    private MainGenerator getProjectVelocityGenerator() throws GeneratorException {
        if (this.projectVelocityGenerator == null) {
            this.projectVelocityGenerator = new MainGenerator(new CAFProjectLocations(this), this.getGeneratedFilesList(), this.modifiedServicesList);
        }
        return this.projectVelocityGenerator;
    }

    private void addWindowCloseListener() {
        if (PlatformUI.getWorkbench() != null) {
            PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

                public void windowActivated(IWorkbenchWindow window) {
                }

                public void windowDeactivated(IWorkbenchWindow window) {
                }

                public void windowClosed(IWorkbenchWindow window) {
                    BOMSystem.this.closeSystem();
                }

                public void windowOpened(IWorkbenchWindow window) {
                }
            });
        }
    }

    private Application createApplication(String appName, String providerName) {
        Application cafApp = null;
        Application application = null;
        application = this.createApplication();
        DefaultValues.setDefaults(application, null);
        application.setObjectName(appName);
        application.setProviderName(providerName);
        cafApp = application;
        return cafApp;
    }

    private void createConnection() throws CAFResourceException {
        try {
            ConnectionSpec cxs = new ConnectionSpec();
            ConnectionFactory mdrf = new ConnectionFactory();
            logger.infoT("create workspace..." + this._projectName);
            this.m_workspace = new Workspace(this._projectName);
            this.m_workspace.setReadOnly(false);
            IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(this._projectName);
            String pathName = GenerationUtilsDt.concatPathNames(project.getLocation().toOSString(), "src");
            this.m_workspace.setPath(pathName);
            this.m_workspace.setResourceChangeListener((IResourceChangeListener)new MMRResourceChangeListener(this));
            cxs.getWorkspacesM1().add(this.m_workspace);
            List jarFiles = this.getJars();
            int i = 0;
            while (i < jarFiles.size()) {
                Workspace wsCore2 = new Workspace("JAR " + jarFiles.get(i));
                wsCore2.setReadOnly(true);
                wsCore2.setPath(jarFiles.get(i).toString());
                cxs.getWorkspacesM1().add(wsCore2);
                PersistenceJar p = new PersistenceJar(RepositoryServer.getRepositoryServer(), jarFiles.get(i).toString());
                RepositoryServer.getRepositoryServer().registerPersistenceComponent((IPersistence)p);
                ++i;
            }
            logger.infoT("get connection..." + this._projectName);
            this._repository = mdrf.getConnection((javax.resource.cci.ConnectionSpec)cxs);
        }
        catch (javax.resource.ResourceException ex) {
            throw new CAFResourceException((Exception)((Object)ex));
        }
    }

    private void initCoreApplication() {
        try {
            LocalTransaction txn = null;
            Connection coreconnection = null;
            ConnectionSpec cxs = new ConnectionSpec();
            ConnectionFactory mdrf = new ConnectionFactory();
            List jarFiles = this.getJars();
            int i = 0;
            while (i < jarFiles.size()) {
                Workspace wsCore2 = new Workspace("JAR " + jarFiles.get(i));
                wsCore2.setReadOnly(true);
                wsCore2.setPath(jarFiles.get(i).toString());
                cxs.getWorkspacesM1().add(wsCore2);
                PersistenceJar p = new PersistenceJar(RepositoryServer.getRepositoryServer(), jarFiles.get(i).toString());
                RepositoryServer.getRepositoryServer().registerPersistenceComponent((IPersistence)p);
                ++i;
            }
            coreconnection = mdrf.getConnection((javax.resource.cci.ConnectionSpec)cxs);
            txn = coreconnection.getLocalTransaction();
            txn.begin();
            Utilities utils = Utilities.getUtilities();
            List typeList = utils.decodeQualifiedName("com.sap.caf.metamodel.Application");
            List c = null;
            try {
                c = coreconnection.queryM1(typeList, null, true);
                logger.infoT("BOMSystem...query executed..." + this._projectName);
            }
            catch (ResourceException ex) {
                logger.errorT("ResourceException..." + ex.getMessage());
                return;
            }
            if (c == null) {
                return;
            }
            Application application = null;
            if (c.size() == 0) {
                return;
            }
            Iterator appIt = c.iterator();
            while (appIt.hasNext()) {
                application = (Application)appIt.next();
                logger.infoT("got one..." + application.getName());
                if (!CORE_APL_NAME.equals(application.getObjectName())) continue;
                this.coreApplication = application;
                break;
            }
            this.initCoreObjects();
            txn.commit();
        }
        catch (Exception e) {
            logger.errorT("Exception init core Application .....    " + e.getMessage());
        }
    }

    private void initCoreObjects() {
        if (this.coreApplication != null) {
            Iterator corebaseObject = this.coreApplication.getBaseObjects().iterator();
            int debugcounter = 0;
            while (corebaseObject.hasNext()) {
                ++debugcounter;
                Object obj = corebaseObject.next();
                if (obj instanceof ApplicationInterface) {
                    this.coreApplicationServices.put(((ApplicationInterface)obj).getObjectName(), obj);
                    continue;
                }
                if (obj instanceof BusinessEntityInterface) {
                    BusinessEntityInterface baseObj = (BusinessEntityInterface)obj;
                    this.coreBusinessEntities.put(baseObj.getBusinessEntity().getObjectName(), baseObj);
                    Iterator operations = baseObj.getOperations().iterator();
                    while (operations.hasNext()) {
                        Operation operation = (Operation)operations.next();
                        if (operation == null) continue;
                        Collection faults = operation.getFault();
                        Iterator iter = faults.iterator();
                        while (iter.hasNext()) {
                            FaultMessage fm = (FaultMessage)iter.next();
                            String fname = fm.getObjectName();
                            this.coreFaults.put(fname, fm);
                        }
                    }
                    continue;
                }
                if (!(obj instanceof DataStructure) || obj instanceof DataObject) continue;
                this.coreDataStructures.put(((DataStructure)obj).getObjectName(), obj);
            }
        }
    }

    public HashMap getCoreDataStructures() {
        return this.coreDataStructures;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class BOMEvent {
        private int type;
        private Object target;

        private BOMEvent(int type, Object target) {
            this.type = type;
            this.target = target;
        }

        public Object getTarget() {
            return this.target;
        }

        public int getType() {
            return this.type;
        }
    }

    public static interface BOMListener {
        public void systemChanged(BOMEvent var1);
    }
}

