/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.structure;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.generation.CAFProjectLocations;
import com.sap.caf.designer.status.Message;
import com.sap.caf.designer.status.Status;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFApplication;
import com.sap.caf.designer.structure.CAFApplicationInterface;
import com.sap.caf.designer.structure.CAFAttribute;
import com.sap.caf.designer.structure.CAFBaseObject;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFConfiguration;
import com.sap.caf.designer.structure.CAFConstraint;
import com.sap.caf.designer.structure.CAFDataObject;
import com.sap.caf.designer.structure.CAFDataStructure;
import com.sap.caf.designer.structure.CAFEntry;
import com.sap.caf.designer.structure.CAFExternalInterface;
import com.sap.caf.designer.structure.CAFFaultMessage;
import com.sap.caf.designer.structure.CAFField;
import com.sap.caf.designer.structure.CAFInterface;
import com.sap.caf.designer.structure.CAFMappingRule;
import com.sap.caf.designer.structure.CAFMessage;
import com.sap.caf.designer.structure.CAFMessageMapping;
import com.sap.caf.designer.structure.CAFOperation;
import com.sap.caf.designer.structure.CAFOperationMapping;
import com.sap.caf.designer.structure.CAFPermission;
import com.sap.caf.designer.structure.CAFProperties;
import com.sap.caf.designer.structure.CAFProperty;
import com.sap.caf.designer.structure.CAFTable;
import com.sap.caf.designer.structure.CAFWrapperBase;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.ApplicationInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.Configuration;
import com.sap.caf.metamodel.Constraint;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.Entry;
import com.sap.caf.metamodel.ExternalInterface;
import com.sap.caf.metamodel.FaultMessage;
import com.sap.caf.metamodel.MOFInterface;
import com.sap.caf.metamodel.MappingRule;
import com.sap.caf.metamodel.MessageMapping;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.OperationMapping;
import com.sap.caf.metamodel.Permission;
import com.sap.caf.metamodel.Properties;
import com.sap.caf.metamodel.Property;
import com.sap.caf.metamodel.Table;
import com.sap.tc.logging.Location;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class BOMActivity
implements BOMSystem.BOMListener {
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final String VALIDATION_ENGINE_SIGNATURE = "VALIDATION ENGINE: ";
    public static final String ECLIPSE_MARKER_TYPE = "com.sap.caf.designer.projectproblemmarker";
    public static final String newLine = System.getProperty("line.separator");
    private BOMSystem bom;
    private Status currentStatus;
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$structure$BOMActivity == null ? (class$com$sap$caf$designer$structure$BOMActivity = BOMActivity.class$("com.sap.caf.designer.structure.BOMActivity")) : class$com$sap$caf$designer$structure$BOMActivity);
    static /* synthetic */ Class class$com$sap$caf$designer$structure$BOMActivity;

    private BOMActivity(BOMSystem bom) {
        this.bom = bom;
        this.currentStatus = new Status();
        CAFProjectLocations cAFProjectLocations = new CAFProjectLocations(bom);
    }

    public static CAFWrapperBase getWrapper(BOMSystem bom, Object target) {
        if (target instanceof Application) {
            return new CAFApplication(bom, (Application)target);
        }
        if (target instanceof ApplicationInterface) {
            return new CAFApplicationInterface(bom, (ApplicationInterface)target);
        }
        if (target instanceof BusinessEntityInterface) {
            return new CAFBusinessEntityInterface(bom, (BusinessEntityInterface)target);
        }
        if (target instanceof Configuration) {
            return new CAFConfiguration(bom, (Configuration)target);
        }
        if (target instanceof Constraint) {
            return new CAFConstraint(bom, (Constraint)target);
        }
        if (target instanceof Entry) {
            return new CAFEntry(bom, (Entry)target);
        }
        if (target instanceof ExternalInterface) {
            return new CAFExternalInterface(bom, (ExternalInterface)target);
        }
        if (target instanceof FaultMessage) {
            return new CAFFaultMessage(bom, (FaultMessage)target);
        }
        if (target instanceof com.sap.caf.metamodel.Field) {
            return new CAFField(bom, (com.sap.caf.metamodel.Field)target);
        }
        if (target instanceof DataObject) {
            return new CAFDataObject(bom, (DataObject)target);
        }
        if (target instanceof MappingRule) {
            return new CAFMappingRule(bom, (MappingRule)target);
        }
        if (target instanceof MessageMapping) {
            return new CAFMessageMapping(bom, (MessageMapping)target);
        }
        if (target instanceof Operation) {
            return new CAFOperation(bom, (Operation)target);
        }
        if (target instanceof OperationMapping) {
            return new CAFOperationMapping(bom, (OperationMapping)target);
        }
        if (target instanceof Permission) {
            return new CAFPermission(bom, (Permission)target);
        }
        if (target instanceof Properties) {
            return new CAFProperties(bom, (Properties)target);
        }
        if (target instanceof Property) {
            return new CAFProperty(bom, (Property)target);
        }
        if (target instanceof Table) {
            return new CAFTable(bom, (Table)target);
        }
        if (target instanceof com.sap.caf.metamodel.Message) {
            return new CAFMessage(bom, (com.sap.caf.metamodel.Message)target);
        }
        if (target instanceof Attribute) {
            return new CAFAttribute(bom, (Attribute)target);
        }
        if (target instanceof MOFInterface) {
            return new CAFInterface(bom, (MOFInterface)target);
        }
        if (target instanceof DataStructure) {
            return new CAFDataStructure(bom, (DataStructure)target);
        }
        if (target instanceof BaseObject) {
            return new CAFBaseObject(bom, (BaseObject)target);
        }
        return null;
    }

    public static BOMActivity registerBOMSystem(BOMSystem bom) {
        BOMActivity result = new BOMActivity(bom);
        bom.addSystemListener(result);
        return result;
    }

    public void logValidationErrors() {
        if (!this.bom.isModelObjectTraceLogEnabled()) {
            return;
        }
        if (this.bom.getStatus().hasErrors()) {
            StringBuffer stringBuffer = new StringBuffer(VALIDATION_ENGINE_SIGNATURE);
            stringBuffer.append(new Date().toString()).append(" [VALIDATION ERRORS] ").append(newLine);
            List messages = this.bom.getStatus().getMessages();
            int i = 0;
            while (i < messages.size()) {
                Message sm = (Message)messages.get(i);
                stringBuffer.append("\t").append(sm.toString()).append(newLine);
                ++i;
            }
            stringBuffer.append(newLine);
            logger.infoT(stringBuffer.toString());
        }
    }

    public static void showError(String title, String message) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
    }

    public static void showMessage(String title, String message) {
        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)title, (String)message);
    }

    public String getEventName(int event_id) {
        Class<?> bomClass = this.bom.getClass();
        Field[] fields = bomClass.getFields();
        int i = 0;
        while (i < fields.length) {
            try {
                if (fields[i].getType().equals(Integer.TYPE) && event_id == fields[i].getInt(this.bom)) {
                    return fields[i].getName();
                }
            }
            catch (IllegalArgumentException e) {
                logger.errorT("An illegal argument error occured while getting the name of an event with id:" + event_id + ", Error: " + e.getMessage());
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                logger.errorT("An illegal access error occured while getting the name of an event with id:" + event_id + ", Error: " + e.getMessage());
                e.printStackTrace();
            }
            ++i;
        }
        return String.valueOf(event_id);
    }

    public void refreshStatus() {
        block14: {
            String projName = this.bom.getProjectName();
            if (projName == null) {
                return;
            }
            IProject cafProject = ResourcesPlugin.getWorkspace().getRoot().getProject(projName);
            try {
                IMarker[] markers = cafProject.findMarkers(ECLIPSE_MARKER_TYPE, true, 2);
                if (markers != null) {
                    int i = 0;
                    while (i < markers.length) {
                        markers[i].delete();
                        ++i;
                    }
                }
            }
            catch (CoreException e1) {
                logger.errorT("An error has occured while loggin a BOM Activity.Error:" + e1.getMessage());
                e1.printStackTrace();
            }
            if (this.bom.isLowLevelValidationEnabled() && this.bom.getStatus().hasErrors()) {
                try {
                    IMarker marker = cafProject.createMarker(ECLIPSE_MARKER_TYPE);
                    marker.setAttribute("severity", 2);
                    marker.setAttribute("message", (Object)mTextPool.getText("METAMODEL_PROVIDER_FORBID_COMMIT_ON_VALIDATION_ERRORS_MESSAGE"));
                }
                catch (CoreException e) {
                    logger.errorT("An error occured while refreshing status.Error is:" + e.getMessage());
                    e.printStackTrace();
                }
            }
            try {
                if (PlatformUI.getWorkbench() == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow() == null || PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() == null) break block14;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IViewReference[] parts = page.getViewReferences();
                int i = 0;
                while (i < parts.length) {
                    if (parts[i].getId().equals("org.eclipse.ui.views.TaskList")) {
                        IWorkbenchPart part = parts[i].getPart(true);
                        try {
                            part.setFocus();
                            page.showView("org.eclipse.ui.views.TaskList");
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.bom.getStatus().deprecate();
    }

    public void systemChanged(BOMSystem.BOMEvent e) {
        if (this.bom.isLowLevelValidationEnabled()) {
            this.bom.validate();
            this.bom.refreshStatus();
        }
        if (this.bom.isModelObjectTraceLogEnabled()) {
            this.logEvent(e);
            this.logValidationErrors();
        }
    }

    private void logEvent(BOMSystem.BOMEvent e) {
        Object target = e.getTarget();
        if (!(e.getTarget() instanceof CAFWrapperBase)) {
            target = BOMActivity.getWrapper(this.bom, e.getTarget());
        }
        StringBuffer stringBuffer = new StringBuffer(VALIDATION_ENGINE_SIGNATURE);
        stringBuffer.append(new Date().toString() + " [" + this.getEventName(e.getType()) + "] ");
        if (target != null) {
            stringBuffer.append(target.toString());
        }
        stringBuffer.append(newLine);
        logger.infoT(stringBuffer.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

