/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.status;

import com.sap.caf.designer.status.Message;
import java.util.ArrayList;
import java.util.List;

public class Status {
    List messages = new ArrayList();
    boolean isNew = true;

    public void setMessages(List list) {
        this.messages = list;
    }

    public List getMessages() {
        return this.messages;
    }

    public void addErrorMessage(String text, Object additionalInfo) {
        this.addMessage(Message.createError(text, additionalInfo));
    }

    public void addErrorMessage(String text) {
        this.addMessage(Message.createError(text, null));
    }

    public void addInformationMessage(String text, Object additionalInfo) {
        this.addMessage(Message.createInformation(text, additionalInfo));
    }

    public void addMessage(Message message) {
        if (!this.isNew) {
            this.clear();
            this.isNew = true;
        }
        this.messages.add(message);
    }

    public void addWarningMessage(String text, Object additionalInfo) {
        this.addMessage(Message.createWarning(text, additionalInfo));
    }

    public void addWarningMessage(String text) {
        this.addMessage(Message.createWarning(text, null));
    }

    public void clear() {
        this.messages.clear();
    }

    public void deprecate() {
        this.isNew = false;
    }

    public boolean hasErrors() {
        int i = 0;
        while (i < this.messages.size()) {
            if (((Message)this.messages.get(i)).isError()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasInformation() {
        int i = 0;
        while (i < this.messages.size()) {
            if (((Message)this.messages.get(i)).isInformation()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasWarnings() {
        int i = 0;
        while (i < this.messages.size()) {
            if (((Message)this.messages.get(i)).isWarninig()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getAllMessagesAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < this.messages.size()) {
            Message message = (Message)this.messages.get(i);
            stringBuffer.append("\t").append(message).append("\n");
            ++i;
        }
        return stringBuffer.toString();
    }

    public String getErrorMessagesAsString() {
        StringBuffer stringBuffer = new StringBuffer();
        int i = 0;
        while (i < this.messages.size()) {
            Message message = (Message)this.messages.get(i);
            if (message.isError()) {
                stringBuffer.append("\t").append(message).append("\n");
            }
            ++i;
        }
        return stringBuffer.toString();
    }
}

