/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.status;

import org.eclipse.ui.IMarkerResolution;

public final class Message {
    public static final int TYPE_INFORMATION = 0;
    public static final int TYPE_WARNING = 1;
    public static final int TYPE_ERROR = 2;
    private int type;
    private String text;
    private Object additionalInfo;

    public Message(int type, String text, Object additionalInfo) {
        this.setType(type);
        this.setText(text);
        this.setAdditionalInfo(additionalInfo);
    }

    public static Message createError(String text, Object additionalInfo) {
        return new Message(2, text, additionalInfo);
    }

    public static Message createInformation(String text, Object additionalInfo) {
        return new Message(0, text, additionalInfo);
    }

    public static Message createWarning(String text, Object additionalInfo) {
        return new Message(1, text, additionalInfo);
    }

    public void setAdditionalInfo(Object object) {
        this.additionalInfo = object;
    }

    public Object getAdditionalInfo() {
        return this.additionalInfo;
    }

    public boolean isError() {
        return this.type == 2;
    }

    public boolean isInformation() {
        return this.type == 0;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getText() {
        return this.text;
    }

    public void setType(int i) {
        this.type = i;
    }

    public int getType() {
        return this.type;
    }

    public boolean isWarninig() {
        return this.type == 1;
    }

    public String toString() {
        String result = null;
        if (this.type == 2) {
            result = "ERROR: ";
        } else if (this.type == 0) {
            result = "INFO: ";
        } else if (this.type == 1) {
            result = "WARNING: ";
        }
        result = result + this.text;
        if (this.additionalInfo != null && this.additionalInfo instanceof IMarkerResolution[]) {
            IMarkerResolution[] mra = (IMarkerResolution[])this.additionalInfo;
            int i = 0;
            while (i < mra.length) {
                result = result + mra[i].getLabel() + ";";
                ++i;
            }
        }
        return result;
    }
}

