/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.preferences;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.exception.CAFIOException;
import com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl;
import com.sap.tc.logging.Location;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.preference.PreferenceStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLMapStore
extends PreferenceStore {
    private static Map items;
    private String rootName;
    private String fileName;
    private static final Location logger;
    static /* synthetic */ Class class$com$sap$caf$designer$preferences$XMLMapStore;

    public XMLMapStore(String _rootName, String fileName) {
        items = new HashMap();
        this.rootName = _rootName;
        this.fileName = fileName;
        super.setFilename(fileName);
    }

    public void setValue(String key, String value) {
        items.put(key, value);
    }

    public void setValue(String name, boolean value) {
        if (value) {
            this.setValue(name, "1");
        } else {
            this.setValue(name, "0");
        }
    }

    public String getValue(String key) {
        String result = items.containsKey(key) ? (String)items.get(key) : "";
        return result;
    }

    public boolean contains(String key) {
        boolean result = false;
        if (items.containsKey(key)) {
            result = true;
        }
        return result;
    }

    public void load() throws CAFIOException {
        try {
            FileInputStream stream = new FileInputStream(this.fileName);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, "utf-8"));
            Document document = null;
            try {
                DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
                DocumentBuilder builder = factory.newDocumentBuilder();
                document = builder.parse(new InputSource(reader));
                Node root = document.getFirstChild();
                while (root.getNodeType() == 8) {
                    document.removeChild(root);
                    root = document.getFirstChild();
                }
                NodeList children = root.getChildNodes();
                int i = 0;
                while (i < children.getLength()) {
                    Node valueNode;
                    Node child = children.item(i);
                    NodeList nl = child.getChildNodes();
                    if (null != nl && null != (valueNode = nl.item(0))) {
                        String value = valueNode.getNodeValue();
                        String key = child.getNodeName();
                        items.put(key, value);
                    }
                    ++i;
                }
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException saxEx) {
                logger.errorT("An error has occured while loading file cafComponentTypes.xml. Error is :" + saxEx.getMessage());
                saxEx.printStackTrace();
            }
        }
        catch (IOException se) {
            throw new CAFIOException(se);
        }
    }

    public void store() {
        try {
            DocumentBuilderFactoryImpl factory = new DocumentBuilderFactoryImpl();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.newDocument();
            Element root = document.createElement(this.rootName);
            document.appendChild(root);
            Iterator i = items.keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                Element child = document.createElement(key);
                root.appendChild(child);
                Text text = document.createTextNode((String)items.get(key));
                child.appendChild(text);
            }
            File file = new File(this.fileName);
            XMLMapStore.saveXML(document, file.getAbsolutePath());
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getString(String name) {
        return this.getValue(name);
    }

    public static void saveXML(Document doc, String destFile) throws CAFIOException, TransformerException {
        try {
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("indent", "yes");
            t.transform(new DOMSource(doc), new StreamResult(new FileOutputStream(destFile)));
        }
        catch (IOException se) {
            throw new CAFIOException(se);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        logger = Logger.getLocation(class$com$sap$caf$designer$preferences$XMLMapStore == null ? (class$com$sap$caf$designer$preferences$XMLMapStore = XMLMapStore.class$("com.sap.caf.designer.preferences.XMLMapStore")) : class$com$sap$caf$designer$preferences$XMLMapStore);
    }
}

