/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.preferences;

import com.sap.caf.designer.BomPlugin;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.views.ModelTreeViewer;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class AppDesignerPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String P_PATH = "pathPreference";
    public static final String P_RELEASE = "stringPreference";
    public static final String P_LOW_LEVEL_MODEL_VALIDATION_ENABLED = "lowLevelModelValidationEnabled";
    public static final String P_MODEL_OBJECT_TRACE_LOG_ENABLED = "modelObjectLogEnabled";
    private static final TextPool mTextPool = TextPool.getInstance();
    public String releaseText;

    public AppDesignerPreferencePage() {
        super(1);
        this.setPreferenceStore(BomPlugin.getDefault().getPreferenceStore());
        this.setDescription("");
        this.initializeDefaults();
    }

    public static boolean isPreferenceLowLevelModelValidationEnabled() {
        return BomPlugin.getDefault().getPreferenceStore().getBoolean(P_LOW_LEVEL_MODEL_VALIDATION_ENABLED);
    }

    public static boolean isPreferenceModelObjectTraceLogEnabled() {
        return BomPlugin.getDefault().getPreferenceStore().getBoolean(P_MODEL_OBJECT_TRACE_LOG_ENABLED);
    }

    public void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor(P_LOW_LEVEL_MODEL_VALIDATION_ENABLED, mTextPool.getText("BOM_PREFERENCES_VALIDATION_ENABLED"), this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(P_MODEL_OBJECT_TRACE_LOG_ENABLED, mTextPool.getText("BOM_PREFERENCES_MODEL_OBJECT_TRACE_LOG"), this.getFieldEditorParent()));
    }

    public void init(IWorkbench workbench) {
        this.initializeDefaults();
        this.setPreferenceStore(BomPlugin.getDefault().getPreferenceStore());
    }

    public boolean performOk() {
        boolean bEx = super.performOk();
        ModelTreeViewer.deepRefreshInstances();
        return bEx;
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        if (store.getDefaultString(P_RELEASE) != null) {
            store.setDefault(P_RELEASE, "xPD 1.0");
        }
        this.releaseText = store.getDefaultString(P_RELEASE);
        if (store.getDefaultString(P_PATH) != null) {
            store.setDefault(P_PATH, "");
        }
    }
}

