/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.model;

import com.sap.caf.designer.generation.utils.GenerationUtilsDt;
import com.sap.caf.designer.model.BaseObjectPropertyProvider;
import com.sap.caf.designer.model.BasePropertyProvider;
import com.sap.caf.designer.model.PropertiesConstants;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import java.util.ArrayList;
import java.util.Enumeration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;

public class ProjectPropertyProvider
extends BaseObjectPropertyProvider
implements PropertiesConstants {
    private boolean cafNature;

    public String getMetaClass() {
        return "Project Metaclass";
    }

    public void setObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
    }

    public Object getObjectPropertyValue(Element element, String propertyName) {
        return null;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
    }

    public String getPropertyValue(Element element, String propertyName) {
        UniqueName uniqueName = element.getUniqueName();
        this.cafNature = false;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(uniqueName.getParameter(0));
        if ("$metaclass".equals(propertyName)) {
            return this.getMetaClass();
        }
        if ("filePath".equals(propertyName)) {
            return project.getFullPath().toString();
        }
        if ("packageName".equals(propertyName)) {
            return "." + uniqueName.getParameter(0);
        }
        if (GenerationUtilsDt.isCAFProject(project)) {
            this.cafNature = true;
        }
        if ("nature".equals(propertyName)) {
            if (this.cafNature) {
                return "CAF project (nature)";
            }
            return "no CAF project (nature)";
        }
        return null;
    }

    public boolean canSetObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        return false;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String arg2) {
        return true;
    }

    public boolean hasProperty(Element element, String propertyName) {
        return "$metaclass".equals(propertyName) || "filePath".equals(propertyName) || "packageName".equals(propertyName) || "nature".equals(propertyName);
    }

    public Enumeration objectPropertyValues(Element element, String propertyName) {
        return null;
    }

    public PropertyEnumeration properties(Element element) {
        ArrayList<Property> list = new ArrayList<Property>();
        list.add(this.getProperty(element, "$metaclass"));
        list.add(this.getProperty(element, "filePath"));
        list.add(this.getProperty(element, "packageName"));
        list.add(this.getProperty(element, "nature"));
        return BasePropertyProvider.createPropertyEnumeration(list);
    }
}

