/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.model;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.structure.BOMActivity;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.ide.metamodel.Metamodel;
import com.sap.ide.metamodel.core.RootImpl;
import com.sap.ide.metamodel.core.generation.IGenerationTransactionManager;
import com.sap.ide.metamodel.core.plugin.MetamodelManager;
import com.sap.ide.metamodel.core.service.ObjectCacheManager;
import com.sap.ide.metamodel.general.CommitResult;
import com.sap.ide.metamodel.general.RollbackResult;
import com.sap.ide.metamodel.general.exception.MetamodelException;
import com.sap.tc.logging.Location;
import java.util.Hashtable;
import javax.resource.ResourceException;
import org.eclipse.swt.widgets.Display;

public class MetamodelProvider
implements IGenerationTransactionManager {
    private static Hashtable m_Instances = new Hashtable();
    private static final TextPool mTextPool = TextPool.getInstance();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$model$MetamodelProvider == null ? (class$com$sap$caf$designer$model$MetamodelProvider = MetamodelProvider.class$("com.sap.caf.designer.model.MetamodelProvider")) : class$com$sap$caf$designer$model$MetamodelProvider);
    private ObjectCacheManager m_ObjectCacheManager;
    private Metamodel m_Metamodel;
    static /* synthetic */ Class class$com$sap$caf$designer$model$MetamodelProvider;
    static /* synthetic */ Class class$com$sap$caf$designer$BOMRoot;

    public MetamodelProvider(String projName) {
        this.m_Metamodel = MetamodelManager.getMetamodel((String)projName);
        RootImpl rootImpl = (RootImpl)this.m_Metamodel.getRoot("BOM");
        if (rootImpl == null) {
            try {
                rootImpl = (RootImpl)this.m_Metamodel.createRoot(class$com$sap$caf$designer$BOMRoot == null ? (class$com$sap$caf$designer$BOMRoot = MetamodelProvider.class$("com.sap.caf.designer.BOMRoot")) : class$com$sap$caf$designer$BOMRoot);
            }
            catch (MetamodelException e) {
                logger.infoT("Creating BOMRoot failed. metamodel.name = " + this.m_Metamodel.getName());
                logger.catching((Throwable)e);
            }
        }
        if (rootImpl != null && projName.equals(rootImpl.getMetamodel().getName())) {
            this.m_ObjectCacheManager = rootImpl._getObjectCacheManager();
        }
        m_Instances.put(projName, this);
        MetamodelManager.registerGenerationTransactionManager((IGenerationTransactionManager)this);
    }

    public static void setDirty(String projName, boolean bDirty) {
        MetamodelProvider clMMProvider = MetamodelProvider.getMetamodelProvider(projName);
        if (clMMProvider.m_Metamodel.isModified() != bDirty) {
            if (clMMProvider.m_ObjectCacheManager != null) {
                final MetamodelProvider clMMProvider1 = clMMProvider;
                final boolean bDirty1 = bDirty;
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        clMMProvider1.m_ObjectCacheManager.setDirty(bDirty1);
                    }
                });
            } else {
                logger.infoT("ObjectCacheManager doesn't init. metamodel.name = " + clMMProvider.m_Metamodel.getName());
            }
        }
    }

    public static void setDirtyOn(String projName) {
        MetamodelProvider.setDirty(projName, true);
    }

    public static MetamodelProvider getMetamodelProvider(String projName) {
        MetamodelProvider clMMProvider = (MetamodelProvider)m_Instances.get(projName);
        if (clMMProvider == null) {
            clMMProvider = new MetamodelProvider(projName);
        }
        return clMMProvider;
    }

    public static boolean isModified(String projName) {
        MetamodelProvider clMMProvider = MetamodelProvider.getMetamodelProvider(projName);
        return clMMProvider.m_Metamodel.isModified();
    }

    public static void unRegisterMetamodelProvider(String projName) {
        MetamodelProvider clMMProvider = (MetamodelProvider)m_Instances.get(projName);
        if (clMMProvider != null) {
            if (clMMProvider.m_ObjectCacheManager != null && clMMProvider.m_Metamodel.isModified()) {
                MetamodelProvider.setDirty(projName, false);
            }
            MetamodelManager.unRegisterGenerationTransactionManager((IGenerationTransactionManager)clMMProvider);
            m_Instances.remove(projName);
        }
    }

    public final void commitNotification(String projName, CommitResult resultSaveAllMetadata) {
        if (resultSaveAllMetadata.hasSucceeded() && BOMSystem.isContainBOMSystem(projName)) {
            try {
                BOMSystem bom = BOMSystem.getBOMSystem(projName);
                if (bom.isLowLevelValidationEnabled() && bom.getStatus().hasErrors()) {
                    MetamodelProvider.setDirtyOn(bom.getProjectName());
                    MetamodelManager.getMetamodelManager((String)bom.getProjectName()).dirtyFlagChanged(true);
                    BOMActivity.showError(mTextPool.getText("METAMODEL_PROVIDER_FORBID_COMMIT_ON_VALIDATION_ERRORS_TITLE"), mTextPool.getText("METAMODEL_PROVIDER_FORBID_COMMIT_ON_VALIDATION_ERRORS_MESSAGE"));
                } else {
                    bom.storeMetadata();
                }
            }
            catch (ResourceException ex) {
                logger.catching((Throwable)ex);
            }
        }
    }

    public final void rollbackNotification(String projName, RollbackResult resultRollBack) {
        if (resultRollBack.hasSucceeded() && BOMSystem.isContainBOMSystem(projName)) {
            try {
                BOMSystem.getBOMSystem(projName).rollbackSystem();
            }
            catch (ResourceException ex) {
                logger.catching((Throwable)ex);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

