/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.model;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.model.BaseObjectPropertyProvider;
import com.sap.caf.designer.model.BasePropertyProvider;
import com.sap.caf.designer.model.PropertiesConstants;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFExternalInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.Constraint;
import com.sap.caf.metamodel.EntryImpl;
import com.sap.caf.metamodel.ExternalInterface;
import com.sap.caf.metamodel.Operation;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ExternalServicesOperationPropertyProvider
extends BaseObjectPropertyProvider
implements PropertiesConstants {
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$model$ExternalServicesOperationPropertyProvider == null ? (class$com$sap$caf$designer$model$ExternalServicesOperationPropertyProvider = ExternalServicesOperationPropertyProvider.class$("com.sap.caf.designer.model.ExternalServicesOperationPropertyProvider")) : class$com$sap$caf$designer$model$ExternalServicesOperationPropertyProvider);
    private static final int BOM_SYSTEM_NAME = 1;
    private static final int APPLICATION_NAME = 2;
    private static final int SERVICE_NAME = 3;
    private static final int METHOD_NAME = 4;
    private static final int OBJ_TYPE = 5;
    private static final int PATH = 6;
    private static final int INPUT_PARAMETER = 1;
    private static final int OUTPUT_PARAMETER = 2;
    private static final int FAULT_PARAMETER = 3;
    private static final String PATH_DELIM = "~";
    private static final String PATH_END = "END";
    private static final String XML_NAMESPACE_PREFIX = "xmlns:";
    private static final String TARGET_NAMESPACE = "targetNamespace";
    static /* synthetic */ Class class$com$sap$caf$designer$model$ExternalServicesOperationPropertyProvider;

    public String getMetaClass() {
        return "External Services Metaclass";
    }

    public void setObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
    }

    public Object getObjectPropertyValue(Element element, String propertyName) {
        return null;
    }

    public void setPropertyValue(Element element, String propertyName, String arg2) {
    }

    public boolean hasProperty(Element element, String propertyName) {
        return "$metaclass".equals(propertyName) || "NamespacePrefix".equals(propertyName) || "NamespaceURI".equals(propertyName) || "Type".equals(propertyName) || "minLength".equals(propertyName) || "maxLength".equals(propertyName) || "pattern".equals(propertyName) || "enumeration".equals(propertyName) || "totalDigits".equals(propertyName) || "fractionDigits".equals(propertyName);
    }

    public String getPropertyValue(Element element, String propertyName) {
        Attribute attr;
        if ("$metaclass".equals(propertyName)) {
            return this.getMetaClass();
        }
        UniqueName un = element.getUniqueName();
        boolean isInput = un.getSubDomain().equals("ES Operations Input Parameter");
        String subDomain = un.getSubDomain();
        int type = -1;
        if (subDomain.equals("ES Operations Input Parameter")) {
            type = 1;
        } else if (subDomain.equals("ES Operations Output Prameter")) {
            type = 2;
        } else if (subDomain.equals("ES Operations Fault Message")) {
            type = 3;
        }
        if (type == -1) {
            // empty if block
        }
        if ((attr = this.getAttribute(type, un)) == null) {
            return null;
        }
        if ("NamespacePrefix".equals(propertyName)) {
            return this.getNamespacePrefix(attr);
        }
        if ("NamespaceURI".equals(propertyName)) {
            return this.getNamespaceUri(this.getNamespacePrefix(attr), un);
        }
        if ("Type".equals(propertyName)) {
            return this.getType(attr);
        }
        return this.getPropertyValue(attr.getAttributeConstraint(), propertyName);
    }

    public boolean canSetObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        return false;
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String arg2) {
        return false;
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return true;
    }

    public Enumeration objectPropertyValues(Element element, String propertyName) {
        return null;
    }

    public PropertyEnumeration properties(Element element) {
        return BasePropertyProvider.createPropertyEnumeration(this.getPropertiesList(element));
    }

    protected List getPropertiesList(Element element) {
        ArrayList<Property> list = new ArrayList<Property>();
        list.add(this.getProperty(element, "$metaclass"));
        list.add(this.getProperty(element, "NamespacePrefix"));
        list.add(this.getProperty(element, "NamespaceURI"));
        list.add(this.getProperty(element, "Type"));
        return list;
    }

    private String getNamespaceUri(String prefix, UniqueName un) {
        return this.getUri(prefix, un);
    }

    private String getNamespacePrefix(Attribute attribute) {
        String name = attribute.getName();
        if (name == null || name.length() == 0) {
            return null;
        }
        int indx = name.indexOf(58);
        if (indx == -1) {
            return null;
        }
        return name.substring(0, indx);
    }

    private String getUri(String namespacePrefix, UniqueName un) {
        ExternalInterface xInterface = this.getExternalInterface(un);
        Collection entries = xInterface.getConfiguration().getProperties().getEntries();
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            String prefix;
            EntryImpl entry = (EntryImpl)i.next();
            if (entry == null || entry.getKey() == null || !entry.getKey().startsWith(XML_NAMESPACE_PREFIX) || !(prefix = this.getPrefix(entry.getKey())).equals(namespacePrefix)) continue;
            return entry.getValue();
        }
        return null;
    }

    private String getPrefix(String namespace) {
        String prefix = namespace.substring(XML_NAMESPACE_PREFIX.length());
        if (prefix.trim().length() == 0) {
            return TARGET_NAMESPACE;
        }
        return prefix;
    }

    private ExternalInterface getExternalInterface(UniqueName un) {
        HashMap exInterfaces = BOMSystem.getBOMSystem(un.getParameter(1)).getExternalInterfaces();
        CAFExternalInterface x = (CAFExternalInterface)exInterfaces.get(un.getParameter(3));
        return x.getExternalInterface();
    }

    private Operation getOperation(UniqueName un) {
        ExternalInterface xInterface = this.getExternalInterface(un);
        Iterator operations = xInterface.getOperations().iterator();
        while (operations.hasNext()) {
            Operation element = (Operation)operations.next();
            if (!element.getObjectId().equals(un.getParameter(4))) continue;
            return element;
        }
        return null;
    }

    private Attribute getAttribute(int type, UniqueName un) {
        Operation operation = this.getOperation(un);
        Collection message = null;
        switch (type) {
            case 1: {
                message = operation.getInput().getMessageParts();
                break;
            }
            case 2: {
                message = operation.getOutput().getMessageParts();
                break;
            }
            case 3: {
                message = operation.getFault();
            }
        }
        Attribute attribute = this.getAttributeByPath(un.getParameter(6), message);
        return attribute;
    }

    private Attribute getAttributeByPath(String path, Collection attributes) {
        if (path.length() == 0 || path.equals(PATH_END)) {
            return null;
        }
        String attribName = path.substring(0, path.indexOf(126));
        String pathRest = path.substring(attribName.length() + 1);
        boolean isLastAttributeId = pathRest.equals(PATH_END) || pathRest.length() == 0;
        Iterator attributesIterator = attributes.iterator();
        while (attributesIterator.hasNext()) {
            Attribute currentAttribute = (Attribute)attributesIterator.next();
            if (!currentAttribute.getObjectId().equals(attribName)) continue;
            if (isLastAttributeId) {
                return currentAttribute;
            }
            if (currentAttribute.getReferencedObject() == null) continue;
            return this.getAttributeByPath(pathRest, currentAttribute.getReferencedObject().getAttributes());
        }
        return null;
    }

    public String getType(Attribute attribute) {
        if (attribute == null) {
            return null;
        }
        String className = "";
        className = attribute.getTypeJavaDdic() != null ? attribute.getTypeJavaDdic() : attribute.getReferencedObject().getObjectName();
        if (attribute.getMaxOccurs() == -1) {
            int listType = -1;
            if (attribute.getListType() != null) {
                listType = attribute.getListType();
            }
            switch (listType) {
                case 0: {
                    return "java.util.Collection - " + className;
                }
                case 1: {
                    return "java.util.List - " + className;
                }
            }
            return "Unknown Collection type - " + className;
        }
        return className;
    }

    private String getPropertyValue(Constraint constraint, String propertyName) {
        if (constraint == null) {
            return null;
        }
        if ("minLength".equals(propertyName)) {
            return this.getConstraintIntegerAsString(constraint.getMinLength());
        }
        if ("maxLength".equals(propertyName)) {
            return this.getConstraintIntegerAsString(constraint.getMaxLength());
        }
        if ("pattern".equals(propertyName)) {
            return this.getConstraintListsAsString(constraint.getPattern());
        }
        if ("enumeration".equals(propertyName)) {
            return this.getConstraintListsAsString(constraint.getEnumeration());
        }
        if ("totalDigits".equals(propertyName)) {
            return this.getConstraintIntegerAsString(constraint.getTotalDigits());
        }
        if ("fractionDigits".equals(propertyName)) {
            return this.getConstraintIntegerAsString(constraint.getFractionDigits());
        }
        return null;
    }

    private String getConstraintListsAsString(List list) {
        if (list == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            String s = (String)list.get(i);
            result.append(s);
            if (i < list.size() - 1) {
                result.append(", ");
            }
            ++i;
        }
        return result.toString();
    }

    private String getConstraintIntegerAsString(Integer value) {
        return value != null ? value.toString() : null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

