/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.model;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.model.BaseNodeProvider;
import com.sap.caf.designer.model.ModelAccess;
import com.sap.caf.designer.model.ModelConstants;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFApplicationInterface;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFExternalInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.tools.velocity.utils.DDicConverter;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class EntityServicesOperationOutputParameterNodeProvider
implements ChildrenProvider,
ModelConstants {
    private static final transient Location logger = Logger.getLocation(class$com$sap$caf$designer$model$EntityServicesOperationOutputParameterNodeProvider == null ? (class$com$sap$caf$designer$model$EntityServicesOperationOutputParameterNodeProvider = EntityServicesOperationOutputParameterNodeProvider.class$("com.sap.caf.designer.model.EntityServicesOperationOutputParameterNodeProvider")) : class$com$sap$caf$designer$model$EntityServicesOperationOutputParameterNodeProvider);
    static /* synthetic */ Class class$com$sap$caf$designer$model$EntityServicesOperationOutputParameterNodeProvider;

    public boolean isChildrenProviderApplicable(Entity parent) {
        return true;
    }

    public UniqueNameEnumeration children(Entity parent) {
        TextPool poolCafTexts = TextPool.getInstance();
        UniqueName uniqueName = parent.getUniqueName();
        String[] params = new String[uniqueName.getParametersCount()];
        int i = 0;
        while (i < uniqueName.getParametersCount()) {
            params[i] = uniqueName.getParameter(i);
            ++i;
        }
        String bomSystemName = uniqueName.getParameter(1);
        String applicationName = uniqueName.getParameter(2);
        String serviceName = uniqueName.getParameter(3);
        String methodName = uniqueName.getParameter(4);
        String objType = uniqueName.getParameter(5);
        String path = uniqueName.getParameter(6);
        UniqueName[] childNodes = null;
        if (!(applicationName.equals("") || serviceName.equals("") || methodName.equals(""))) {
            BOMSystem bomSystem = BOMSystem.getBOMSystem(bomSystemName);
            List methods = null;
            if (objType != null && objType.equals("appserv")) {
                CAFApplicationInterface cafAppInterface = (CAFApplicationInterface)bomSystem.getApplicationInterfaces().get(serviceName);
                methods = cafAppInterface.getApplicationInterface().getOperations();
            } else if (objType != null && objType.equals("entityservice")) {
                CAFBusinessEntityInterface cafBEInterface = (CAFBusinessEntityInterface)bomSystem.getBusinessEntityInterfaces().get(serviceName);
                methods = cafBEInterface.getBusinesEntityInterface().getOperations();
            } else {
                CAFExternalInterface cafExternalInterface = (CAFExternalInterface)bomSystem.getExternalInterfaces().get(serviceName);
                methods = cafExternalInterface.getExternalInterface().getOperations();
            }
            Operation currentMethodData = null;
            Iterator methodsIterator = methods.iterator();
            while (methodsIterator.hasNext()) {
                Operation curMethodData = (Operation)methodsIterator.next();
                if (!curMethodData.getObjectId().equals(methodName)) continue;
                currentMethodData = curMethodData;
            }
            if (currentMethodData != null) {
                Message root = currentMethodData.getOutput();
                childNodes = new UniqueName[]{};
                if (root != null && root.getMessageParts() != null) {
                    Attribute currentAttrribute = this.getAttributeByPath(path, root.getMessageParts());
                    boolean isEntityServiceReference = false;
                    if (currentAttrribute != null) {
                        isEntityServiceReference = CAFBusinessEntityInterface.isEntityAttribute(currentAttrribute);
                    }
                    if (currentAttrribute != null && !isEntityServiceReference) {
                        childNodes = this.createSubNodes(parent, currentAttrribute, bomSystem);
                    }
                }
            }
        }
        UniqueNameEnumeration result = BaseNodeProvider.createUniqueNameEnumeration(childNodes);
        return result;
    }

    private Attribute getAttributeByPath(String path, Collection attributes) {
        if (path.equals("")) {
            return null;
        }
        String pathRest = path.substring(path.indexOf(126) + 1);
        String attribName = path.substring(0, path.indexOf(126));
        String pathNoEndTilda = path.substring(0, path.lastIndexOf(126));
        String lookedAttribId = pathNoEndTilda.substring(pathNoEndTilda.lastIndexOf(126) + 1);
        Iterator attributesIterator = attributes.iterator();
        while (attributesIterator.hasNext()) {
            Attribute currentAttribute = (Attribute)attributesIterator.next();
            if (currentAttribute.getObjectId().equals(lookedAttribId)) {
                return currentAttribute;
            }
            if (!currentAttribute.getObjectId().equals(attribName) || currentAttribute.getReferencedObject() == null) continue;
            return this.getAttributeByPath(pathRest, currentAttribute.getReferencedObject().getAttributes());
        }
        return null;
    }

    private UniqueName[] createSubNodes(Entity parent, Attribute attribute, BOMSystem bomSystem) {
        UniqueName[] result = new UniqueName[]{};
        UniqueName uniqueName = parent.getUniqueName();
        String path = uniqueName.getParameter(6);
        String[] params = new String[uniqueName.getParametersCount()];
        int i = 0;
        while (i < params.length) {
            params[i] = uniqueName.getParameter(i);
            ++i;
        }
        String name = "";
        String outputParameter = "";
        if (attribute.getTypeJavaDdic() == null) {
            String className = "";
            result = new UniqueName[attribute.getReferencedObject().getAttributes().size()];
            int i2 = 0;
            Iterator attributesIterator = attribute.getReferencedObject().getAttributes().iterator();
            while (attributesIterator.hasNext()) {
                int j;
                String[] paramsNew;
                Attribute currentAttribute = (Attribute)attributesIterator.next();
                name = currentAttribute.getObjectName();
                if (currentAttribute.getTypeJavaDdic() != null) {
                    className = currentAttribute.getTypeJavaDdic();
                    className = DDicConverter.convertShortDDicType(className, bomSystem.getAppDdicRoot());
                    paramsNew = new String[params.length];
                    j = 0;
                    while (j < params.length) {
                        paramsNew[j] = params[j];
                        ++j;
                    }
                    paramsNew[6] = "";
                    params = paramsNew;
                } else {
                    className = currentAttribute.getReferencedObject().getObjectName();
                    paramsNew = new String[params.length];
                    j = 0;
                    while (j < params.length) {
                        paramsNew[j] = params[j];
                        ++j;
                    }
                    paramsNew[6] = path + currentAttribute.getObjectId() + "~";
                    params = paramsNew;
                }
                if (currentAttribute.getMaxOccurs() == -1) {
                    int listType = -1;
                    if (currentAttribute.getListType() != null) {
                        listType = currentAttribute.getListType();
                    }
                    switch (listType) {
                        case 0: {
                            outputParameter = name + "(java.util.Collection)";
                            break;
                        }
                        case 1: {
                            outputParameter = name + "(java.util.List)";
                            break;
                        }
                        default: {
                            outputParameter = name + "(Unknown Collection type)";
                            break;
                        }
                    }
                } else {
                    outputParameter = name + "(" + className + ")";
                }
                result[i2] = ModelAccess.createUniqueName("CAF", "Entity Operations Output Prameter", "Entity Operations Output Prameter", outputParameter, params);
                ++i2;
            }
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

