/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.model;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.model.BaseNodeProvider;
import com.sap.caf.designer.model.ModelAccess;
import com.sap.caf.designer.model.ModelConstants;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.tools.velocity.utils.DDicConverter;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class EntityServicesOperationInputParametersNodeProvider
implements ChildrenProvider,
ModelConstants {
    private static final transient Location logger = Logger.getLocation(class$com$sap$caf$designer$model$EntityServicesOperationInputParametersNodeProvider == null ? (class$com$sap$caf$designer$model$EntityServicesOperationInputParametersNodeProvider = EntityServicesOperationInputParametersNodeProvider.class$("com.sap.caf.designer.model.EntityServicesOperationInputParametersNodeProvider")) : class$com$sap$caf$designer$model$EntityServicesOperationInputParametersNodeProvider);
    private final int CREATE_OPERATION = 1;
    private final int READ_OPERATION = 2;
    private final int UPDATE_OPERATION = 3;
    private final int DELETE_OPERATION = 4;
    private final int FINDBY_OPERATION = 5;
    private final String FIND_BY_TYPE = "QueryFilter";
    private final String KEY_ATTRIBUTE = "key";
    private final String ENTITY_TYPE = "Entity Service";
    private final String EMPTY_STRING = "";
    private final String MAP_NAME_FILTER = "mapNameToFilter";
    private final String IMPLCHEK_FILTER = "implCheck";
    private final String FINDBY_ATTR_SUFFIX = "Filter";
    static /* synthetic */ Class class$com$sap$caf$designer$model$EntityServicesOperationInputParametersNodeProvider;

    public boolean isChildrenProviderApplicable(Entity parent) {
        return true;
    }

    public UniqueNameEnumeration children(Entity parent) {
        TextPool poolCafTexts = TextPool.getInstance();
        Collection filteredAttributesCollection = null;
        Operation currentMethodData = null;
        Object curMethodName = null;
        UniqueName uniqueName = parent.getUniqueName();
        String[] params = new String[uniqueName.getParametersCount()];
        int i = 0;
        while (i < uniqueName.getParametersCount()) {
            params[i] = uniqueName.getParameter(i);
            ++i;
        }
        String bomSystemName = uniqueName.getParameter(1);
        String applicationName = uniqueName.getParameter(2);
        String serviceName = uniqueName.getParameter(3);
        String methodName = uniqueName.getParameter(4);
        String objType = uniqueName.getParameter(5);
        UniqueName[] childNodes = null;
        if (!(applicationName.equals("") || serviceName.equals("") || methodName.equals(""))) {
            BOMSystem bomSystem = BOMSystem.getBOMSystem(bomSystemName);
            Collection methods = null;
            if (objType != null && objType.equals("entityservice")) {
                CAFBusinessEntityInterface cafBEInterface = (CAFBusinessEntityInterface)bomSystem.getBusinessEntityInterfaces().get(serviceName);
                methods = cafBEInterface.getBusinesEntityInterface().getOperations();
            }
            Iterator methodsIterator = methods.iterator();
            while (methodsIterator.hasNext()) {
                Operation curMethodData = (Operation)methodsIterator.next();
                if (!curMethodData.getObjectId().equals(methodName)) continue;
                currentMethodData = curMethodData;
            }
            int operationPattern = currentMethodData.getPatternType();
            filteredAttributesCollection = this.getOperationInputAttributes(currentMethodData, parent, bomSystem, operationPattern);
            childNodes = this.getUniqueNames(currentMethodData, parent, bomSystem, filteredAttributesCollection);
        }
        UniqueNameEnumeration result = BaseNodeProvider.createUniqueNameEnumeration(childNodes);
        return result;
    }

    private Collection getOperationInputAttributes(Operation currentMethodData, Entity parent, BOMSystem bomSystem, int operationPattern) {
        Message message;
        Vector result = new Vector();
        Iterator attributesIterator = null;
        if (currentMethodData != null && (message = currentMethodData.getInput()) != null && message.getMessageParts() != null && message != null && message.getMessageParts() != null) {
            attributesIterator = message.getMessageParts().iterator();
            while (attributesIterator.hasNext()) {
                Attribute attribute = (Attribute)attributesIterator.next();
                this.filterAttribute(attribute, operationPattern, result);
            }
        }
        return result;
    }

    private UniqueName[] getUniqueNames(Operation currentMethodData, Entity parent, BOMSystem bomSystem, Collection attributesCollection) {
        UniqueName[] childNodes = new UniqueName[attributesCollection.size()];
        Iterator attributesIterator = attributesCollection.iterator();
        int i = 0;
        while (attributesIterator.hasNext()) {
            Attribute attribute = (Attribute)attributesIterator.next();
            boolean isEntityServiceReference = false;
            if (attribute != null) {
                isEntityServiceReference = CAFBusinessEntityInterface.isEntityAttribute(attribute);
            }
            if (isEntityServiceReference) continue;
            childNodes[i] = this.createSubNode(parent, attribute, bomSystem, currentMethodData);
            ++i;
        }
        return childNodes;
    }

    private UniqueName createSubNode(Entity parent, Attribute attribute, BOMSystem bomSystem, Operation currentMethodData) {
        String inputParameter = "";
        String className = "";
        String name = attribute.getObjectName();
        String methodName = currentMethodData.getObjectName();
        int operationPattern = currentMethodData.getPatternType();
        UniqueName uniqueName = parent.getUniqueName();
        String serviceName = uniqueName.getParameter(3);
        String[] params = new String[7];
        int i = 0;
        while (i < 7) {
            params[i] = uniqueName.getParameter(i);
            ++i;
        }
        params[6] = uniqueName.getParameter(6) + attribute.getObjectId() + "~";
        if (operationPattern == 5 && !name.equals("mapNameToFilter") && !name.equals("implCheck")) {
            name = name + "Filter";
            className = "QueryFilter";
        } else if (attribute.getTypeJavaDdic() != null) {
            if (name.equals("key") && (operationPattern == 3 || operationPattern == 4)) {
                CAFBusinessEntityInterface cbei = (CAFBusinessEntityInterface)bomSystem.getBusinessEntityInterfaces().get(serviceName);
                name = cbei.getBusinesEntityInterface().getBusinessEntity().getObjectName();
                className = "Entity Service";
            } else {
                className = attribute.getTypeJavaDdic();
                className = !"*".equals(className) ? DDicConverter.convertShortDDicType(className, bomSystem.getAppDdicRoot()) : "Collection";
            }
        } else {
            className = attribute.getReferencedObject().getObjectName();
        }
        if (attribute.getMaxOccurs() == -1) {
            int listType = -1;
            if (attribute.getListType() != null) {
                listType = attribute.getListType();
            }
            switch (listType) {
                case 0: {
                    inputParameter = name + "(java.util.Collection)";
                    break;
                }
                case 1: {
                    inputParameter = name + "(java.util.List)";
                    break;
                }
                default: {
                    inputParameter = name + "(Unknown Collection type)";
                    break;
                }
            }
        } else {
            inputParameter = name.equals("mapNameToFilter") ? name + "(" + "java.util.Map" + ")" : name + "(" + className + ")";
        }
        return ModelAccess.createUniqueName("CAF", "Entity Operations Input Parameter", "Entity Operations Input Parameters", inputParameter, params);
    }

    private void filterAttribute(Attribute attribute, int operationPattern, Collection result) {
        switch (operationPattern) {
            case 1: {
                if (CAFBusinessEntityInterface.isDefaultAttribute(attribute) || attribute.getMinOccurs() <= 0) break;
                result.add(attribute);
                break;
            }
            case 2: {
                if (!attribute.getObjectName().equalsIgnoreCase("key")) break;
                result.add(attribute);
                break;
            }
            case 3: {
                if (!attribute.getObjectName().equalsIgnoreCase("key")) break;
                result.add(attribute);
                break;
            }
            case 4: {
                if (!attribute.getObjectName().equalsIgnoreCase("key")) break;
                result.add(attribute);
                break;
            }
            default: {
                result.add(attribute);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

