/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.model;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.ChildrenProvider;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.extension.ParentProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.SingleEnumeration;
import java.util.Arrays;
import java.util.Collection;

public abstract class BaseNodeProvider
implements ChildrenProvider,
ParentProvider,
EntityExistenceProvider {
    public boolean isChildrenProviderApplicable(Entity parent) {
        return false;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return true;
    }

    public boolean isDeleted(Element element) {
        return false;
    }

    public UniqueName getParentUniqueName(Element child) {
        return null;
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        return false;
    }

    public boolean canDelete(Element element) {
        return false;
    }

    public UniqueNameEnumeration children(Entity parent) {
        return null;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        return null;
    }

    public static final UniqueNameEnumeration createUniqueNameEnumeration(UniqueName uniqueName) {
        if (uniqueName == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        return SingleEnumeration.createUniqueNameEnumeration((UniqueName)uniqueName);
    }

    public static final UniqueNameEnumeration createUniqueNameEnumeration(Collection collection) {
        if (collection == null || collection.isEmpty()) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        return EnumerationConverter.toUniqueNameEnumeration(collection.iterator());
    }

    public static final UniqueNameEnumeration createUniqueNameEnumeration(UniqueName[] uniqueNames) {
        if (uniqueNames == null || uniqueNames.length == 0) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        return BaseNodeProvider.createUniqueNameEnumeration(Arrays.asList(uniqueNames));
    }

    public void delete(Element element) {
    }

    public boolean exists(UniqueName uniqueName) {
        return false;
    }

    protected String getDomain() {
        return "CAF";
    }

    protected abstract String getSubDomain();
}

