/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.model;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.editors.BusinessEntityInterfaceAttributesPage;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.generation.utils.GenerationUtilsDt;
import com.sap.caf.designer.model.BaseObjectPropertyProvider;
import com.sap.caf.designer.model.BasePropertyProvider;
import com.sap.caf.designer.model.ModelAccess;
import com.sap.caf.designer.model.PropertiesConstants;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.Field;
import com.sap.caf.metamodel.Property;
import com.sap.caf.tools.velocity.utils.NamingRestrictions;
import com.sap.ide.metamodel.dictionary.DtDictionaryRoot;
import com.sap.ide.metamodel.dictionary.datatype.DtSimpleType;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BaseAttributePropertyProvider
extends BaseObjectPropertyProvider
implements PropertiesConstants {
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$model$BaseAttributePropertyProvider == null ? (class$com$sap$caf$designer$model$BaseAttributePropertyProvider = BaseAttributePropertyProvider.class$("com.sap.caf.designer.model.BaseAttributePropertyProvider")) : class$com$sap$caf$designer$model$BaseAttributePropertyProvider);
    static /* synthetic */ Class class$com$sap$caf$designer$model$BaseAttributePropertyProvider;

    public Object getObjectPropertyValue(Element element, String propertyName) {
        return null;
    }

    public Enumeration objectPropertyValues(Element element, String propertyName) {
        return null;
    }

    public boolean canSetObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        return false;
    }

    public boolean hasProperty(Element element, String propertyName) {
        return "$metaclass".equals(propertyName) || "$name".equals(propertyName) || "appName".equals(propertyName) || "GUID".equals(propertyName) || "key".equals(propertyName) || "dataType".equals(propertyName) || "multiplicity".equals(propertyName) || "relationType".equals(propertyName) || "objectType".equals(propertyName) || "mandatory".equals(propertyName) || "languageDependent".equals(propertyName) || "classification".equals(propertyName) || "searchRetrieval".equals(propertyName) || "technicalIdentifier".equals(propertyName) || "description".equals(propertyName) || "dbFieldName".equals(propertyName);
    }

    protected CAFBusinessEntityInterface getBaseObject(UniqueName un) {
        BOMSystem bos = BOMSystem.getBOMSystem(BOMSystem.getProjectNameFromAppName(un.getParameter(0)));
        if (bos == null) {
            return null;
        }
        String boName = un.getParameter(1);
        return (CAFBusinessEntityInterface)bos.getBusinessEntityInterfaces().get(boName);
    }

    protected Attribute getAttribute(UniqueName un) {
        CAFBusinessEntityInterface cbei = this.getBaseObject(un);
        if (cbei == null) {
            return null;
        }
        return cbei.getAttributeByName(un.getName());
    }

    public String getPropertyValue(Element element, String propertyName) {
        UniqueName un = element.getUniqueName();
        CAFBusinessEntityInterface cbei = this.getBaseObject(un);
        Property attr = (Property)this.getAttribute(un);
        if (attr == null) {
            return null;
        }
        if ("$metaclass".equals(propertyName)) {
            return this.getMetaClass();
        }
        if ("$name".equals(propertyName)) {
            return element.getUniqueName().getName();
        }
        if ("appName".equals(propertyName)) {
            return element.getUniqueName().getParameter(0);
        }
        if ("GUID".equals(propertyName)) {
            return attr == null ? null : attr.refMofId();
        }
        if ("multiplicity".equals(propertyName)) {
            if (attr.getMaxOccurs() > 0) {
                if (attr.getMinOccurs() == 0) {
                    return "0..1";
                }
                return "1..1";
            }
            if (attr.getMinOccurs() == 0) {
                return "0..n";
            }
            return "1..n";
        }
        if ("multiplicityType".equals(propertyName)) {
            if (attr.getRelationType() == 1) {
                return "Association";
            }
            if (attr.getRelationType() == 2) {
                return "Aggregation";
            }
            return null;
        }
        if ("relationType".equals(propertyName)) {
            if (attr.getRelationType() != null && attr.getRelationType() == 1) {
                return "Composition";
            }
            return "Association";
        }
        if ("objectType".equals(propertyName)) {
            if (CAFBusinessEntityInterface.isEntityAttribute((Attribute)attr)) {
                return "Business Entitiy";
            }
            if (CAFBusinessEntityInterface.isComplexAttribute((Attribute)attr)) {
                return "Complex Attribute";
            }
            return "Field Attribute";
        }
        if ("mandatory".equals(propertyName)) {
            return attr.getMinOccurs() == 0 ? "false" : "true";
        }
        if ("timeDependent".equals(propertyName)) {
            return attr.isTimeDependent() != false ? "true" : "false";
        }
        if ("languageDependent".equals(propertyName)) {
            return attr.isLanguageDependent() != false ? "true" : "false";
        }
        if ("key".equals(propertyName)) {
            return cbei.getBusinesEntityInterface().getBusinessEntity().getKeys().contains(attr) ? "true" : "false";
        }
        if (!"keyType".equals(propertyName)) {
            if ("dataType".equals(propertyName)) {
                if (CAFBusinessEntityInterface.isEntityAttribute((Attribute)attr)) {
                    return attr.getReferencedObject().getObjectName();
                }
                return attr.getTypeJavaDdic();
            }
            if ("technicalIdentifier".equals(propertyName)) {
                return "-";
            }
            if ("description".equals(propertyName)) {
                return attr.getShortText();
            }
            if ("dbFieldName".equals(propertyName)) {
                Iterator it;
                Field fld;
                Collection c = attr.getField();
                if (c != null && (fld = (Field)(it = c.iterator()).next()) != null) {
                    return fld.getFieldName();
                }
                return attr.getObjectName().toUpperCase();
            }
        }
        return null;
    }

    protected List getPropertiesList(Element element) {
        ArrayList<com.tssap.selena.model.elements.Property> list = new ArrayList<com.tssap.selena.model.elements.Property>();
        list.add(this.getProperty(element, "$metaclass"));
        list.add(this.getProperty(element, "$name"));
        list.add(this.getProperty(element, "appName"));
        list.add(this.getProperty(element, "key"));
        list.add(this.getProperty(element, "dataType"));
        list.add(this.getProperty(element, "languageDependent"));
        list.add(this.getProperty(element, "multiplicity"));
        list.add(this.getProperty(element, "relationType"));
        list.add(this.getProperty(element, "objectType"));
        list.add(this.getProperty(element, "mandatory"));
        list.add(this.getProperty(element, "timeDependent"));
        list.add(this.getProperty(element, "description"));
        return list;
    }

    public PropertyEnumeration properties(Element element) {
        return BasePropertyProvider.createPropertyEnumeration(this.getPropertiesList(element));
    }

    public String getMetaClass() {
        return "Attribute Metaclass";
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String propertyValue) {
        Attribute attr = this.getAttribute(element.getUniqueName());
        boolean result = attr != null && ("$name".equals(propertyName) || "dbFieldName".equals(propertyName) || "multiplicity".equals(propertyName) || "relationType".equals(propertyName) || "mandatory".equals(propertyName) || "languageDependent".equals(propertyName) || "description".equals(propertyName));
        return result;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        String fullQDDicType;
        ModelAccess.removeUniqueNameFromCache(element);
        CAFBusinessEntityInterface cbei = this.getBaseObject(element.getUniqueName());
        Property attr = (Property)this.getAttribute(element.getUniqueName());
        BusinessEntityInterfaceEditor beie = BusinessEntityInterfaceEditor.getBusinessEntityInterfaceEditor(cbei);
        BusinessEntityInterfaceAttributesPage attrPage = beie.getAttributesPage();
        if (attr == null) {
            return;
        }
        if (propertyValue == null) {
            return;
        }
        if (attr.isHollow().booleanValue()) {
            return;
        }
        if (CAFBusinessEntityInterface.isDefaultAttribute((Attribute)attr) && !"description".equals(propertyName)) {
            return;
        }
        boolean selfReference = false;
        if (CAFBusinessEntityInterface.isEntityAttribute((Attribute)attr) && attr.getReferencedObject() == cbei.getBusinesEntityInterface().getBusinessEntity()) {
            selfReference = true;
        }
        if ("$name".equals(propertyName)) {
            String newName = propertyValue.trim();
            if (cbei.getAttributeByName(newName) != null) {
                return;
            }
            Property complexAttr = null;
            if (element.getUniqueName().getSubDomain().equals("Attribute Field Attribute")) {
                complexAttr = (Property)cbei.getAttributeByName(element.getUniqueName().getParameter(2));
            }
            if (GenerationUtilsDt.isValidAttributeIdentifier(newName) && NamingRestrictions.isValidAttributeName(newName)) {
                DataStructure ds;
                if (complexAttr == null ? cbei.getAttributeByName(newName) != null : cbei.getSubAttributeByName(newName, complexAttr.getReferencedObject()) != null) {
                    return;
                }
                if (newName != null && !NamingRestrictions.isValidAttributeName(newName)) {
                    return;
                }
                CAFBusinessEntityInterface.renameAffectedAttributes((Attribute)attr, (Attribute)complexAttr, cbei, newName);
                cbei.updateFindByAttributeNames((Attribute)attr, newName);
                attr.setObjectName(newName);
                if (CAFBusinessEntityInterface.isComplexAttribute((Attribute)attr) && (ds = attr.getReferencedObject()) != null) {
                    ds.setObjectName(newName);
                }
                try {
                    attrPage.setFocus();
                    attrPage.refresh();
                    attrPage.setFocus();
                }
                catch (Exception exc) {
                    logger.errorT("An error has occured while setting the property value of :" + propertyName + "Error is:" + exc.getMessage());
                    exc.printStackTrace();
                }
            }
        } else if ("multiplicity".equals(propertyName) && cbei.getComplexParent((Attribute)attr) == null) {
            boolean canSet = false;
            Map usedInOperations = CAFBusinessEntityInterface.getAssociatedOperations((Attribute)attr, cbei.getComplexParent((Attribute)attr), cbei);
            boolean isEntityRefUsedInOperation = false;
            if (CAFBusinessEntityInterface.isEntityAttribute((Attribute)attr)) {
                isEntityRefUsedInOperation = !usedInOperations.isEmpty();
            }
            if ("0..1".equals(propertyValue) || "1..1".equals(propertyValue)) {
                attr.setMaxOccurs(new Integer(1));
                canSet = true;
                if (!(CAFBusinessEntityInterface.isComplexAttribute((Attribute)attr) || CAFBusinessEntityInterface.isEntityAttribute((Attribute)attr) || attr.isLanguageDependent().booleanValue())) {
                    cbei.changeAttributeMultiplicity(attr, false);
                }
            } else if (!isEntityRefUsedInOperation && ("0..n".equals(propertyValue) || "1..n".equals(propertyValue))) {
                if (!cbei.isKeyAttribute((Attribute)attr) && !attr.isLanguageDependent().booleanValue()) {
                    attr.setMaxOccurs(new Integer(-1));
                    canSet = true;
                }
                if (!(!canSet || cbei.isKeyAttribute((Attribute)attr) || CAFBusinessEntityInterface.isComplexAttribute((Attribute)attr) || CAFBusinessEntityInterface.isEntityAttribute((Attribute)attr) || attr.isLanguageDependent().booleanValue())) {
                    cbei.changeAttributeMultiplicity(attr, true);
                }
            }
            if (canSet && ("0..1".equals(propertyValue) || "0..n".equals(propertyValue))) {
                attr.setMinOccurs(new Integer(0));
            }
            if (canSet && !selfReference && ("1..1".equals(propertyValue) || "1..n".equals(propertyValue))) {
                attr.setMinOccurs(new Integer(1));
            }
        } else if ("relationType".equals(propertyName)) {
            if ("Association".equals(propertyValue)) {
                attr.setRelationType(new Integer(0));
            } else if ("Composition".equals(propertyValue)) {
                attr.setRelationType(new Integer(1));
            }
        } else if ("mandatory".equals(propertyName) && cbei.getComplexParent((Attribute)attr) == null) {
            if (!cbei.isKeyAttribute((Attribute)attr)) {
                if (selfReference && "true".equals(propertyValue)) {
                    return;
                }
                attr.setMinOccurs("true".equals(propertyValue) ? new Integer(1) : new Integer(0));
                cbei.updateOperations((Attribute)attr, 3);
            }
        } else if ("timeDependent".equals(propertyName) && cbei.getComplexParent((Attribute)attr) == null) {
            attr.setTimeDependent("true".equals(propertyValue) ? new Boolean(true) : new Boolean(false));
        } else if ("description".equals(propertyName)) {
            attr.setShortText(propertyValue);
        } else if ("languageDependent".equals(propertyName) && cbei.getComplexParent((Attribute)attr) == null && !cbei.isKeyAttribute((Attribute)attr) && !CAFBusinessEntityInterface.isComplexAttribute((Attribute)attr) && !CAFBusinessEntityInterface.isEntityAttribute((Attribute)attr) && attr.getMaxOccurs() >= 0 && (fullQDDicType = attr.getTypeJavaDdic()) != null) {
            int index = fullQDDicType.lastIndexOf(46);
            DtDictionaryRoot dictRoot = cbei.getBomSystem().getAppDdicRoot();
            if (dictRoot != null) {
                try {
                    DtSimpleType dtst = dictRoot.getSimpleType(fullQDDicType.substring(0, index), fullQDDicType.substring(index + 1));
                    String ret = dtst.getBuiltInType();
                    if ("string".equals(ret)) {
                        attr.setLanguageDependent("true".equals(propertyValue) ? new Boolean(true) : new Boolean(false));
                        cbei.changeLanaguageDependency(cbei, attr, "true".equals(propertyValue));
                    }
                }
                catch (Exception exc) {
                    logger.errorT("An error has occured while setting the property value of :" + propertyName + "Error is:" + exc.getMessage());
                    exc.printStackTrace();
                }
            }
        }
        beie.setDirty(true);
        cbei.getBomSystem().notifyCAFObjectChanged(attr, 21);
    }

    public void setObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

