/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.model;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.model.ASDependencyTreeFilter;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.DataStructure;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BWExtractorOperationTreeFilter
extends ASDependencyTreeFilter {
    private BOMSystem bomSystem;
    private Application application;
    private Map dataStructures = new HashMap();
    private Map coreDataStructures = new HashMap();
    private Map businessEntites = new HashMap();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$model$BWExtractorOperationTreeFilter == null ? (class$com$sap$caf$designer$model$BWExtractorOperationTreeFilter = BWExtractorOperationTreeFilter.class$("com.sap.caf.designer.model.BWExtractorOperationTreeFilter")) : class$com$sap$caf$designer$model$BWExtractorOperationTreeFilter);
    static /* synthetic */ Class class$com$sap$caf$designer$model$BWExtractorOperationTreeFilter;

    public BWExtractorOperationTreeFilter(String projectName, String serviceName, List subDomains) {
        super(projectName, serviceName, subDomains);
        this.bomSystem = BOMSystem.getBOMSystem(projectName);
        this.application = this.bomSystem.getApplication();
        this.refreshDataStructures();
    }

    private void refreshDataStructures() {
        Iterator iter = this.application.getBaseObjects().iterator();
        while (iter.hasNext()) {
            DataStructure baseObj;
            Object obj = iter.next();
            if (obj instanceof DataStructure) {
                baseObj = (DataStructure)obj;
                this.dataStructures.put(baseObj.getObjectName(), baseObj);
            }
            if (!(obj instanceof BusinessEntityInterface)) continue;
            baseObj = (BusinessEntityInterface)obj;
            this.businessEntites.put(baseObj.getBusinessEntity().getObjectName(), baseObj);
        }
        this.coreDataStructures = this.bomSystem.getCoreDataStructures();
    }

    public boolean isAvailable(PropertyMap propertyMap) {
        this.refreshDataStructures();
        try {
            boolean ret = false;
            if (propertyMap instanceof Element) {
                Element element = (Element)propertyMap;
                UniqueName uniqueName = element.getUniqueName();
                if (!uniqueName.getDomain().equals("CAF")) {
                    ret = false;
                } else {
                    String sd = uniqueName.getSubDomain();
                    if (this.subDomains.contains(sd)) {
                        ret = true;
                    }
                    if ((ret = this.projectName.equals(uniqueName.getParameter(0)) && this.serviceName.equals(uniqueName.getParameter(1)) ? ret : false) && (uniqueName.getSubDomain().equals("Data Structure") || uniqueName.getSubDomain().equals("Core Data Structure") || uniqueName.getSubDomain().equals("Data Object"))) {
                        DataObject dObj;
                        BusinessEntityInterface beiInt;
                        ret = false;
                        String dsName = uniqueName.getName();
                        DataStructure ds = (DataStructure)this.dataStructures.get(dsName);
                        if (ds == null) {
                            ds = (DataStructure)this.coreDataStructures.get(dsName);
                        }
                        if (ds != null && ds.getAttributes() != null) {
                            Iterator iAttributes = ds.getAttributes().iterator();
                            while (iAttributes.hasNext()) {
                                Attribute attribute = (Attribute)iAttributes.next();
                                if (!"RECORDTYPE".equals(attribute.getObjectName()) || !"com.sap.caf.base.integer".equals(attribute.getTypeJavaDdic())) continue;
                                ret = true;
                            }
                        }
                        if ((beiInt = (BusinessEntityInterface)this.businessEntites.get(dsName)) != null && (dObj = beiInt.getBusinessEntity()) != null && dObj.getAttributes() != null) {
                            Iterator iAttributes = dObj.getAttributes().iterator();
                            while (iAttributes.hasNext()) {
                                Attribute attribute = (Attribute)iAttributes.next();
                                if (!"RECORDTYPE".equals(attribute.getObjectName()) || !"com.sap.caf.base.integer".equals(attribute.getTypeJavaDdic())) continue;
                                ret = true;
                            }
                        }
                    }
                }
            }
            return ret;
        }
        catch (Exception e) {
            logger.errorT("An error has occured while using BWExtractorOperation filter.The error is : " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

