/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.model;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.model.BaseObjectPropertyProvider;
import com.sap.caf.designer.model.BasePropertyProvider;
import com.sap.caf.designer.model.PropertiesConstants;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import java.util.ArrayList;
import java.util.Enumeration;

public class BOPropertyProvider
extends BaseObjectPropertyProvider
implements PropertiesConstants {
    public static final String BACKEND_LOCAL = "Local";
    public static final String BACKEND_KM = "KM";
    public static final String BACKEND_XI = "XI";
    public static final String BACKEND_GP = "GuidedProcedures";
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$model$BOPropertyProvider == null ? (class$com$sap$caf$designer$model$BOPropertyProvider = BOPropertyProvider.class$("com.sap.caf.designer.model.BOPropertyProvider")) : class$com$sap$caf$designer$model$BOPropertyProvider);
    private static final int MAX_TABLE_NAME_LENGTH = 18;
    private static final TextPool mTextPool = TextPool.getInstance();
    static /* synthetic */ Class class$com$sap$caf$designer$model$BOPropertyProvider;

    public Object getObjectPropertyValue(Element element, String propertyName) {
        return null;
    }

    public Enumeration objectPropertyValues(Element element, String propertyName) {
        return null;
    }

    public boolean canSetObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        return false;
    }

    public void setObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        logger.infoT("SetPropertyValue from BOPropertyProvider" + propertyName);
        if ("objectType".equals(propertyName)) {
            logger.infoT("PropertyValue: Objecttype = " + propertyName);
        } else {
            logger.infoT("Property: wrong value = " + propertyName);
        }
    }

    public boolean hasProperty(Element element, String propertyName) {
        return "searchRetrieval".equals(propertyName) || "classification".equals(propertyName);
    }

    public String getPropertyValue(Element element, String propertyName) {
        UniqueName uniqueName = element.getUniqueName();
        String projName = uniqueName.getParameter(0);
        if (!uniqueName.getLocation().equals("Project")) {
            projName = BOMSystem.getProjectNameFromAppName(projName);
        }
        BOMSystem bos = BOMSystem.getBOMSystem(projName);
        CAFBusinessEntityInterface cbei = (CAFBusinessEntityInterface)bos.getBusinessEntityInterfaces().get(uniqueName.getName());
        BusinessEntityInterface bei = cbei.getBusinesEntityInterface();
        DataObject beie = bei.getBusinessEntity();
        if ("$metaclass".equals(propertyName)) {
            return this.getMetaClass();
        }
        if ("$name".equals(propertyName)) {
            return beie.getObjectName();
        }
        if ("class".equals(propertyName)) {
            return uniqueName.toString();
        }
        if ("GUID".equals(propertyName)) {
            return bei.refMofId();
        }
        if ("backendType".equals(propertyName)) {
            switch (bei.getBackend()) {
                case 0: {
                    return BACKEND_LOCAL;
                }
                case 1: {
                    return "Remote";
                }
            }
        }
        if ("dbTableName".equals(propertyName)) {
            String tableName = beie.getMasterTable() != null ? beie.getMasterTable().getTableName() : "";
            return tableName;
        }
        if ("searchRetrieval".equals(propertyName)) {
            if (bei.isSearchAndRetrieval() != null && bei.isSearchAndRetrieval().booleanValue()) {
                return "true";
            }
            return "false";
        }
        if ("classification".equals(propertyName)) {
            if (bei.isClassifiable() != null && bei.isClassifiable().booleanValue()) {
                return "true";
            }
            return "false";
        }
        return null;
    }

    public void setPropertyValue(Element element, String propertyName, String propertyValue) {
        boolean isDirty = false;
        UniqueName uniqueName = element.getUniqueName();
        String projName = uniqueName.getParameter(0);
        if (!uniqueName.getLocation().equals("Project")) {
            projName = BOMSystem.getProjectNameFromAppName(projName);
        }
        BOMSystem bos = BOMSystem.getBOMSystem(projName);
        CAFBusinessEntityInterface cbei = (CAFBusinessEntityInterface)bos.getBusinessEntityInterfaces().get(uniqueName.getName());
        BusinessEntityInterface bei = cbei.getBusinesEntityInterface();
        DataObject beie = bei.getBusinessEntity();
        BusinessEntityInterfaceEditor bee = BusinessEntityInterfaceEditor.getBusinessEntityInterfaceEditor(cbei);
        if ("backendType".equals(propertyName)) {
            boolean m_bPersistency = false;
            if (propertyValue.equals(BACKEND_LOCAL)) {
                m_bPersistency = true;
            } else if (propertyValue.equals(BACKEND_XI)) {
                m_bPersistency = false;
            }
            isDirty = true;
            bei.setBackend(new Integer(m_bPersistency ? 0 : 1));
            cbei.changePersistency(bei.getBackend());
            bee.setDatasourceEnabled(!m_bPersistency);
            bee.getPersistencyPage().refreshPage();
        }
        if ("searchRetrieval".equals(propertyName)) {
            bei.setSearchAndRetrieval(new Boolean(propertyValue.equals("true")));
            cbei.manageRetrievalMethods();
            isDirty = true;
        } else if ("classification".equals(propertyName)) {
            bei.setClassifiable(new Boolean(propertyValue.equals("true")));
            cbei.manageClasifiableMethods();
            isDirty = true;
        } else {
            super.setPropertyValue(element, propertyName, propertyValue);
        }
        if (isDirty) {
            bee.setDirty(true);
            if (bee.getAttributesPage() != null) {
                bee.getAttributesPage().refresh();
            }
            if (bee.getAttributesPage() != null) {
                bee.getAttributesPage().refreshCatalog();
            }
            if (bee.getAttributesPage() != null) {
                bee.getAttributesPage().setFocus();
            }
        }
    }

    public PropertyEnumeration properties(Element element) {
        ArrayList<Property> list = new ArrayList<Property>();
        list.add(this.getProperty(element, "searchRetrieval"));
        list.add(this.getProperty(element, "classification"));
        return BasePropertyProvider.createPropertyEnumeration(list);
    }

    public String getMetaClass() {
        return "Object Metaclass";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

