/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.model;

import com.sap.caf.designer.model.BaseDataNodeProvider;
import com.sap.caf.designer.model.BaseNodeProvider;
import com.sap.caf.designer.model.ModelAccess;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.ip.mmr.search.QueryFilter;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public final class BONodeProvider
extends BaseDataNodeProvider {
    public UniqueNameEnumeration children(Entity parent) {
        UniqueName uniqueName = parent.getUniqueName();
        String rootSubDomain = uniqueName.getLocation();
        String projName = uniqueName.getParameter(0);
        String[] params = new String[]{projName};
        if (!uniqueName.getLocation().equals("Project")) {
            projName = BOMSystem.getProjectNameFromAppName(projName);
        }
        BOMSystem boms = BOMSystem.getBOMSystem(projName);
        Collection objects = boms.getObjectList();
        ArrayList<UniqueName> boNodes = new ArrayList<UniqueName>();
        if (objects == null) {
            return BaseNodeProvider.createUniqueNameEnumeration(boNodes);
        }
        Iterator iter = objects.iterator();
        while (iter.hasNext()) {
            String boName = (String)iter.next();
            UniqueName un = ModelAccess.createUniqueName("CAF", this.getChildSubDomain(), rootSubDomain, boName, params);
            boNodes.add(un);
        }
        return BaseNodeProvider.createUniqueNameEnumeration(boNodes);
    }

    protected String getChildSubDomain() {
        return "Business Object";
    }

    protected QueryFilter getObjectTypeFilter() {
        return new QueryFilter("objectType", 0, "0");
    }

    protected String getParentSubDomain() {
        return "Business Entity Services";
    }

    protected String getSubDomain() {
        return "Business Entity Service";
    }
}

