/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.model;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.filter.YesManFilter;

public class ApplicationInterfaceTreeFilter
extends YesManFilter {
    private String bomSystemName;
    private String applicationName;
    private String serviceName;
    private String methodName;

    public ApplicationInterfaceTreeFilter(String bomSystemName, String applicationName, String serviceName, String methodName) {
        this.bomSystemName = bomSystemName;
        this.applicationName = applicationName;
        this.serviceName = serviceName;
        this.methodName = methodName;
    }

    public boolean isAvailable(PropertyMap propertyMap) {
        boolean ret = false;
        if (propertyMap instanceof Element) {
            Element element = (Element)propertyMap;
            UniqueName uniqueName = element.getUniqueName();
            if (!uniqueName.getDomain().equals("CAF")) {
                ret = false;
            } else {
                String sd = uniqueName.getSubDomain();
                if ("AS Operation Parameters".equals(sd) || "AS Operation Exceptions".equals(sd) || "AS Operation Input Parameters".equals(sd) || "AS Operation Output Parameters".equals(sd) || "AS Operation Exception".equals(sd) || "AS Operation Input Parameter".equals(sd) || "AS Operation Output Parameter".equals(sd)) {
                    ret = true;
                }
                ret = uniqueName.getParameter(1).equals(this.bomSystemName) && uniqueName.getParameter(2).equals(this.applicationName) && uniqueName.getParameter(3).equals(this.serviceName) && uniqueName.getParameter(4).equals(this.methodName) ? ret : false;
            }
        }
        return ret;
    }
}

