/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.model;

import com.sap.caf.designer.StatusLineMessage;
import com.sap.caf.designer.editors.ApplicationInterfaceEditor;
import com.sap.caf.designer.editors.ApplicationServiceOperationsPage;
import com.sap.caf.designer.model.BaseObjectPropertyProvider;
import com.sap.caf.designer.model.BasePropertyProvider;
import com.sap.caf.designer.model.PropertiesConstants;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFApplicationInterface;
import com.sap.caf.designer.utils.EntityNamesStringUtil;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;

public class ASInputParameterPropertyProvider
extends BaseObjectPropertyProvider
implements PropertiesConstants {
    public String getMetaClass() {
        return "Input Parameter Metaclass";
    }

    public void setObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
    }

    public Object getObjectPropertyValue(Element element, String propertyName) {
        return null;
    }

    public void setPropertyValue(Element element, String propertyName, String arg2) {
        UniqueName un = element.getUniqueName();
        Attribute attr = this.getAttribute(un.getSubDomain().equals("AS Operation Input Parameter"), un);
        if (attr == null) {
            return;
        }
        if (arg2 == null) {
            return;
        }
        if ("$name".equals(propertyName)) {
            String newName = arg2.trim();
            boolean canRenameAttr = true;
            ApplicationInterfaceEditor ase = ApplicationInterfaceEditor.getApplicationInterfaceEditor(BOMSystem.getBOMSystem(un.getParameter(1)).getApplicationName(), un.getParameter(3));
            StatusLineMessage slm = new StatusLineMessage();
            String error = EntityNamesStringUtil.isFieldNameValid("Attribute", newName, this.getAttributesName(un.getSubDomain().equals("AS Operation Input Parameter"), un));
            if (error == null) {
                slm.printErrorMessage("");
            } else {
                canRenameAttr = false;
                slm.printErrorMessage(error);
                ase.getOperationPage().setCatalogTreeFocus();
            }
            if (canRenameAttr) {
                attr.setObjectName(newName);
                ase.getOperationPage().setCatalogTreeFocus();
                ase.getOperationPage().refreshParameterTree();
                ase.getOperationPage().setCatalogTreeFocus();
                ase.setDirty(true);
            }
        } else if ("Collection".equals(propertyName)) {
            if ("set".equals(arg2)) {
                attr.setListType(new Integer(0));
                attr.setMaxOccurs(new Integer(-1));
            } else if ("list".equals(arg2)) {
                attr.setListType(new Integer(1));
                attr.setMaxOccurs(new Integer(-1));
            } else if ("none".equals(arg2)) {
                attr.setListType(new Integer(2));
                attr.setMaxOccurs(new Integer(1));
            }
            ApplicationInterfaceEditor ase = ApplicationInterfaceEditor.getApplicationInterfaceEditor(BOMSystem.getBOMSystem(un.getParameter(1)).getApplicationName(), un.getParameter(3));
            ase.getOperationPage().setCatalogTreeFocus();
            ase.getOperationPage().refreshParameterTree();
            ase.getOperationPage().setCatalogTreeFocus();
            ase.setDirty(true);
        } else if ("Description".equals(propertyName)) {
            attr.setShortText(arg2);
            ApplicationInterfaceEditor.getApplicationInterfaceEditor(BOMSystem.getBOMSystem(un.getParameter(1)).getApplicationName(), un.getParameter(3)).setDirty(true);
        }
    }

    public String getPropertyValue(Element element, String propertyName) {
        UniqueName un = element.getUniqueName();
        Attribute attr = this.getAttribute(un.getSubDomain().equals("AS Operation Input Parameter"), un);
        if (attr == null) {
            return null;
        }
        if ("$metaclass".equals(propertyName)) {
            if (element.getUniqueName().getSubDomain().equals("AS Operation Input Parameter")) {
                return this.getMetaClass();
            }
            return "Output Parameter Metaclass";
        }
        if ("$name".equals(propertyName)) {
            return element.getUniqueName().getName();
        }
        if ("Collection".equals(propertyName)) {
            int listtype = attr.getListType();
            return ApplicationServiceOperationsPage.atrListType[listtype];
        }
        if ("AttributeType".equals(propertyName)) {
            if (attr.getReferencedObject() != null) {
                return attr.getReferencedObject().getObjectName();
            }
            return attr.getTypeJavaDdic();
        }
        if ("Description".equals(propertyName)) {
            return attr.getShortText();
        }
        return null;
    }

    public boolean canSetObjectPropertyValue(Element element, String propertyName, Object propertyValue) {
        return "$name".equals(propertyName) && !element.getUniqueName().getSubDomain().equals("AS Operation Output Parameter") || "Collection".equals(propertyName) || "Description".equals(propertyName);
    }

    public boolean canSetPropertyValue(Element element, String propertyName, String arg2) {
        return "$name".equals(propertyName) && !element.getUniqueName().getSubDomain().equals("AS Operation Output Parameter") || "Collection".equals(propertyName) || "Description".equals(propertyName);
    }

    public boolean hasProperty(Element element, String propertyName) {
        return "$metaclass".equals(propertyName) || "$name".equals(propertyName) || "Collection".equals(propertyName) || "AttributeType".equals(propertyName) || "Description".equals(propertyName);
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return true;
    }

    public Enumeration objectPropertyValues(Element element, String propertyName) {
        return null;
    }

    public PropertyEnumeration properties(Element element) {
        return BasePropertyProvider.createPropertyEnumeration(this.getPropertiesList(element));
    }

    protected List getPropertiesList(Element element) {
        ArrayList<Property> list = new ArrayList<Property>();
        list.add(this.getProperty(element, "$metaclass"));
        list.add(this.getProperty(element, "$name"));
        list.add(this.getProperty(element, "Collection"));
        list.add(this.getProperty(element, "AttributeType"));
        list.add(this.getProperty(element, "Description"));
        return list;
    }

    private Attribute getAttribute(boolean isInput, UniqueName un) {
        Operation operation = this.getOperation(un);
        Message iomessage = null;
        iomessage = isInput ? operation.getInput() : operation.getOutput();
        Iterator iterator = iomessage.getMessageParts().iterator();
        while (iterator.hasNext()) {
            Attribute element = (Attribute)iterator.next();
            if (!element.getObjectName().equals(un.getName())) continue;
            return element;
        }
        return null;
    }

    private Collection getAttributesName(boolean isInput, UniqueName un) {
        Operation operation = this.getOperation(un);
        ArrayList<String> attrnames = new ArrayList<String>();
        Message iomessage = null;
        iomessage = isInput ? operation.getInput() : operation.getOutput();
        Iterator iterator = iomessage.getMessageParts().iterator();
        while (iterator.hasNext()) {
            Attribute element = (Attribute)iterator.next();
            if (element.getObjectName().equals(un.getName())) continue;
            attrnames.add(element.getObjectName());
        }
        return attrnames;
    }

    private CAFApplicationInterface getBaseObject(UniqueName un) {
        return (CAFApplicationInterface)BOMSystem.getBOMSystem(un.getParameter(1)).getApplicationInterfaces().get(un.getParameter(3));
    }

    private Operation getOperation(UniqueName un) {
        CAFApplicationInterface cafAI = this.getBaseObject(un);
        Iterator operations = cafAI.getApplicationInterface().getOperations().iterator();
        while (operations.hasNext()) {
            Operation element = (Operation)operations.next();
            if (!element.getObjectId().equals(un.getParameter(4))) continue;
            return element;
        }
        return null;
    }
}

