/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.generation.utils;

import com.sap.caf.designer.IProjectTypes;
import com.sap.caf.designer.Logger;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.tc.logging.Location;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import java.io.File;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.preference.IPreferenceStore;

public class GenerationUtilsDt
implements IProjectTypes {
    protected static String TABLE_PREFIX = "XAP_";
    protected static String REFERENCE_TABLE_SUFFIX = "_REF";
    protected static String LANG_TABLE_SUFFIX = "_LANG";
    protected static IPreferenceStore _prefStore = null;
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$generation$utils$GenerationUtilsDt == null ? (class$com$sap$caf$designer$generation$utils$GenerationUtilsDt = GenerationUtilsDt.class$("com.sap.caf.designer.generation.utils.GenerationUtilsDt")) : class$com$sap$caf$designer$generation$utils$GenerationUtilsDt);
    static /* synthetic */ Class class$com$sap$caf$designer$generation$utils$GenerationUtilsDt;

    public static String getProjectTypeForName(String cafProjectName, String projectName) {
        if (cafProjectName == null) {
            return null;
        }
        BOMSystem bomSystem = BOMSystem.getBOMSystem(cafProjectName);
        if (bomSystem != null) {
            return bomSystem.getRelatedProjectNameByType(projectName);
        }
        return null;
    }

    public static final boolean isValidAttributeIdentifier(String s) {
        if (!GenerationUtilsDt.isValidIdentifier(s)) {
            return false;
        }
        char cc = s.charAt(0);
        return cc >= 'a' && cc <= 'z';
    }

    public static final boolean isValidIdentifier(String s) {
        if (s != null && s.length() > 0 && !Character.isDigit(s.charAt(0)) && s.charAt(0) != '_') {
            int length = s.length();
            int i = 0;
            while (i < length) {
                char c = s.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isDigit(c))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static final boolean isValidIdentifierWithPoint(String s) {
        if (s != null && s.length() > 0 && !Character.isDigit(s.charAt(0)) && s.charAt(0) != '_') {
            int length = s.length();
            int i = 0;
            while (i < length) {
                char c = s.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '/' || c == '~' || c == '.' || c == ';' || c == '_' || Character.isDigit(c))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static final boolean isValidIdentifierWithPointAndSquareBrackets(String s) {
        if (s != null && s.length() > 0 && !Character.isDigit(s.charAt(0)) && s.charAt(0) != '_') {
            int length = s.length();
            int i = 0;
            while (i < length) {
                char c = s.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '.' || c == ';' || c == '_' || Character.isDigit(c) || c == '[' || c == ']')) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static final boolean isValidObjectIdentifier(String s) {
        if (!GenerationUtilsDt.isValidIdentifier(s)) {
            return false;
        }
        char cc = s.charAt(0);
        return cc >= 'A' && cc <= 'Z';
    }

    public static boolean isCAFProject(IProject project) {
        boolean isCAFProject = false;
        UniqueName modelUniqueName = ModelAccess.createModelUniqueName((String)project.getName());
        Model model = ModelAccess.getModel((UniqueName)modelUniqueName);
        if (model != null) {
            isCAFProject = model.hasPropertyValue("$nature", "com.sap.caf.designer.CAFNature");
        }
        return isCAFProject;
    }

    public static final boolean isValidApplicationNameIdentifier(String s) {
        if (s != null && s.length() > 0 && !Character.isDigit(s.charAt(0)) && s.charAt(0) != '_' && s.charAt(0) != '.') {
            if (s.indexOf("..") != -1) {
                return false;
            }
            int length = s.length();
            int i = 0;
            while (i < length) {
                char c = s.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isDigit(c) || c == '.')) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static final boolean isValidPackageNameIdentifier(String s) {
        if (s != null && s.length() > 0 && !Character.isDigit(s.charAt(0)) && s.charAt(0) != '_' && s.charAt(0) != '.') {
            if (s.indexOf("..") != -1) {
                return false;
            }
            int length = s.length();
            int i = 0;
            while (i < length) {
                char c = s.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isDigit(c) || c == '.')) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static final boolean isValidProjectNameIdentifier(String s) {
        if (s != null && s.length() > 0 && !Character.isDigit(s.charAt(0)) && s.charAt(0) != '_' && s.charAt(0) != '.' && s.charAt(0) != '-' && s.charAt(0) != '~') {
            int length = s.length();
            int i = 0;
            while (i < length) {
                char c = s.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isDigit(c) || c == '.' || c == '-' || c == '~')) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean isValidTableNameIdentifier(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() > 0 && !Character.isDigit(s.charAt(0)) && s.charAt(0) != '_' && s.charAt(0) != ' ') {
            int length = s.length();
            int i = 0;
            while (i < length) {
                char c = s.charAt(i);
                if (!(c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || c == '_' || Character.isDigit(c))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String concatPathNames(String root, String addition) {
        String outName = null;
        outName = root.endsWith(File.separator) ? root + addition : root + File.separator + addition;
        return outName;
    }

    public static String createPackageName(String providerName, String appName) {
        int idxDot = providerName.indexOf(".");
        if (idxDot != -1) {
            providerName = providerName.substring(idxDot + 1, providerName.length()) + "." + providerName.substring(0, idxDot);
        }
        appName = appName.replace('/', '.');
        appName = appName.toLowerCase();
        return providerName + "." + appName;
    }

    public static String definePhysicalProjectPath(String pathName, String type) {
        String outName = null;
        outName = type.equals("EJB") ? GenerationUtilsDt.concatPathNames(pathName, "ejbModule") : (type.equals("ASSEMBLY") ? GenerationUtilsDt.concatPathNames(pathName, "meta-inf") : (type.equals("DICT") ? GenerationUtilsDt.concatPathNames(pathName, "src" + File.separator + "packages") : (type.equals("DICT_CORE") ? GenerationUtilsDt.concatPathNames(pathName, "src" + File.separator + "packages") : (type.equals("MMR_CORE") || type.equals("MMR") ? GenerationUtilsDt.concatPathNames(pathName, "src") : null))));
        return outName;
    }

    private static String trimmedAppName(String appName) {
        if (appName != null) {
            return appName.replace('.', '_');
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

