/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.generation;

import com.sap.caf.designer.Logger;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.generation.IObjectCodeGenerator;
import com.sap.caf.designer.status.Status;
import com.sap.caf.metamodel.BaseObject;
import com.sap.tc.logging.Location;
import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;

public class GenerationMonitor {
    private IProgressMonitor monitor;
    private int maxGen = 0;
    private int current = 0;
    private Status status = new Status();
    private static final Location logger = Logger.getLocation(class$com$sap$caf$designer$generation$GenerationMonitor == null ? (class$com$sap$caf$designer$generation$GenerationMonitor = GenerationMonitor.class$("com.sap.caf.designer.generation.GenerationMonitor")) : class$com$sap$caf$designer$generation$GenerationMonitor);
    static /* synthetic */ Class class$com$sap$caf$designer$generation$GenerationMonitor;

    public GenerationMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public IProgressMonitor getProgressMonitor() {
        return this.monitor;
    }

    public Status getStatus() {
        return this.status;
    }

    public void registerGeneratedFile(File file) {
        if (file != null) {
            this.monitor.subTask("Generating service " + this.current + " of " + this.maxGen + ". Current file: " + file.getName());
        } else {
            this.monitor.subTask("Generating service " + this.current + " of " + this.maxGen + ".");
        }
    }

    public void registerGeneratedFileAndWork(File file) {
        this.monitor.worked(1);
        ++this.current;
        this.registerGeneratedFile(file);
    }

    public void registerSubTask(String message) {
        this.monitor.subTask(message);
    }

    public void startMonitoring(IObjectCodeGenerator codeGenerator, BaseObject bo) {
        try {
            this.maxGen = codeGenerator.getResourceCountToBeGenerated(bo);
            this.monitor.beginTask("Generation in progress ... ", this.maxGen * 2);
        }
        catch (GeneratorException gex) {
            logger.errorT("An error occured during the generation process.The error is :" + gex.getMessage());
            gex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

