/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.generation;

import com.sap.caf.designer.dtr.IResourceChangeListener;
import com.sap.caf.designer.exception.GeneratorException;
import com.sap.caf.designer.exception.GeneratorNotificationException;
import com.sap.caf.designer.generation.GenerationMonitor;
import com.sap.caf.designer.generation.IObjectCodeGenerator;
import com.sap.caf.metamodel.Application;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.tools.velocity.MainGenerator;
import java.io.File;

public class CAFApplicationGenerator
implements IObjectCodeGenerator {
    private MainGenerator mmrGenerator;

    public CAFApplicationGenerator(MainGenerator generator) {
        this.mmrGenerator = generator;
    }

    public File getGeneratedImplementation(BaseObject bo) throws GeneratorException {
        return this.mmrGenerator.getGeneratedImplementation(bo);
    }

    public int getResourceCountToBeGenerated(BaseObject bo) throws GeneratorException {
        if (bo == null) {
            return 0;
        }
        if (bo instanceof Application) {
            return this.mmrGenerator.getResourceCountToBeGenerated((Application)bo);
        }
        return 1;
    }

    public void eraseGeneratedCode(BaseObject bo, IResourceChangeListener changeListener) throws GeneratorException {
        if (bo instanceof Application) {
            this.mmrGenerator.clearAll((Application)bo, changeListener);
        }
    }

    public void generateObject(BaseObject bo, GenerationMonitor monitor, IResourceChangeListener changeListener) throws GeneratorException, GeneratorNotificationException {
        if (monitor != null) {
            monitor.startMonitoring(this, bo);
        }
        if (bo instanceof Application) {
            this.mmrGenerator.generateApplication((Application)bo, monitor, changeListener);
        } else {
            this.mmrGenerator.generateObject(bo, monitor, changeListener);
        }
    }

    public void generateWDModel(Application app, GenerationMonitor monitor, IResourceChangeListener changeListener) throws GeneratorException, GeneratorNotificationException {
        this.mmrGenerator.generateWDModel(app, monitor.getProgressMonitor(), changeListener);
    }
}

