/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors.datasource.treemappingcomponent;

import com.sap.caf.designer.editors.datasource.treemappingcomponent.TreeMappingCompositeInputChangeEvent;
import com.sap.caf.designer.editors.datasource.treemappingcomponent.TreeMappingCompositeInputChangeListener;
import com.sap.ide.tools.core.treemappingcomponent.MappingObject;
import com.sap.ide.tools.core.treemappingcomponent.listener.TreeMappingListener;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;

public class TreeMappingComposite
extends com.sap.ide.tools.core.treemappingcomponent.tree.TreeMappingComposite
implements TreeMappingListener {
    private Object leftInput;
    private Object rightInput;
    private Object oldLeftInput;
    private Object oldRightInput;
    private ILabelProvider leftLabelProvider;
    private ILabelProvider rightLabelProvider;
    private List mappingListeners;
    private List inputChangeListeners = new LinkedList();

    public TreeMappingComposite(Composite owner, int style) {
        super(owner, style);
        this.setInput(null, null);
        this.oldRightInput = null;
        this.oldLeftInput = null;
        this.rightLabelProvider = null;
        this.leftLabelProvider = null;
        this.mappingListeners = new LinkedList();
        super.addMappingListener((TreeMappingListener)this);
    }

    public void setInput(Object leftInput, Object rightInput) {
        this.leftInput = leftInput == null ? "" : leftInput;
        this.rightInput = rightInput == null ? "" : rightInput;
        this.setInput();
    }

    public void setLabelProvider(ILabelProvider leftLabelProvider, ILabelProvider rightLabelProvider) {
        this.leftLabelProvider = leftLabelProvider;
        this.rightLabelProvider = rightLabelProvider;
        super.setLabelProvider(this.leftLabelProvider, this.rightLabelProvider);
    }

    public void setLeftInput(Object leftInput) {
        this.leftInput = leftInput == null ? "" : leftInput;
        this.setInput();
    }

    public void setLeftLabelProvider(ILabelProvider leftLabelProvider) {
        this.leftLabelProvider = leftLabelProvider;
        super.setLabelProvider(this.leftLabelProvider, this.rightLabelProvider);
    }

    public void setRightInput(Object rightInput) {
        this.rightInput = rightInput == null ? "" : rightInput;
        this.setInput();
    }

    public void setRightLabelProvider(ILabelProvider rightLabelProvider) {
        this.rightLabelProvider = rightLabelProvider;
        super.setLabelProvider(this.leftLabelProvider, this.rightLabelProvider);
    }

    public void addInputChangeListener(TreeMappingCompositeInputChangeListener listener) {
        this.inputChangeListeners.add(listener);
    }

    public void addMappingListener(TreeMappingListener mappingListener) {
        this.mappingListeners.add(mappingListener);
    }

    public void mappingCreated(MappingObject mappingObject) {
        Iterator i = this.mappingListeners.iterator();
        while (i.hasNext()) {
            ((TreeMappingListener)i.next()).mappingCreated(mappingObject);
        }
    }

    public void mappingDeleted(MappingObject mappingObject) {
        Iterator i = this.mappingListeners.iterator();
        while (i.hasNext()) {
            ((TreeMappingListener)i.next()).mappingDeleted(mappingObject);
        }
    }

    public void mappingModified(MappingObject oldMappingObject, MappingObject newMappingObject) {
        Iterator i = this.mappingListeners.iterator();
        while (i.hasNext()) {
            ((TreeMappingListener)i.next()).mappingModified(oldMappingObject, newMappingObject);
        }
    }

    public void removeInputChangeListener(TreeMappingCompositeInputChangeListener listener) {
        this.inputChangeListeners.remove(listener);
    }

    public void removeMappingListener(TreeMappingListener mappingListener) {
        this.mappingListeners.remove(mappingListener);
    }

    private void setInput() {
        this.fireInputToBeChanged(new TreeMappingCompositeInputChangeEvent(this.oldLeftInput, this.oldRightInput, this.leftInput, this.rightInput));
        super.setInput(this.leftInput, this.rightInput);
        this.fireInputChanged(new TreeMappingCompositeInputChangeEvent(this.oldLeftInput, this.oldRightInput, this.leftInput, this.rightInput));
        this.oldLeftInput = this.leftInput;
        this.oldRightInput = this.rightInput;
    }

    private void fireInputChanged(TreeMappingCompositeInputChangeEvent e) {
        Iterator i = this.inputChangeListeners.iterator();
        while (i.hasNext()) {
            ((TreeMappingCompositeInputChangeListener)i.next()).inputChanged(e);
        }
    }

    private void fireInputToBeChanged(TreeMappingCompositeInputChangeEvent e) {
        Iterator i = this.inputChangeListeners.iterator();
        while (i.hasNext()) {
            ((TreeMappingCompositeInputChangeListener)i.next()).inputToBeChanged(e);
        }
    }
}

