/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors.datasource;

import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.editors.datasource.treemappingcomponent.TreeMappingComposite;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFMessageAttribute;
import com.sap.caf.designer.structure.CAFMessageMapping;
import com.sap.caf.designer.structure.CAFOperationMapping;
import com.sap.caf.designer.utils.DatasourceUtils;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.MessageMapping;
import com.sap.caf.metamodel.Operation;
import com.sap.ide.tools.core.treemappingcomponent.MappingObject;
import com.sap.ide.tools.core.treemappingcomponent.TreeMappingValidator;
import com.sap.ide.tools.core.treemappingcomponent.decorator.LinkDecorator;
import com.sap.ide.tools.core.treemappingcomponent.decorator.LinkDecoratorAdapter;
import com.sap.ide.tools.core.treemappingcomponent.listener.TreeMappingListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Table;

public class ParameterMappingTreeMappingManager
extends LinkDecoratorAdapter
implements TreeMappingListener,
TreeMappingValidator,
SelectionListener,
TableModelListener,
BOMSystem.BOMListener {
    private BusinessEntityInterfaceEditor beEditor;
    private CAFBusinessEntityInterface be;
    private CAFOperationMapping opMapping;
    private Set inputColTargets;
    private Set outputColTargets;
    private TreeMappingComposite parameterMappingTree;
    private Table operationMappingTable;
    private TableModel operationMappingTableModel;
    private boolean prohibitCollectionLinksDeletion = true;

    public ParameterMappingTreeMappingManager(BusinessEntityInterfaceEditor beEditor, Table operationMappingTable, TableModel operationMappingTableModel, TreeMappingComposite parameterMappingTree) {
        this.beEditor = beEditor;
        this.be = this.beEditor.getCAFBusinessEntityInterface();
        this.operationMappingTable = operationMappingTable;
        this.operationMappingTableModel = operationMappingTableModel;
        this.parameterMappingTree = parameterMappingTree;
        this.opMapping = null;
        this.inputColTargets = new HashSet();
        this.outputColTargets = new HashSet();
        this.parameterMappingTree.addMappingListener(this);
        this.parameterMappingTree.setValidator(this);
        this.parameterMappingTree.setLinkDecorator((LinkDecorator)this);
        this.operationMappingTable.addSelectionListener((SelectionListener)this);
        this.operationMappingTableModel.addTableModelListener(this);
    }

    public Color getLinkColor(Object source, Object target) {
        if (this.opMapping != null) {
            CAFMessageAttribute left = (CAFMessageAttribute)source;
            CAFMessageAttribute right = (CAFMessageAttribute)target;
            if (!left.isSimple() && left.isCollection() || !right.isSimple() && right.isCollection()) {
                return new Color(null, 0, 128, 0);
            }
        }
        return super.getLinkColor(source, target);
    }

    public int getLinkType(Object source, Object target, boolean isSelected) {
        if (this.opMapping != null) {
            CAFMessageAttribute left = (CAFMessageAttribute)source;
            if (1 == DatasourceUtils.getMessageType(this.opMapping.getOperationMapping().getSource(), left.getMessage())) {
                return 1;
            }
            return 2;
        }
        return 1;
    }

    public Color getSelectedLinkColor(Object source, Object target) {
        CAFMessageAttribute left;
        if (this.opMapping != null && !(left = (CAFMessageAttribute)source).isSimple() && left.isCollection()) {
            return new Color(null, 0, 128, 0);
        }
        return super.getSelectedLinkColor(source, target);
    }

    public boolean allowDelete(MappingObject mappingObject) {
        return this.allowDelete(mappingObject.getSourceNode().getData(), mappingObject.getTargetNode().getData());
    }

    public boolean allowMapping(Object source, Object target, int direction) {
        CAFMessageAttribute extMsgAttr;
        CAFMessageAttribute beMsgAttr;
        if (this.opMapping == null) {
            return false;
        }
        if (!(source instanceof CAFMessageAttribute) || !(target instanceof CAFMessageAttribute)) {
            return false;
        }
        if (direction == 0x2000000) {
            beMsgAttr = (CAFMessageAttribute)target;
            extMsgAttr = (CAFMessageAttribute)source;
        } else {
            beMsgAttr = (CAFMessageAttribute)source;
            extMsgAttr = (CAFMessageAttribute)target;
        }
        if (beMsgAttr.getLastAttribute().getObjectId().equals(extMsgAttr.getLastAttribute().getObjectId())) {
            return false;
        }
        byte msgType = DatasourceUtils.getMessageType(this.opMapping.getOperationMapping().getSource(), beMsgAttr.getMessage());
        switch (msgType) {
            case 1: {
                CAFMessageMapping inputMapping = new CAFMessageMapping(this.be.getBomSystem(), this.opMapping.getOperationMapping().getInput());
                return inputMapping.isAttributeMappingAllowed(extMsgAttr, beMsgAttr);
            }
            case 2: {
                CAFMessageMapping outputMapping = new CAFMessageMapping(this.be.getBomSystem(), this.opMapping.getOperationMapping().getOutput());
                return outputMapping.isAttributeMappingAllowed(beMsgAttr, extMsgAttr);
            }
        }
        return false;
    }

    public boolean allowModify(Object oldSource, Object oldTarget, Object newSource, Object newTarget) {
        return false;
    }

    public void mappingCreated(MappingObject mappingObject) {
        if (this.opMapping == null) {
            return;
        }
        CAFMessageAttribute beMsgAttr = (CAFMessageAttribute)mappingObject.getSourceNode().getData();
        CAFMessageAttribute extMsgAttr = (CAFMessageAttribute)mappingObject.getTargetNode().getData();
        byte msgType = DatasourceUtils.getMessageType(this.opMapping.getOperationMapping().getSource(), beMsgAttr.getMessage());
        switch (msgType) {
            case 1: {
                CAFMessageMapping inputMapping = new CAFMessageMapping(this.be.getBomSystem(), this.opMapping.getOperationMapping().getInput());
                inputMapping.addAttributeMapping(extMsgAttr, beMsgAttr);
                HashSet newColTargets = new HashSet();
                newColTargets.addAll(inputMapping.getCollectionTargets());
                newColTargets.removeAll(this.inputColTargets);
                Iterator i = newColTargets.iterator();
                while (i.hasNext()) {
                    CAFMessageAttribute targetCol = (CAFMessageAttribute)i.next();
                    if (targetCol.isSimple()) continue;
                    CAFMessageAttribute sourceCol = inputMapping.getCollectionMapping(targetCol);
                    this.parameterMappingTree.createLink(sourceCol, targetCol, false);
                }
                this.inputColTargets.clear();
                this.inputColTargets.addAll(inputMapping.getCollectionTargets());
                break;
            }
            case 2: {
                CAFMessageMapping outputMapping = new CAFMessageMapping(this.be.getBomSystem(), this.opMapping.getOperationMapping().getOutput());
                outputMapping.addAttributeMapping(beMsgAttr, extMsgAttr);
                HashSet newColTargets = new HashSet();
                newColTargets.addAll(outputMapping.getCollectionTargets());
                newColTargets.removeAll(this.outputColTargets);
                Iterator i = newColTargets.iterator();
                while (i.hasNext()) {
                    CAFMessageAttribute targetCol = (CAFMessageAttribute)i.next();
                    if (targetCol.isSimple()) continue;
                    CAFMessageAttribute sourceCol = outputMapping.getCollectionMapping(targetCol);
                    this.parameterMappingTree.createLink(targetCol, sourceCol, false);
                }
                this.outputColTargets.clear();
                this.outputColTargets.addAll(outputMapping.getCollectionTargets());
                break;
            }
            default: {
                return;
            }
        }
        this.beEditor.setDirty(true);
    }

    public void mappingDeleted(MappingObject mappingObject) {
        if (this.opMapping == null) {
            return;
        }
        CAFMessageAttribute beMsgAttr = (CAFMessageAttribute)mappingObject.getSourceNode().getData();
        CAFMessageAttribute extMsgAttr = (CAFMessageAttribute)mappingObject.getTargetNode().getData();
        byte msgType = DatasourceUtils.getMessageType(this.opMapping.getOperationMapping().getSource(), beMsgAttr.getMessage());
        switch (msgType) {
            case 1: {
                CAFMessageMapping inputMapping = new CAFMessageMapping(this.be.getBomSystem(), this.opMapping.getOperationMapping().getInput());
                inputMapping.removeAttributeMapping(extMsgAttr);
                this.inputColTargets.removeAll(inputMapping.getCollectionTargets());
                Iterator i = this.inputColTargets.iterator();
                while (i.hasNext()) {
                    CAFMessageAttribute targetCol = (CAFMessageAttribute)i.next();
                    if (targetCol.isSimple()) continue;
                    MappingObject[] links = this.parameterMappingTree.getMappings();
                    int j = 0;
                    while (j < links.length) {
                        if (links[j].getTargetNode().getData().equals(targetCol)) {
                            this.prohibitCollectionLinksDeletion = false;
                            this.parameterMappingTree.deleteLink((CAFMessageAttribute)links[j].getSourceNode().getData(), targetCol, false);
                            this.prohibitCollectionLinksDeletion = true;
                        }
                        ++j;
                    }
                }
                this.inputColTargets.clear();
                this.inputColTargets.addAll(inputMapping.getCollectionTargets());
                break;
            }
            case 2: {
                CAFMessageMapping outputMapping = new CAFMessageMapping(this.be.getBomSystem(), this.opMapping.getOperationMapping().getOutput());
                outputMapping.removeAttributeMapping(beMsgAttr);
                this.outputColTargets.removeAll(outputMapping.getCollectionTargets());
                Iterator i = this.outputColTargets.iterator();
                while (i.hasNext()) {
                    CAFMessageAttribute targetCol = (CAFMessageAttribute)i.next();
                    if (targetCol.isSimple()) continue;
                    MappingObject[] links = this.parameterMappingTree.getMappings();
                    int j = 0;
                    while (j < links.length) {
                        if (links[j].getSourceNode().getData().equals(targetCol)) {
                            this.prohibitCollectionLinksDeletion = false;
                            this.parameterMappingTree.deleteLink(targetCol, (CAFMessageAttribute)links[j].getTargetNode().getData(), false);
                            this.prohibitCollectionLinksDeletion = true;
                        }
                        ++j;
                    }
                }
                this.outputColTargets.clear();
                this.outputColTargets.addAll(outputMapping.getCollectionTargets());
                break;
            }
            default: {
                return;
            }
        }
        this.beEditor.setDirty(true);
    }

    public void mappingModified(MappingObject oldMappingObject, MappingObject newMappingObject) {
        this.mappingDeleted(oldMappingObject);
        this.mappingCreated(newMappingObject);
    }

    public void systemChanged(BOMSystem.BOMEvent e) {
        switch (e.getType()) {
            case 35: 
            case 37: 
            case 39: {
                this.updateInput();
                break;
            }
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.updateInput();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.updateInput();
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateInput();
    }

    private boolean allowDelete(Object source, Object target) {
        if (this.opMapping == null) {
            return false;
        }
        CAFMessageAttribute left = (CAFMessageAttribute)source;
        return !this.prohibitCollectionLinksDeletion || left.isSimple();
    }

    private void clearLinks() {
        MappingObject[] mappings = this.parameterMappingTree.getMappings();
        int i = 0;
        while (i < mappings.length) {
            this.parameterMappingTree.deleteLink(mappings[i], false);
            ++i;
        }
        this.inputColTargets.clear();
        this.outputColTargets.clear();
    }

    private void createLink(boolean input, CAFMessageMapping msgMapping, CAFMessageAttribute targetMsgAttribute) {
        if (targetMsgAttribute.isSimple()) {
            CAFMessageAttribute sourceMsgAttribute = msgMapping.getAttributeMapping(targetMsgAttribute);
            if (sourceMsgAttribute != null) {
                if (input) {
                    this.parameterMappingTree.createLink(sourceMsgAttribute, targetMsgAttribute, false);
                } else {
                    this.parameterMappingTree.createLink(targetMsgAttribute, sourceMsgAttribute, false);
                }
            }
        } else {
            Iterator i = targetMsgAttribute.getOwnedSubAttributes().iterator();
            while (i.hasNext()) {
                this.createLink(input, msgMapping, (CAFMessageAttribute)i.next());
            }
        }
    }

    private void createLinks(boolean input, CAFMessageMapping msgMapping) {
        Message sourceMessage = msgMapping.getMessageMapping().getSource();
        Message targetMessage = msgMapping.getMessageMapping().getTarget();
        Iterator i = targetMessage.getMessageParts().iterator();
        while (i.hasNext()) {
            Attribute attribute = (Attribute)i.next();
            this.createLink(input, msgMapping, new CAFMessageAttribute(this.be.getBomSystem(), targetMessage, attribute));
        }
        if (input) {
            this.inputColTargets.addAll(msgMapping.getCollectionTargets());
            i = this.inputColTargets.iterator();
        } else {
            this.outputColTargets.addAll(msgMapping.getCollectionTargets());
            i = this.outputColTargets.iterator();
        }
        while (i.hasNext()) {
            CAFMessageAttribute targetCol = (CAFMessageAttribute)i.next();
            if (targetCol.isSimple()) continue;
            CAFMessageAttribute sourceCol = msgMapping.getCollectionMapping(targetCol);
            if (input) {
                this.parameterMappingTree.createLink(sourceCol, targetCol, false);
                continue;
            }
            this.parameterMappingTree.createLink(targetCol, sourceCol, false);
        }
    }

    private void createLinks() {
        MessageMapping msgMapping = this.opMapping.getOperationMapping().getInput();
        if (msgMapping != null) {
            this.createLinks(true, new CAFMessageMapping(this.be.getBomSystem(), msgMapping));
        }
        if ((msgMapping = this.opMapping.getOperationMapping().getOutput()) != null) {
            this.createLinks(false, new CAFMessageMapping(this.be.getBomSystem(), msgMapping));
        }
    }

    private synchronized void updateInput() {
        Operation newLeftInput = (Operation)this.operationMappingTableModel.getValueAt(this.operationMappingTable.getSelectionIndex(), 0);
        Operation newRightInput = (Operation)this.operationMappingTableModel.getValueAt(this.operationMappingTable.getSelectionIndex(), 1);
        this.clearLinks();
        this.parameterMappingTree.setInput(newLeftInput, newRightInput);
        if (newLeftInput == null) {
            this.opMapping = null;
            return;
        }
        this.opMapping = this.be.getOperationMappingByOperation(newLeftInput);
        if (this.opMapping != null && newRightInput != null && this.opMapping.getOperationMapping().getTarget().getObjectId().equals(newRightInput.getObjectId())) {
            this.createLinks();
        }
    }
}

