/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors.datasource;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.datasource.treemappingcomponent.TreeMappingCompositeInputChangeEvent;
import com.sap.caf.designer.editors.datasource.treemappingcomponent.TreeMappingCompositeInputChangeListener;
import com.sap.caf.designer.structure.CAFMessageAttribute;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import org.eclipse.jface.viewers.LabelProvider;

public class ParameterMappingTreeLabelProvider
extends LabelProvider
implements TreeMappingCompositeInputChangeListener {
    private static final TextPool textPool = TextPool.getInstance();
    private Operation operation = null;
    private boolean left;

    public ParameterMappingTreeLabelProvider(boolean left) {
        this.left = left;
    }

    public String getText(Object element) {
        if (this.operation != null) {
            if (element instanceof CAFMessageAttribute) {
                CAFMessageAttribute msgAttr = (CAFMessageAttribute)element;
                String label = msgAttr.getLastAttribute().getObjectName();
                if (msgAttr.isCollection()) {
                    label = label + textPool.getText("BOM_DATASOURCE_0014");
                }
                return label;
            }
            if (element instanceof Message) {
                Message message = (Message)element;
                if (this.operation.getInput() != null && message.getObjectId().equals(this.operation.getInput().getObjectId())) {
                    return textPool.getText("BOM_DATASOURCE_0007");
                }
                if (this.operation.getOutput() != null && message.getObjectId().equals(this.operation.getOutput().getObjectId())) {
                    return textPool.getText("BOM_DATASOURCE_0008");
                }
            }
        }
        return "";
    }

    public void inputChanged(TreeMappingCompositeInputChangeEvent e) {
    }

    public void inputToBeChanged(TreeMappingCompositeInputChangeEvent e) {
        Object newInput = this.left ? e.getNewLeftInput() : e.getNewRightInput();
        this.operation = newInput != null && newInput instanceof Operation ? (Operation)newInput : null;
    }
}

