/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors.datasource;

import com.sap.caf.designer.editors.datasource.ParameterMappingTreeLabelProvider;
import com.sap.caf.designer.editors.datasource.treemappingcomponent.TreeMappingComposite;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFMessageAttribute;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataStructure;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.Operation;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ParameterMappingTreeContentProvider
implements ITreeContentProvider {
    private Operation operation = null;
    private boolean left;
    private TreeMappingComposite parameterMappingTree;
    private BOMSystem bomSystem;

    public ParameterMappingTreeContentProvider(boolean left, TreeMappingComposite parameterMappingTree, BOMSystem bomSystem) {
        this.left = left;
        this.parameterMappingTree = parameterMappingTree;
        this.bomSystem = bomSystem;
        ParameterMappingTreeLabelProvider labelProvider = new ParameterMappingTreeLabelProvider(this.left);
        if (this.left) {
            this.parameterMappingTree.setLeftLabelProvider((ILabelProvider)labelProvider);
        } else {
            this.parameterMappingTree.setRightLabelProvider((ILabelProvider)labelProvider);
        }
        this.parameterMappingTree.addInputChangeListener(labelProvider);
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Message) {
            Message message = (Message)parentElement;
            List attributes = message.getMessageParts();
            LinkedList<CAFMessageAttribute> retVal = new LinkedList<CAFMessageAttribute>();
            Iterator i = attributes.iterator();
            while (i.hasNext()) {
                Attribute attribute = (Attribute)i.next();
                if (CAFBusinessEntityInterface.isEntityAttribute(attribute)) continue;
                retVal.add(new CAFMessageAttribute(this.bomSystem, message, attribute));
            }
            return retVal.toArray();
        }
        if (parentElement instanceof CAFMessageAttribute) {
            CAFMessageAttribute msgAttribute = (CAFMessageAttribute)parentElement;
            List subAtttributes = msgAttribute.getOwnedSubAttributes();
            Object[] retVal = new Object[subAtttributes.size()];
            Iterator i = subAtttributes.iterator();
            int j = 0;
            while (i.hasNext()) {
                retVal[j] = i.next();
                ++j;
            }
            return retVal;
        }
        return new Object[0];
    }

    public Object[] getElements(Object inputElement) {
        if (this.operation == null) {
            return new Object[]{""};
        }
        Message inputMessage = this.operation.getInput();
        Message outputMessage = this.operation.getOutput();
        Object[] messages = new Object[(inputMessage != null ? 1 : 0) + (outputMessage != null ? 1 : 0)];
        int j = 0;
        if (inputMessage != null) {
            messages[j] = inputMessage;
            ++j;
        }
        if (outputMessage != null) {
            messages[j] = outputMessage;
            ++j;
        }
        if (messages.length == 0) {
            return new Object[]{""};
        }
        return messages;
    }

    public Object getParent(Object element) {
        if (element instanceof CAFMessageAttribute) {
            CAFMessageAttribute msgAttribute = (CAFMessageAttribute)element;
            List parentAttributes = msgAttribute.getAttributesWithoutLast();
            if (parentAttributes == null) {
                return msgAttribute.getMessage();
            }
            return new CAFMessageAttribute(this.bomSystem, msgAttribute.getMessage(), parentAttributes);
        }
        return null;
    }

    public void dispose() {
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Message) {
            return !((Message)element).getMessageParts().isEmpty();
        }
        if (element instanceof CAFMessageAttribute) {
            CAFMessageAttribute msgAttribute = (CAFMessageAttribute)element;
            DataStructure ds = msgAttribute.getLastAttribute().getReferencedObject();
            if (ds != null) {
                return !ds.getAttributes().isEmpty();
            }
            return false;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.operation = newInput != null && newInput instanceof Operation ? (Operation)newInput : null;
    }
}

