/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors.datasource;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.editors.datasource.treemappingcomponent.TreeMappingComposite;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFMessageAttribute;
import com.sap.caf.designer.structure.CAFMessageMapping;
import com.sap.caf.designer.structure.CAFOperationMapping;
import com.sap.caf.designer.utils.DatasourceUtils;
import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.Message;
import com.sap.caf.metamodel.MessageMapping;
import com.sap.caf.metamodel.Operation;
import com.sap.ide.tools.core.treemappingcomponent.MappingObject;
import com.sap.ide.tools.core.treemappingcomponent.listener.TreeMappingListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Table;

public class ParameterMappingTableModel
extends AbstractTableModel
implements SelectionListener,
TableModelListener,
TreeMappingListener,
BOMSystem.BOMListener {
    private static final TextPool textPool = TextPool.getInstance();
    private Table operationMappingTable;
    private TableModel operationMappingTableModel;
    private TreeMappingComposite parameterMappingTree;
    private BusinessEntityInterfaceEditor beEditor;
    private CAFBusinessEntityInterface be;
    private CAFOperationMapping opMapping;
    private List inputTargetParameters;
    private List outputTargetParameters;

    public ParameterMappingTableModel(BusinessEntityInterfaceEditor beEditor, Table operationMappingTable, TableModel operationMappingTableModel, TreeMappingComposite parameterMappingTree) {
        this.beEditor = beEditor;
        this.be = this.beEditor.getCAFBusinessEntityInterface();
        this.opMapping = null;
        this.inputTargetParameters = null;
        this.outputTargetParameters = null;
        this.operationMappingTable = operationMappingTable;
        this.operationMappingTableModel = operationMappingTableModel;
        this.parameterMappingTree = parameterMappingTree;
        this.operationMappingTable.addSelectionListener((SelectionListener)this);
        this.operationMappingTableModel.addTableModelListener(this);
        this.parameterMappingTree.addMappingListener(this);
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 2) {
            Object isNull = this.getValueAt(rowIndex, 3);
            return (Boolean)isNull == false;
        }
        return columnIndex == 3;
    }

    public int getColumnCount() {
        return 4;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return textPool.getText("BOM_DATASOURCE_0010");
            }
            case 1: {
                return textPool.getText("BOM_DATASOURCE_0011");
            }
            case 2: {
                return textPool.getText("BOM_DATASOURCE_0012");
            }
            case 3: {
                return textPool.getText("BOM_DATASOURCE_0013");
            }
        }
        return "";
    }

    public List getInputTargetParameters() {
        return this.inputTargetParameters;
    }

    public CAFOperationMapping getOperationMapping() {
        return this.opMapping;
    }

    public List getOutputTargetParameters() {
        return this.outputTargetParameters;
    }

    public int getRowCount() {
        return (this.inputTargetParameters != null ? this.inputTargetParameters.size() : 0) + (this.outputTargetParameters != null ? this.outputTargetParameters.size() : 0);
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String sourceConstant;
        if (this.opMapping == null) {
            return;
        }
        switch (columnIndex) {
            case 2: {
                sourceConstant = (String)aValue;
                break;
            }
            case 3: {
                boolean isSourceConstantNull = (Boolean)aValue;
                sourceConstant = isSourceConstantNull ? null : "";
                break;
            }
            default: {
                return;
            }
        }
        CAFMessageAttribute beMsgAttr = (CAFMessageAttribute)this.getValueAt(rowIndex, 0);
        CAFMessageAttribute extMsgAttr = (CAFMessageAttribute)this.getValueAt(rowIndex, 1);
        byte msgType = beMsgAttr != null ? DatasourceUtils.getMessageType(this.opMapping.getOperationMapping().getSource(), beMsgAttr.getMessage()) : DatasourceUtils.getMessageType(this.opMapping.getOperationMapping().getTarget(), extMsgAttr.getMessage());
        switch (msgType) {
            case 1: {
                CAFMessageMapping inputMapping = new CAFMessageMapping(this.be.getBomSystem(), this.opMapping.getOperationMapping().getInput());
                if (sourceConstant != null) {
                    inputMapping.addConstantMapping(extMsgAttr, sourceConstant);
                    break;
                }
                inputMapping.removeConstantMapping(extMsgAttr);
                break;
            }
            case 2: {
                CAFMessageMapping outputMapping = new CAFMessageMapping(this.be.getBomSystem(), this.opMapping.getOperationMapping().getOutput());
                if (sourceConstant != null) {
                    outputMapping.addConstantMapping(beMsgAttr, sourceConstant);
                    break;
                }
                outputMapping.removeConstantMapping(beMsgAttr);
                break;
            }
            default: {
                return;
            }
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
        if (columnIndex == 3) {
            this.fireTableCellUpdated(rowIndex, 2);
        }
        this.beEditor.setDirty(true);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Object retVal;
        int inputSize = this.inputTargetParameters != null ? this.inputTargetParameters.size() : 0;
        int outputSize = this.outputTargetParameters != null ? this.outputTargetParameters.size() : 0;
        CAFMessageAttribute beMsgAttribute = null;
        CAFMessageAttribute extMsgAttribute = null;
        String sourceConstant = null;
        if (rowIndex < inputSize) {
            extMsgAttribute = (CAFMessageAttribute)this.inputTargetParameters.get(rowIndex);
            if (columnIndex != 1) {
                CAFMessageMapping inputMapping = new CAFMessageMapping(this.be.getBomSystem(), this.opMapping.getOperationMapping().getInput());
                beMsgAttribute = inputMapping.getAttributeMapping(extMsgAttribute);
                sourceConstant = inputMapping.getConstantMapping(extMsgAttribute);
            }
        } else if (rowIndex >= inputSize && rowIndex < inputSize + outputSize) {
            beMsgAttribute = (CAFMessageAttribute)this.outputTargetParameters.get(rowIndex -= inputSize);
            if (columnIndex != 0) {
                CAFMessageMapping outputMapping = new CAFMessageMapping(this.be.getBomSystem(), this.opMapping.getOperationMapping().getOutput());
                extMsgAttribute = outputMapping.getAttributeMapping(beMsgAttribute);
                sourceConstant = outputMapping.getConstantMapping(beMsgAttribute);
            }
        }
        switch (columnIndex) {
            case 0: {
                retVal = beMsgAttribute;
                break;
            }
            case 1: {
                retVal = extMsgAttribute;
                break;
            }
            case 2: {
                retVal = sourceConstant != null ? sourceConstant : "";
                break;
            }
            case 3: {
                retVal = new Boolean(sourceConstant == null);
                break;
            }
            default: {
                retVal = null;
            }
        }
        return retVal;
    }

    public void mappingCreated(MappingObject mappingObject) {
        if (this.opMapping == null) {
            return;
        }
        CAFMessageAttribute beMsgAttr = (CAFMessageAttribute)mappingObject.getSourceNode().getData();
        CAFMessageAttribute extMsgAttr = (CAFMessageAttribute)mappingObject.getTargetNode().getData();
        byte msgType = DatasourceUtils.getMessageType(this.opMapping.getOperationMapping().getSource(), beMsgAttr.getMessage());
        switch (msgType) {
            case 1: {
                int rowIndex = this.inputTargetParameters.indexOf(extMsgAttr);
                if (rowIndex == -1) break;
                this.fireTableCellUpdated(rowIndex, 0);
                break;
            }
            case 2: {
                int rowIndex = this.outputTargetParameters.indexOf(beMsgAttr);
                if (rowIndex == -1) break;
                if (this.inputTargetParameters != null) {
                    rowIndex += this.inputTargetParameters.size();
                }
                this.fireTableCellUpdated(rowIndex, 1);
                break;
            }
        }
    }

    public void mappingDeleted(MappingObject mappingObject) {
        this.mappingCreated(mappingObject);
    }

    public void mappingModified(MappingObject oldMappingObject, MappingObject newMappingObject) {
        this.mappingDeleted(oldMappingObject);
        this.mappingCreated(newMappingObject);
    }

    public void systemChanged(BOMSystem.BOMEvent e) {
        switch (e.getType()) {
            case 35: 
            case 37: 
            case 39: {
                this.updateInput();
                break;
            }
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.updateInput();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.updateInput();
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateInput();
    }

    private static List getAllLeafMessageAttributes(CAFMessageAttribute msgAttribute) {
        ArrayList<CAFMessageAttribute> retVal = new ArrayList<CAFMessageAttribute>();
        Iterator i = msgAttribute.getOwnedSubAttributes().iterator();
        while (i.hasNext()) {
            CAFMessageAttribute currentMsgAttribute = (CAFMessageAttribute)i.next();
            if (currentMsgAttribute.isSimple()) {
                retVal.add(currentMsgAttribute);
                continue;
            }
            retVal.addAll(ParameterMappingTableModel.getAllLeafMessageAttributes(currentMsgAttribute));
        }
        return retVal;
    }

    private List getAllLeafMessageAttributes(Message msg) {
        ArrayList<CAFMessageAttribute> retVal = new ArrayList<CAFMessageAttribute>();
        Iterator i = msg.getMessageParts().iterator();
        while (i.hasNext()) {
            CAFMessageAttribute currentMsgAttribute = new CAFMessageAttribute(this.be.getBomSystem(), msg, (Attribute)i.next());
            if (currentMsgAttribute.isSimple()) {
                retVal.add(currentMsgAttribute);
                continue;
            }
            retVal.addAll(ParameterMappingTableModel.getAllLeafMessageAttributes(currentMsgAttribute));
        }
        return retVal;
    }

    private synchronized void updateInput() {
        Operation newLeftInput = (Operation)this.operationMappingTableModel.getValueAt(this.operationMappingTable.getSelectionIndex(), 0);
        Operation newRightInput = (Operation)this.operationMappingTableModel.getValueAt(this.operationMappingTable.getSelectionIndex(), 1);
        this.inputTargetParameters = null;
        this.outputTargetParameters = null;
        if (newLeftInput == null) {
            this.opMapping = null;
        } else {
            this.opMapping = this.be.getOperationMappingByOperation(newLeftInput);
            if (this.opMapping != null && newRightInput != null && this.opMapping.getOperationMapping().getTarget().getObjectId().equals(newRightInput.getObjectId())) {
                MessageMapping inputMapping = this.opMapping.getOperationMapping().getInput();
                this.inputTargetParameters = inputMapping != null ? this.getAllLeafMessageAttributes(inputMapping.getTarget()) : null;
                MessageMapping outputMapping = this.opMapping.getOperationMapping().getOutput();
                this.outputTargetParameters = outputMapping != null ? this.getAllLeafMessageAttributes(outputMapping.getTarget()) : null;
            }
        }
        this.fireTableDataChanged();
    }
}

