/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors.datasource;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.datasource.ParameterMappingTableModel;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFMessageAttribute;
import com.sap.caf.designer.structure.CAFMessageMapping;
import com.sap.caf.designer.structure.CAFOperationMapping;
import com.tssap.util.ui.image.SapIdeUtilImages;
import com.tssap.util.ui.viewer.table.SapTableRow;
import java.util.List;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Table;

public class ParameterMappingTableLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private static final TextPool textPool = TextPool.getInstance();
    private static final Image checkedImage = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJS_COMPLETE_TSK");
    private static final Image uncheckedImage = SapIdeUtilImages.getWorkbenchImage((String)"IMG_OBJS_INCOMPLETE_TSK");
    private CAFBusinessEntityInterface be;
    private ParameterMappingTableModel parameterMappingTableModel;
    private Table parameterMappingTable;

    public ParameterMappingTableLabelProvider(CAFBusinessEntityInterface be, ParameterMappingTableModel parameterMappingTableModel, Table parameterMappingTable) {
        this.be = be;
        this.parameterMappingTableModel = parameterMappingTableModel;
        this.parameterMappingTable = parameterMappingTable;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex != 3) {
            return null;
        }
        List inputTargetParameters = this.parameterMappingTableModel.getInputTargetParameters();
        List outputTargetParameters = this.parameterMappingTableModel.getOutputTargetParameters();
        CAFOperationMapping opMapping = this.parameterMappingTableModel.getOperationMapping();
        int rowIndex = ((SapTableRow)element).getRowNum();
        int inputSize = inputTargetParameters != null ? inputTargetParameters.size() : 0;
        int outputSize = outputTargetParameters != null ? outputTargetParameters.size() : 0;
        CAFMessageAttribute beMsgAttribute = null;
        CAFMessageAttribute extMsgAttribute = null;
        String sourceConstant = null;
        if (rowIndex < inputSize) {
            extMsgAttribute = (CAFMessageAttribute)inputTargetParameters.get(rowIndex);
            if (columnIndex != 1) {
                CAFMessageMapping inputMapping = new CAFMessageMapping(this.be.getBomSystem(), opMapping.getOperationMapping().getInput());
                sourceConstant = inputMapping.getConstantMapping(extMsgAttribute);
            }
        } else if (rowIndex >= inputSize && rowIndex < inputSize + outputSize) {
            beMsgAttribute = (CAFMessageAttribute)outputTargetParameters.get(rowIndex -= inputSize);
            if (columnIndex != 0) {
                CAFMessageMapping outputMapping = new CAFMessageMapping(this.be.getBomSystem(), opMapping.getOperationMapping().getOutput());
                sourceConstant = outputMapping.getConstantMapping(beMsgAttribute);
            }
        }
        if (sourceConstant == null) {
            return checkedImage;
        }
        return uncheckedImage;
    }

    public String getColumnText(Object element, int columnIndex) {
        CAFMessageAttribute msgAttribute;
        if (columnIndex == 3) {
            return "";
        }
        List inputOrder = this.parameterMappingTableModel.getInputTargetParameters();
        List outputOrder = this.parameterMappingTableModel.getOutputTargetParameters();
        CAFOperationMapping opMapping = this.parameterMappingTableModel.getOperationMapping();
        int rowIndex = ((SapTableRow)element).getRowNum();
        String prefix = "";
        int inputSize = inputOrder != null ? inputOrder.size() : 0;
        int outputSize = outputOrder != null ? outputOrder.size() : 0;
        CAFMessageAttribute beMsgAttribute = null;
        CAFMessageAttribute extMsgAttribute = null;
        String sourceConstant = null;
        if (rowIndex < inputSize) {
            prefix = prefix + textPool.getText("BOM_DATASOURCE_0007");
            extMsgAttribute = (CAFMessageAttribute)inputOrder.get(rowIndex);
            if (columnIndex != 1) {
                CAFMessageMapping inputMapping = new CAFMessageMapping(this.be.getBomSystem(), opMapping.getOperationMapping().getInput());
                beMsgAttribute = inputMapping.getAttributeMapping(extMsgAttribute);
                sourceConstant = inputMapping.getConstantMapping(extMsgAttribute);
            }
        } else if (rowIndex >= inputSize && rowIndex < inputSize + outputSize) {
            prefix = prefix + textPool.getText("BOM_DATASOURCE_0008");
            beMsgAttribute = (CAFMessageAttribute)outputOrder.get(rowIndex -= inputSize);
            if (columnIndex != 0) {
                CAFMessageMapping outputMapping = new CAFMessageMapping(this.be.getBomSystem(), opMapping.getOperationMapping().getOutput());
                extMsgAttribute = outputMapping.getAttributeMapping(beMsgAttribute);
                sourceConstant = outputMapping.getConstantMapping(beMsgAttribute);
            }
        }
        switch (columnIndex) {
            case 0: {
                msgAttribute = beMsgAttribute;
                break;
            }
            case 1: {
                msgAttribute = extMsgAttribute;
                break;
            }
            case 2: {
                return sourceConstant != null ? sourceConstant : "";
            }
            default: {
                return "";
            }
        }
        if (msgAttribute != null) {
            return prefix + " -> " + msgAttribute.getResolvedName();
        }
        return "";
    }
}

