/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors.datasource;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFBusinessEntityInterface;
import com.sap.caf.designer.structure.CAFOperationMapping;
import com.sap.caf.metamodel.BaseObject;
import com.sap.caf.metamodel.MessageMapping;
import com.sap.caf.metamodel.MetamodelPackage;
import com.sap.caf.metamodel.Operation;
import com.sap.caf.metamodel.OperationMapping;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class OperationMappingTableModel
extends AbstractTableModel
implements BOMSystem.BOMListener {
    private static final TextPool textPool = TextPool.getInstance();
    private BusinessEntityInterfaceEditor beEditor;
    private CAFBusinessEntityInterface be;
    private boolean readOnly = false;
    private List tableData;

    public OperationMappingTableModel(BusinessEntityInterfaceEditor beEditor) {
        this.beEditor = beEditor;
        this.be = this.beEditor.getCAFBusinessEntityInterface();
        this.tableData = new ArrayList();
        this.setTableData();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex == 1;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return textPool.getText("BOM_DATASOURCE_0001");
            }
            case 1: {
                return textPool.getText("BOM_DATASOURCE_0002");
            }
        }
        return "";
    }

    public int getRowCount() {
        return this.tableData.size();
    }

    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.readOnly) {
            return;
        }
        try {
            if (columnIndex == 1) {
                Operation oldExtOp = (Operation)this.getValueAt(rowIndex, 1);
                Operation extOp = aValue instanceof Operation ? (Operation)aValue : null;
                if (!(oldExtOp == null && extOp == null || oldExtOp != null && extOp != null && oldExtOp.getObjectId().equals(extOp.getObjectId()))) {
                    Operation beOp = (Operation)this.tableData.get(rowIndex);
                    if (extOp != null) {
                        MetamodelPackage metamodelPackage = this.be.getBomSystem().getMetamodelPackage();
                        CAFOperationMapping oldOpMapping = this.be.getOperationMappingByOperation(beOp);
                        if (oldOpMapping != null) {
                            oldOpMapping.remove();
                        }
                        OperationMapping opMapping = metamodelPackage.getOperationMapping().createOperationMapping();
                        opMapping.setSource(beOp);
                        opMapping.setTarget(extOp);
                        if (beOp.getInput() != null && extOp.getInput() != null) {
                            MessageMapping inputMapping = metamodelPackage.getMessageMapping().createMessageMapping();
                            BOMSystem.baseObjectCreated((BaseObject)inputMapping);
                            inputMapping.setSource(beOp.getInput());
                            inputMapping.setTarget(extOp.getInput());
                            opMapping.setInput(inputMapping);
                        }
                        if (beOp.getOutput() != null && extOp.getOutput() != null) {
                            MessageMapping outputMapping = metamodelPackage.getMessageMapping().createMessageMapping();
                            BOMSystem.baseObjectCreated((BaseObject)outputMapping);
                            outputMapping.setSource(extOp.getOutput());
                            outputMapping.setTarget(beOp.getOutput());
                            opMapping.setOutput(outputMapping);
                        }
                        metamodelPackage.getBusinessObjectInterfaceOperationMapping().add(this.be.getBusinesEntityInterface(), opMapping);
                    } else {
                        CAFOperationMapping opMapping = this.be.getOperationMappingByOperation(beOp);
                        if (opMapping != null) {
                            opMapping.remove();
                        }
                    }
                    this.fireTableCellUpdated(rowIndex, columnIndex);
                    this.beEditor.setDirty(true);
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            // empty catch block
        }
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                try {
                    return (Operation)this.tableData.get(rowIndex);
                }
                catch (IndexOutOfBoundsException e) {
                    return null;
                }
            }
            case 1: {
                try {
                    Operation beOp = (Operation)this.tableData.get(rowIndex);
                    CAFOperationMapping opMapping = this.be.getOperationMappingByOperation(beOp);
                    if (opMapping != null) {
                        return opMapping.getOperationMapping().getTarget();
                    }
                    return null;
                }
                catch (IndexOutOfBoundsException e) {
                    return null;
                }
            }
        }
        return null;
    }

    public void systemChanged(BOMSystem.BOMEvent e) {
        switch (e.getType()) {
            case 15: 
            case 17: 
            case 25: 
            case 27: 
            case 29: {
                this.readOnly = true;
                this.setTableData();
                this.fireTableDataChanged();
                this.readOnly = false;
                break;
            }
            case 35: {
                this.recreateMessageMappings();
                break;
            }
        }
    }

    protected void setTableData() {
        this.tableData.clear();
        Iterator it = this.be.getBusinesEntityInterface().getOperations().iterator();
        while (it.hasNext()) {
            Operation op = (Operation)it.next();
            boolean useIt = true;
            int i = 0;
            while (i < CAFBusinessEntityInterface.KMOperations.length) {
                if (CAFBusinessEntityInterface.KMOperations[i].equals(op.getObjectName())) {
                    useIt = false;
                }
                ++i;
            }
            if (useIt && op.getPatternType() == 5 && op.getObjectName().equals("findByMultipleParameters")) {
                useIt = false;
            }
            if (!useIt) continue;
            this.tableData.add(op);
        }
    }

    private void recreateMessageMappings() {
        Iterator i = this.tableData.iterator();
        while (i.hasNext()) {
            Operation beOp = (Operation)i.next();
            CAFOperationMapping opMapping = this.be.getOperationMappingByOperation(beOp);
            if (opMapping == null) continue;
            Operation extOp = opMapping.getOperationMapping().getTarget();
            if (opMapping.getOperationMapping().getInput() == null && beOp.getInput() != null && extOp.getInput() != null) {
                MessageMapping inputMapping = this.beEditor.getBOMSystem().getMetamodelPackage().getMessageMapping().createMessageMapping();
                BOMSystem.baseObjectCreated((BaseObject)inputMapping);
                inputMapping.setSource(beOp.getInput());
                inputMapping.setTarget(extOp.getInput());
                opMapping.getOperationMapping().setInput(inputMapping);
            }
            if (opMapping.getOperationMapping().getOutput() != null || beOp.getOutput() == null || extOp.getOutput() == null) continue;
            MessageMapping outputMapping = this.beEditor.getBOMSystem().getMetamodelPackage().getMessageMapping().createMessageMapping();
            BOMSystem.baseObjectCreated((BaseObject)outputMapping);
            outputMapping.setSource(extOp.getOutput());
            outputMapping.setTarget(beOp.getOutput());
            opMapping.getOperationMapping().setOutput(outputMapping);
        }
    }
}

