/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors.datasource;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.datasource.ExternalOperationTreeContentProvider;
import com.sap.caf.designer.editors.datasource.ExternalOperationTreeLabelProvider;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.structure.CAFExternalInterface;
import com.sap.caf.metamodel.ExternalInterface;
import com.sap.caf.metamodel.Operation;
import com.tssap.util.ui.dialog.StructuredObjectSelectionDialog;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jface.viewers.DialogCellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class OperationMappingTableDialogCellEditor
extends DialogCellEditor
implements BOMSystem.BOMListener {
    private static final TextPool textPool = TextPool.getInstance();
    private ExternalInterface[] externalInterfaces;
    private BOMSystem bomSystem;

    public OperationMappingTableDialogCellEditor(Composite parent, BOMSystem bomSystem) {
        super(parent);
        this.bomSystem = bomSystem;
        this.refreshExternalInterfaces();
    }

    public void systemChanged(BOMSystem.BOMEvent e) {
        switch (e.getType()) {
            case 13: 
            case 15: 
            case 17: {
                this.refreshExternalInterfaces();
                break;
            }
        }
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        StructuredObjectSelectionDialog dialog = new StructuredObjectSelectionDialog(cellEditorWindow.getShell(), textPool.getText("BOM_DATASOURCE_0003"), textPool.getText("BOM_DATASOURCE_0004"));
        dialog.setExpandTreeLevel(2);
        dialog.setTreeInput((Object)this.externalInterfaces);
        dialog.setPreGrayedObjects((Object[])this.externalInterfaces);
        dialog.setLabelProvider((ILabelProvider)new ExternalOperationTreeLabelProvider());
        dialog.openDialog((ITreeContentProvider)new ExternalOperationTreeContentProvider(), true, 5);
        if (dialog.getReturnCode() == 0) {
            Object[] selected = dialog.getResult();
            if (selected == null || selected.length == 0) {
                return "";
            }
            return selected[0];
        }
        return this.getValue();
    }

    protected void updateContents(Object value) {
        Label defaultLabel = this.getDefaultLabel();
        if (defaultLabel == null) {
            return;
        }
        String text = "";
        if (value != null && value instanceof Operation) {
            Operation operation = (Operation)value;
            text = operation.getMOFInterface().getObjectName() + " -> " + operation.getObjectName();
        }
        defaultLabel.setText(text);
    }

    private synchronized void refreshExternalInterfaces() {
        Collection cafExternalInterfaces = this.bomSystem.getExternalInterfaces().values();
        Iterator i = cafExternalInterfaces.iterator();
        int j = 0;
        this.externalInterfaces = new ExternalInterface[cafExternalInterfaces.size()];
        while (i.hasNext()) {
            this.externalInterfaces[j] = ((CAFExternalInterface)i.next()).getExternalInterface();
            ++j;
        }
    }
}

