/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.designer.editors.datasource;

import com.sap.caf.designer.TextPool;
import com.sap.caf.designer.editors.BusinessEntityInterfaceEditor;
import com.sap.caf.designer.editors.datasource.OperationMappingTableDialogCellEditor;
import com.sap.caf.designer.editors.datasource.OperationMappingTableLabelProvider;
import com.sap.caf.designer.editors.datasource.OperationMappingTableModel;
import com.sap.caf.designer.editors.datasource.ParameterMappingTableLabelProvider;
import com.sap.caf.designer.editors.datasource.ParameterMappingTableModel;
import com.sap.caf.designer.editors.datasource.ParameterMappingTreeContentProvider;
import com.sap.caf.designer.editors.datasource.ParameterMappingTreeMappingManager;
import com.sap.caf.designer.editors.datasource.treemappingcomponent.TreeMappingComposite;
import com.sap.caf.designer.structure.BOMSystem;
import com.sap.caf.designer.utils.TableColumnResizer;
import com.tssap.util.ui.pane.IGridLayoutPane;
import com.tssap.util.ui.pane.ISashPane;
import javax.swing.table.TableModel;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;

public class DatasourcePage {
    private static final TextPool textPool = TextPool.getInstance();
    private BOMSystem bomSystem;
    private OperationMappingTableModel operationMappingTableModel;
    private OperationMappingTableDialogCellEditor operationMappingTableDialogCellEditor;
    private ParameterMappingTableModel parameterMappingTableModel;
    private ParameterMappingTreeMappingManager parameterMappingTreeMappingManager;

    public void createTabContents(IGridLayoutPane tabPane, BusinessEntityInterfaceEditor beEditor) {
        this.bomSystem = beEditor.getBOMSystem();
        ISashPane outerSashPane = tabPane.addVerticalSashPane(tabPane.createGridLayoutData(4, 4, true, true, 1, 1));
        this.operationMappingTableModel = new OperationMappingTableModel(beEditor);
        this.bomSystem.addSystemListener(this.operationMappingTableModel);
        TableViewer operationMappingTableViewer = outerSashPane.addSapTableViewer((TableModel)this.operationMappingTableModel, true).getTableViewer();
        Table operationMappingTable = operationMappingTableViewer.getTable();
        OperationMappingTableLabelProvider labelProvider = new OperationMappingTableLabelProvider(this.operationMappingTableModel);
        operationMappingTableViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.operationMappingTableDialogCellEditor = new OperationMappingTableDialogCellEditor((Composite)operationMappingTable, beEditor.getBOMSystem());
        this.bomSystem.addSystemListener(this.operationMappingTableDialogCellEditor);
        operationMappingTableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)operationMappingTable), this.operationMappingTableDialogCellEditor});
        operationMappingTable.addControlListener((ControlListener)new TableColumnResizer(operationMappingTable, new int[]{1, 2}));
        ISashPane parameterMappingPane = outerSashPane.addVerticalSashPane();
        TreeMappingComposite parameterMappingTree = new TreeMappingComposite(parameterMappingPane.addSimplePane().getComposite(), 0);
        parameterMappingTree.setLayout((Layout)new FillLayout());
        parameterMappingTree.setLeftTreeHeader(textPool.getText("BOM_DATASOURCE_0005"), 0x1000000);
        parameterMappingTree.setRightTreeHeader(textPool.getText("BOM_DATASOURCE_0006"), 0x1000000);
        parameterMappingTree.setEnableDragDrop(0x6000000, true);
        parameterMappingTree.setEnableMappingContextMenu(true);
        parameterMappingTree.setVisibleExtensionLine(true);
        parameterMappingTree.setContentProvider(new ParameterMappingTreeContentProvider(true, parameterMappingTree, beEditor.getBOMSystem()), new ParameterMappingTreeContentProvider(false, parameterMappingTree, beEditor.getBOMSystem()));
        this.parameterMappingTreeMappingManager = new ParameterMappingTreeMappingManager(beEditor, operationMappingTable, this.operationMappingTableModel, parameterMappingTree);
        this.bomSystem.addSystemListener(this.parameterMappingTreeMappingManager);
        ISashPane parameterMappingTablePane = parameterMappingPane.addVerticalSashPane();
        this.parameterMappingTableModel = new ParameterMappingTableModel(beEditor, operationMappingTable, this.operationMappingTableModel, parameterMappingTree);
        this.bomSystem.addSystemListener(this.parameterMappingTableModel);
        TableViewer parameterMappingTableViewer = parameterMappingTablePane.addSapTableViewer((TableModel)this.parameterMappingTableModel, true).getTableViewer();
        Table parameterMappingTable = parameterMappingTableViewer.getTable();
        parameterMappingTableViewer.setLabelProvider((IBaseLabelProvider)new ParameterMappingTableLabelProvider(beEditor.getCAFBusinessEntityInterface(), this.parameterMappingTableModel, parameterMappingTable));
        parameterMappingTableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)parameterMappingTable), new TextCellEditor((Composite)parameterMappingTable), new TextCellEditor((Composite)parameterMappingTable), new CheckboxCellEditor((Composite)parameterMappingTable)});
        parameterMappingTable.addControlListener((ControlListener)new TableColumnResizer(parameterMappingTable, new int[]{8, 8, 4, 1}));
        outerSashPane.setWeights(new int[]{1, 3});
        parameterMappingPane.setWeights(new int[]{3, 2});
    }

    public void dispose() {
        this.bomSystem.removeSystemListener(this.parameterMappingTableModel);
        this.bomSystem.removeSystemListener(this.parameterMappingTreeMappingManager);
        this.bomSystem.removeSystemListener(this.operationMappingTableDialogCellEditor);
        this.bomSystem.removeSystemListener(this.operationMappingTableModel);
    }
}

